/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.registries;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.schema.MultilingualSchemaPlugin;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import springfox.documentation.annotations.ApiIgnore;

@EnableWebMvc
@Service
@RequestMapping(value={"/{portal}/api/registries/entries", "/{portal}/api/0.1/registries/entries"})
@Api(value="registries", tags={"registries"}, description="Registries related operations")
public class DirectoryEntriesApi {
    @Autowired
    SchemaManager schemaManager;
    @Autowired
    IMetadataUtils metadataRepository;
    @Autowired
    GeonetworkDataDirectory dataDirectory;
    private static final char SEPARATOR = '~';

    @ApiOperation(value="Get a directory entry", nickname="getEntry", notes="Directory entry (AKA subtemplates) are XML fragments that can be inserted in metadata records using XLinks. XLinks can be remote or local.")
    @RequestMapping(value={"/{uuid:.+}"}, method={RequestMethod.GET}, produces={"application/xml"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Directory entry."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    @ResponseBody
    public Element getEntry(@ApiParam(value="Directory entry UUID.", required=true) @PathVariable String uuid, @ApiParam(value="Process", required=false) @RequestParam(required=false) String[] process, @ApiParam(value="Transformation", required=false) @RequestParam(required=false) String transformation, @ApiParam(value="lang", required=false) @RequestParam(name="lang", required=false) String[] langs, @ApiParam(value="schema", required=false) @RequestParam(required=false, defaultValue="iso19139") String schema, @ApiIgnore HttpServletRequest request) throws Exception {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        AbstractMetadata metadata = this.metadataRepository.findOneByUuid(uuid);
        if (metadata == null) {
            throw new ResourceNotFoundException(String.format("Directory entry with UUID '%s' not found in this registry.", uuid));
        }
        if (metadata.getDataInfo().getType() != MetadataType.SUB_TEMPLATE) {
            throw new IllegalArgumentException(String.format("The record found with UUID '%s' is not a subtemplate", uuid));
        }
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            if (langs == null) {
                langs = context.getLanguage().split(",");
            }
            Element tpl = metadata.getXmlData(false);
            if (process != null) {
                List<String> replaceList = Arrays.asList(process);
                for (String parameters : replaceList) {
                    int endIndex = parameters.indexOf(126);
                    if (endIndex == -1) continue;
                    String xpath = parameters.substring(0, endIndex);
                    String value = parameters.substring(endIndex + 1);
                    HashSet allNamespaces = Sets.newHashSet();
                    Iterator descendants = tpl.getDescendants();
                    while (descendants.hasNext()) {
                        Object next = descendants.next();
                        if (!(next instanceof Element)) continue;
                        Element element = (Element)next;
                        allNamespaces.add(element.getNamespace());
                        for (Object o : tpl.getAdditionalNamespaces()) {
                            if (!(o instanceof Namespace)) continue;
                            Namespace namespace = (Namespace)o;
                            allNamespaces.add(namespace);
                        }
                    }
                    Object o = Xml.selectSingle((Element)tpl, (String)xpath, (List)Lists.newArrayList((Iterable)allNamespaces));
                    if (o instanceof Element) {
                        ((Element)o).setText(value);
                        continue;
                    }
                    if (!(o instanceof Attribute)) continue;
                    ((Attribute)o).setValue(value);
                }
            }
            ArrayList<String> templateLangs = new ArrayList<String>();
            for (String l : langs) {
                templateLangs.add("#" + l);
            }
            MultilingualSchemaPlugin plugin = (MultilingualSchemaPlugin)this.schemaManager.getSchema(schema).getSchemaPlugin();
            if (plugin != null) {
                plugin.removeTranslationFromElement(tpl, templateLangs);
            }
            if (transformation != null) {
                Element root = new Element("root");
                Element requestElt = new Element("request");
                requestElt.addContent((Content)new Element("transformation").setText(transformation));
                root.addContent((Content)requestElt);
                root.addContent((Content)tpl);
                Path xslt = this.dataDirectory.getWebappDir().resolve("xslt/services/subtemplate/convert.xsl");
                Element element = Xml.transform((Element)root, (Path)xslt);
                return element;
            }
            Element element = tpl;
            return element;
        }
    }
}

