/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.api.exception.NoResultsFoundException;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.SavedQuery;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Service
@RequestMapping(value={"/{portal}/api/records/{metadataUuid}", "/{portal}/api/0.1/records/{metadataUuid}"})
@Api(value="records", tags={"records"}, description="Metadata record operations")
public class MetadataSavedQueryApi {
    private static final String LOG_MODULE = "MetadataApi";
    @Autowired
    private SchemaManager schemaManager;

    @ApiOperation(value="List saved queries for this metadata", nickname="getMetadataSavedQueries")
    @RequestMapping(value={"/query"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="Saved query available."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    public List<SavedQuery> getSavedQueries(@ApiParam(value="Record UUID.", required=true) @PathVariable String metadataUuid, HttpServletRequest request) throws Exception {
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, context);
            String schemaIdentifier = metadata.getDataInfo().getSchemaId();
            SchemaPlugin schemaPlugin = this.schemaManager.getSchema(schemaIdentifier).getSchemaPlugin();
            if (schemaPlugin == null) {
                ArrayList<SavedQuery> arrayList = new ArrayList<SavedQuery>();
                return arrayList;
            }
            MetadataSchema schema = this.schemaManager.getSchema(schemaIdentifier);
            List list = schema.getSchemaPlugin().getSavedQueries();
            return list;
        }
    }

    /*
     * Loose catch block
     */
    @ApiOperation(value="Apply a saved query for this metadata", nickname="applyQuery", notes="All parameters will be substituted to the XPath query. eg. {{protocol}} in the XPath expression will be replaced by the protocol parameter provided in the request body.")
    @RequestMapping(value={"/query/{savedQuery}"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of matching elements. If element are nodes, then they are returned as string."), @ApiResponse(code=403, message="Operation not allowed. User needs to be able to view the resource.")})
    public Map<String, String> applyQuery(@ApiParam(value="The metadata UUID", required=true, example="43d7c186-2187-4bcd-8843-41e575a5ef56") @PathVariable String metadataUuid, @ApiParam(value="The saved query to apply", required=true, example="wfs-indexing-config") @PathVariable String savedQuery, HttpServletRequest request, @ApiParam(value="The query parameters") @RequestBody(required=false) HashMap<String, String> parameters) throws Exception {
        Throwable throwable = null;
        try (ServiceContext context = ApiUtils.createServiceContext(request);){
            String xpath;
            block34: {
                AbstractMetadata metadata = ApiUtils.canViewRecord(metadataUuid, context);
                String schemaIdentifier = metadata.getDataInfo().getSchemaId();
                SchemaPlugin schemaPlugin = this.schemaManager.getSchema(schemaIdentifier).getSchemaPlugin();
                if (schemaPlugin == null) {
                    throw new ResourceNotFoundException(String.format("Saved query '%s' for schema '%s' not found.", savedQuery, schemaIdentifier));
                }
                SavedQuery query = schemaPlugin.getSavedQuery(savedQuery);
                if (query == null) {
                    throw new ResourceNotFoundException(String.format("Saved query '%s' for schema '%s' not found. Available queries are '%s'.", savedQuery, schemaIdentifier, schemaPlugin.getSavedQueries()));
                }
                xpath = query.getXpath();
                if (Log.isDebugEnabled((String)LOG_MODULE)) {
                    Log.debug((String)LOG_MODULE, (Object)String.format("Saved query XPath: %s", xpath));
                }
                if (parameters != null) {
                    for (String parameter : parameters.keySet()) {
                        xpath = xpath.replaceAll("\\{\\{" + parameter + "\\}\\}", parameters.get(parameter));
                    }
                }
                if (Log.isDebugEnabled((String)LOG_MODULE)) {
                    Log.debug((String)LOG_MODULE, (Object)String.format("Saved query XPath after URL parameters substitution %s", xpath));
                }
                HashMap<String, String> response = new HashMap<String, String>();
                ArrayList nss = new ArrayList(schemaPlugin.getNamespaces());
                List matchingElement = Xml.selectNodes((Element)metadata.getXmlData(false), (String)xpath, nss);
                int counter = 0;
                String queryCleanValues = query.getCleanValues();
                if (matchingElement != null) {
                    for (Object o : matchingElement) {
                        String key = String.valueOf(counter);
                        String value = null;
                        if (o instanceof Element) {
                            List valuesToClean;
                            String label;
                            Element e = (Element)o;
                            if (query.getLabel() != null && (label = Xml.selectString((Element)e, (String)query.getLabel(), nss)) != null) {
                                key = label;
                            }
                            if (queryCleanValues != null && (valuesToClean = Xml.selectNodes((Element)e, (String)queryCleanValues, nss)) != null) {
                                for (Object v : valuesToClean) {
                                    if (v instanceof Element) {
                                        ((Element)v).setText("");
                                        continue;
                                    }
                                    if (v instanceof Attribute) {
                                        ((Attribute)v).setValue("");
                                        continue;
                                    }
                                    if (!(v instanceof Text)) continue;
                                    ((Text)v).setText("");
                                }
                            }
                            value = Xml.getString((Element)e);
                        } else if (o instanceof Attribute) {
                            value = ((Attribute)o).getValue();
                        } else if (o instanceof Text) {
                            value = ((Text)o).getText();
                        }
                        response.put(key, value);
                        ++counter;
                    }
                }
                if (response.size() <= 0) break block34;
                HashMap<String, String> hashMap = response;
                return hashMap;
                {
                    catch (JDOMException e) {
                        throw new IllegalArgumentException(String.format("Error in query: %s. Saved query parameters are '%s'.", e.getMessage(), query.getParameters()));
                    }
                }
            }
            try {
                throw new NoResultsFoundException(String.format("No results found in metadata '%s' for query '%s'.", metadataUuid, xpath));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

