/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.processing.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.processing.report.ErrorReport;
import org.fao.geonet.api.processing.report.IProcessingReport;
import org.fao.geonet.api.processing.report.InfoReport;
import org.fao.geonet.api.processing.report.Report;
import org.fao.geonet.api.processing.report.registry.IRegisteredProcess;
import org.fao.geonet.api.processing.report.registry.ProcessingReportRegistry;
import org.fao.geonet.domain.ISODate;
import org.springframework.context.ConfigurableApplicationContext;

@XmlRootElement(name="report")
@XmlType(propOrder={"uuid", "startIsoDateTime", "endIsoDateTime", "ellapsedTimeInSeconds", "totalTimeInSeconds"})
@XmlAccessorType(value=XmlAccessType.PUBLIC_MEMBER)
public abstract class ProcessingReport
implements IProcessingReport,
IRegisteredProcess {
    protected List<Report> errors = Collections.synchronizedList(new ArrayList());
    protected List<InfoReport> infos = Collections.synchronizedList(new ArrayList());
    private ProcessingReportRegistry registry;
    private String uuid = UUID.randomUUID().toString();
    private ISODate startDateTime;
    private ISODate endDateTime;

    public ProcessingReport() {
        this.processStart();
        this.register();
    }

    @Override
    @XmlAttribute
    public String getUuid() {
        return this.uuid;
    }

    @Override
    @XmlAttribute
    public String getType() {
        return this.getClass().getSimpleName();
    }

    @Override
    @XmlAttribute
    public String getStartIsoDateTime() {
        return this.startDateTime.getDateAndTime();
    }

    @Override
    @XmlAttribute
    public String getEndIsoDateTime() {
        return this.endDateTime == null ? "" : this.endDateTime.getDateAndTime();
    }

    @Override
    public void processStart() {
        this.startDateTime = new ISODate();
    }

    @Override
    public void processEnd() {
        this.endDateTime = new ISODate();
    }

    @Override
    public void close() {
        this.processEnd();
        this.unregister();
    }

    @Override
    @XmlAttribute
    public long getEllapsedTimeInSeconds() {
        return new ISODate().timeDifferenceInSeconds(this.startDateTime);
    }

    @Override
    @XmlAttribute
    public long getTotalTimeInSeconds() {
        return this.endDateTime == null ? -1L : this.endDateTime.timeDifferenceInSeconds(this.startDateTime);
    }

    @Override
    public boolean isRunning() {
        return false;
    }

    @Override
    public void register() {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        this.registry = (ProcessingReportRegistry)applicationContext.getBean(ProcessingReportRegistry.class);
        if (this.registry != null) {
            this.registry.add(this);
        }
    }

    @Override
    public void unregister() {
        if (this.registry != null) {
            this.registry.remove(this.getUuid());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.unregister();
    }

    @XmlElement(name="errors")
    public List<Report> getErrors() {
        return this.errors;
    }

    public synchronized void addError(Exception error) {
        this.errors.add(new ErrorReport(error));
    }

    @XmlElement(name="infos")
    public List<InfoReport> getInfos() {
        return this.infos;
    }

    public synchronized void addInfos(String message) {
        this.infos.add(new InfoReport(message));
    }
}

