/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rackspace.clouddns.v1.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rackspace.clouddns.v1.domain.RecordDetail;
import org.jclouds.rackspace.clouddns.v1.domain.Subdomain;

public class Domain {
    private final int id;
    private final String name;
    private final String email;
    private final Optional<String> comment;
    private final Date created;
    private final Date updated;
    private final int accountId;
    private final int ttl;
    private final Set<String> nameservers;
    private final Set<Subdomain> subdomains;
    private final Set<RecordDetail> records;

    @ConstructorProperties(value={"id", "name", "emailAddress", "comment", "created", "updated", "accountId", "ttl", "nameservers", "subdomains", "recordsList"})
    protected Domain(int id, String name, String email, @Nullable String comment, Date created, Date updated, int accountId, int ttl, @Nullable Set<String> nameservers, @Nullable Set<Subdomain> nameToSubdomain, @Nullable Set<RecordDetail> records) {
        this.id = id;
        this.name = name;
        this.email = email;
        this.comment = Optional.fromNullable((Object)comment);
        this.created = created;
        this.updated = updated;
        this.accountId = accountId;
        this.ttl = ttl;
        this.nameservers = nameservers != null ? nameservers : ImmutableSet.of();
        this.subdomains = nameToSubdomain != null ? nameToSubdomain : ImmutableSet.of();
        this.records = records != null ? records : ImmutableSet.of();
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public int getTTL() {
        return this.ttl;
    }

    public Set<String> getNameservers() {
        return this.nameservers;
    }

    public Set<Subdomain> getSubdomains() {
        return this.subdomains;
    }

    public Set<RecordDetail> getRecords() {
        return this.records;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Domain that = (Domain)Domain.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id);
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", this.id).add("name", (Object)this.name).add("email", (Object)this.email).add("comment", this.comment.orNull()).add("created", (Object)this.created).add("updated", (Object)this.updated).add("accountId", this.accountId).add("ttl", this.ttl).add("nameservers", this.nameservers).add("subdomains", this.subdomains).add("records", this.records);
    }

    public String toString() {
        return this.string().toString();
    }

    protected Domain from(Domain in) {
        return new Domain(in.getId(), in.getName(), in.getEmail(), (String)in.getComment().orNull(), in.getCreated(), in.getUpdated(), in.getAccountId(), in.getTTL(), in.getNameservers(), in.getSubdomains(), in.getRecords());
    }

    public static enum Format {
        BIND_9,
        UNRECOGNIZED;


        public static Format fromValue(String format) {
            try {
                return Format.valueOf(((String)Preconditions.checkNotNull((Object)format, (Object)"format")).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

