/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import javax.jms.Message;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;

public class JmsPollingConsumer
extends PollingConsumerSupport {
    private JmsOperations template;
    private JmsEndpoint jmsEndpoint;

    public JmsPollingConsumer(JmsEndpoint endpoint, JmsOperations template) {
        super((Endpoint)endpoint);
        this.jmsEndpoint = endpoint;
        this.template = template;
    }

    public JmsEndpoint getEndpoint() {
        return (JmsEndpoint)super.getEndpoint();
    }

    public Exchange receiveNoWait() {
        return this.receive(-1L);
    }

    public Exchange receive() {
        return this.receive(0L);
    }

    public Exchange receive(long timeout) {
        this.setReceiveTimeout(timeout);
        Message message = ObjectHelper.isNotEmpty((Object)this.jmsEndpoint.getSelector()) ? this.template.receiveSelected(this.jmsEndpoint.getSelector()) : this.template.receive();
        if (message != null) {
            return this.getEndpoint().createExchange(message);
        }
        return null;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    protected void setReceiveTimeout(long timeout) {
        if (!(this.template instanceof JmsTemplate)) {
            throw new IllegalArgumentException("Cannot set the receiveTimeout property on unknown JmsOperations type: " + this.template.getClass().getName());
        }
        JmsTemplate jmsTemplate = (JmsTemplate)this.template;
        jmsTemplate.setReceiveTimeout(timeout);
    }
}

