/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.BodyOwner;
import com.github.sommeri.less4j.core.ast.GeneralBody;
import com.github.sommeri.less4j.core.ast.Name;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.List;

public class PageMarginBox
extends ASTCssNode
implements BodyOwner<GeneralBody> {
    private Name name;
    private GeneralBody body;

    public PageMarginBox(HiddenTokenAwareTree token) {
        super(token);
    }

    public PageMarginBox(HiddenTokenAwareTree token, Name name) {
        super(token);
        this.name = name;
    }

    public Name getName() {
        return this.name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public void setName(Name name) {
        this.name = name;
    }

    @Override
    public GeneralBody getBody() {
        return this.body;
    }

    @Override
    public void setBody(GeneralBody body) {
        this.body = body;
    }

    @NotAstProperty
    public List<ASTCssNode> getChilds() {
        return ArraysUtils.asNonNullList(this.name, this.body);
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.PAGE_MARGIN_BOX;
    }

    @Override
    public PageMarginBox clone() {
        PageMarginBox result = (PageMarginBox)super.clone();
        result.body = this.body == null ? null : this.body.clone();
        result.name = this.name == null ? null : this.name.clone();
        result.configureParentToAllChilds();
        return result;
    }
}

