/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.config;

import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.aop.target.LazyInitTargetSource;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.data.auditing.AuditingHandler;
import org.springframework.data.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AuditingHandlerBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String AUDITOR_AWARE_REF = "auditor-aware-ref";

    protected Class<?> getBeanClass(Element element) {
        return AuditingHandler.class;
    }

    protected boolean shouldGenerateId() {
        return true;
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String auditorAwareRef = element.getAttribute(AUDITOR_AWARE_REF);
        if (StringUtils.hasText((String)auditorAwareRef)) {
            builder.addPropertyValue("auditorAware", (Object)this.createLazyInitTargetSourceBeanDefinition(auditorAwareRef));
        }
        ParsingUtils.setPropertyValue(builder, element, "set-dates", "dateTimeForNow");
        ParsingUtils.setPropertyReference(builder, element, "date-time-provider-ref", "dateTimeProvider");
        ParsingUtils.setPropertyValue(builder, element, "modify-on-creation", "modifyOnCreation");
    }

    private BeanDefinition createLazyInitTargetSourceBeanDefinition(String auditorAwareRef) {
        BeanDefinitionBuilder targetSourceBuilder = BeanDefinitionBuilder.rootBeanDefinition(LazyInitTargetSource.class);
        targetSourceBuilder.addPropertyValue("targetBeanName", (Object)auditorAwareRef);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ProxyFactoryBean.class);
        builder.addPropertyValue("targetSource", (Object)targetSourceBuilder.getBeanDefinition());
        return builder.getBeanDefinition();
    }
}

