/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QualifiedNameValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public final class NotationValue
extends QualifiedNameValue {
    public NotationValue(String prefix, String uri, String localName, NameChecker checker) throws XPathException {
        if (checker != null && !checker.isValidNCName(localName)) {
            XPathException err = new XPathException("Malformed local name in NOTATION: '" + localName + '\'');
            err.setErrorCode("FORG0001");
            throw err;
        }
        prefix = prefix == null ? "" : prefix;
        String string = uri = uri == null ? "" : uri;
        if (checker != null && uri.length() == 0 && prefix.length() != 0) {
            XPathException err = new XPathException("NOTATION has null namespace but non-empty prefix");
            err.setErrorCode("FOCA0002");
            throw err;
        }
        this.qName = new StructuredQName(prefix, uri, localName);
        this.typeLabel = BuiltInAtomicType.NOTATION;
    }

    public NotationValue(String prefix, String uri, String localName) {
        this.qName = new StructuredQName(prefix, uri, localName);
        this.typeLabel = BuiltInAtomicType.NOTATION;
    }

    public NotationValue(String prefix, String uri, String localName, AtomicType typeLabel) {
        this.qName = new StructuredQName(prefix, uri, localName);
        this.typeLabel = typeLabel;
    }

    public AtomicValue copyAsSubType(AtomicType typeLabel) {
        NotationValue v = new NotationValue(this.getPrefix(), this.getNamespaceURI(), this.getLocalName());
        v.typeLabel = typeLabel;
        return v;
    }

    public BuiltInAtomicType getPrimitiveType() {
        return BuiltInAtomicType.NOTATION;
    }

    public ConversionResult convertPrimitive(BuiltInAtomicType requiredType, boolean validate, XPathContext context) {
        switch (requiredType.getPrimitiveType()) {
            case 531: 
            case 632: {
                return this;
            }
            case 513: {
                return new StringValue(this.getStringValue());
            }
            case 631: {
                return new UntypedAtomicValue(this.getStringValue());
            }
        }
        ValidationFailure err = new ValidationFailure("Cannot convert NOTATION to " + requiredType.getDisplayName());
        err.setErrorCode("XPTY0004");
        return err;
    }

    public boolean equals(Object other) {
        return this.qName.equals(((NotationValue)other).qName);
    }

    public Comparable getSchemaComparable() {
        return new NotationComparable();
    }

    public String toString() {
        return "NOTATION(" + this.getClarkName() + ')';
    }

    private class NotationComparable
    implements Comparable {
        private NotationComparable() {
        }

        public NotationValue getNotationValue() {
            return NotationValue.this;
        }

        public int compareTo(Object o) {
            return this.equals(o) ? 0 : Integer.MIN_VALUE;
        }

        public boolean equals(Object o) {
            return o instanceof NotationComparable && NotationValue.this.qName.equals(((NotationComparable)o).getNotationValue().qName);
        }

        public int hashCode() {
            return NotationValue.this.qName.hashCode();
        }
    }
}

