/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import javax.media.jai.Interpolation;
import javax.media.jai.OperationNode;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.remote.SerializableRenderedImage;
import org.geotools.coverage.AbstractCoverage;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.coverage.grid.GeneralGridEnvelope;
import org.geotools.coverage.grid.GridCoordinates2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.RenderedSampleDimension;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.Envelope2D;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.util.Classes;
import org.geotools.util.factory.Hints;
import org.opengis.coverage.CannotEvaluateException;
import org.opengis.coverage.PointOutsideCoverageException;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;

public class GridCoverage2D
extends AbstractGridCoverage {
    private static final long serialVersionUID = 667472989475027853L;
    private static final PixelInCell PIXEL_IN_CELL = PixelInCell.CELL_CORNER;
    protected final transient PlanarImage image;
    private RenderedImage serializedImage;
    protected final GridGeometry2D gridGeometry;
    final GridSampleDimension[] sampleDimensions;
    transient String tileEncoding;

    public GridCoverage2D(CharSequence name, GridCoverage2D coverage) {
        super(name, coverage);
        this.image = coverage.image;
        this.gridGeometry = coverage.gridGeometry;
        this.sampleDimensions = coverage.sampleDimensions;
        this.tileEncoding = coverage.tileEncoding;
    }

    protected GridCoverage2D(CharSequence name, PlanarImage image, GridGeometry2D gridGeometry, GridSampleDimension[] bands, GridCoverage[] sources, Map<?, ?> properties, Hints hints) throws IllegalArgumentException {
        super(name, gridGeometry.getCoordinateReferenceSystem(), sources, (PropertySource)image, properties);
        this.image = image;
        this.sampleDimensions = new GridSampleDimension[image.getNumBands()];
        RenderedSampleDimension.create(name, (RenderedImage)image, bands, this.sampleDimensions);
        int dimension = this.crs.getCoordinateSystem().getDimension();
        if (!gridGeometry.isDefined(4)) {
            GeneralGridEnvelope r = new GeneralGridEnvelope((RenderedImage)image, dimension);
            gridGeometry = gridGeometry.isDefined(8) ? new GridGeometry2D((GridEnvelope)r, PIXEL_IN_CELL, gridGeometry.getGridToCRS(PIXEL_IN_CELL), this.crs, hints) : new GridGeometry2D(r, gridGeometry.getEnvelope());
        } else {
            gridGeometry.getGridToCRS();
        }
        this.gridGeometry = gridGeometry;
        assert (gridGeometry.isDefined(15));
        String error = GridGeometry2D.checkConsistency((RenderedImage)image, gridGeometry);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        if (dimension <= Math.max(gridGeometry.axisDimensionX, gridGeometry.axisDimensionY) || !(gridGeometry.envelope.getSpan(gridGeometry.axisDimensionX) > 0.0) || !(gridGeometry.envelope.getSpan(gridGeometry.axisDimensionY) > 0.0)) {
            throw new IllegalArgumentException(Errors.format((int)47));
        }
    }

    @Override
    public boolean isDataEditable() {
        return this.image instanceof WritableRenderedImage;
    }

    public GridGeometry2D getGridGeometry() {
        String error = GridGeometry2D.checkConsistency((RenderedImage)this.image, this.gridGeometry);
        if (error != null) {
            throw new IllegalStateException(error);
        }
        return this.gridGeometry;
    }

    @Override
    public Envelope getEnvelope() {
        return this.gridGeometry.getEnvelope();
    }

    public Envelope2D getEnvelope2D() {
        return this.gridGeometry.getEnvelope2D();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem2D() {
        return this.gridGeometry.getCoordinateReferenceSystem2D();
    }

    public int getNumSampleDimensions() {
        return this.sampleDimensions.length;
    }

    public GridSampleDimension getSampleDimension(int index) {
        return this.sampleDimensions[index];
    }

    public GridSampleDimension[] getSampleDimensions() {
        return (GridSampleDimension[])this.sampleDimensions.clone();
    }

    public Interpolation getInterpolation() {
        return Interpolation.getInstance((int)0);
    }

    public Object evaluate(DirectPosition point) throws CannotEvaluateException {
        int dataType = this.image.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                return this.evaluate(point, (byte[])null);
            }
            case 1: 
            case 2: 
            case 3: {
                return this.evaluate(point, (int[])null);
            }
            case 4: {
                return this.evaluate(point, (float[])null);
            }
            case 5: {
                return this.evaluate(point, (double[])null);
            }
        }
        throw new CannotEvaluateException();
    }

    @Override
    public byte[] evaluate(DirectPosition coord, byte[] dest) throws CannotEvaluateException {
        int[] array = this.evaluate(coord, (int[])null);
        if (dest == null) {
            dest = new byte[array.length];
        }
        for (int i = 0; i < array.length; ++i) {
            dest[i] = (byte)array[i];
        }
        return dest;
    }

    @Override
    public int[] evaluate(DirectPosition coord, int[] dest) throws CannotEvaluateException {
        return this.evaluate(this.gridGeometry.toPoint2D(coord), dest);
    }

    @Override
    public float[] evaluate(DirectPosition coord, float[] dest) throws CannotEvaluateException {
        return this.evaluate(this.gridGeometry.toPoint2D(coord), dest);
    }

    @Override
    public double[] evaluate(DirectPosition coord, double[] dest) throws CannotEvaluateException {
        return this.evaluate(this.gridGeometry.toPoint2D(coord), dest);
    }

    public int[] evaluate(Point2D coord, int[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    public float[] evaluate(Point2D coord, float[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    public double[] evaluate(Point2D coord, double[] dest) throws CannotEvaluateException {
        Point2D pixel = this.gridGeometry.inverseTransform(coord);
        double fx = pixel.getX();
        double fy = pixel.getY();
        if (!Double.isNaN(fx) && !Double.isNaN(fy)) {
            int x = (int)Math.round(fx);
            int y = (int)Math.round(fy);
            if (this.image.getBounds().contains(x, y)) {
                return this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y)).getPixel(x, y, dest);
            }
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    public int[] evaluate(GridCoordinates2D coord, int[] dest) {
        if (this.image.getBounds().contains(coord.x, coord.y)) {
            return this.image.getTile(this.image.XToTileX(coord.x), this.image.YToTileY(coord.y)).getPixel(coord.x, coord.y, dest);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    public float[] evaluate(GridCoordinates2D coord, float[] dest) {
        if (this.image.getBounds().contains(coord.x, coord.y)) {
            return this.image.getTile(this.image.XToTileX(coord.x), this.image.YToTileY(coord.y)).getPixel(coord.x, coord.y, dest);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    public double[] evaluate(GridCoordinates2D coord, double[] dest) {
        if (this.image.getBounds().contains(coord.x, coord.y)) {
            return this.image.getTile(this.image.XToTileX(coord.x), this.image.YToTileY(coord.y)).getPixel(coord.x, coord.y, dest);
        }
        throw new PointOutsideCoverageException(this.formatEvaluateError(coord, true));
    }

    public synchronized String getDebugString(DirectPosition coord) {
        Point2D pixel = this.gridGeometry.toPoint2D(coord);
        pixel = this.gridGeometry.inverseTransform(pixel);
        int x = (int)Math.round(pixel.getX());
        int y = (int)Math.round(pixel.getY());
        if (this.image.getBounds().contains(x, y)) {
            int numBands = this.image.getNumBands();
            Raster raster = this.image.getTile(this.image.XToTileX(x), this.image.YToTileY(y));
            int datatype = this.image.getSampleModel().getDataType();
            StringBuilder buffer = new StringBuilder();
            buffer.append('(').append(x).append(',').append(y).append(")=[");
            for (int band = 0; band < numBands; ++band) {
                if (band != 0) {
                    buffer.append(";\u00a0");
                }
                double sample = raster.getSampleDouble(x, y, band);
                switch (datatype) {
                    case 5: {
                        buffer.append(sample);
                        break;
                    }
                    case 4: {
                        buffer.append((float)sample);
                        break;
                    }
                    default: {
                        buffer.append((int)sample);
                    }
                }
                String formatted = this.sampleDimensions[band].getLabel(sample, null);
                if (formatted == null) continue;
                buffer.append("\u00a0(").append(formatted).append(')');
            }
            return buffer.append(']').toString();
        }
        return null;
    }

    public int[] getOptimalDataBlockSizes() {
        int[] size = new int[this.getDimension()];
        Arrays.fill(size, 1);
        size[this.gridGeometry.gridDimensionX] = this.image.getTileWidth();
        size[this.gridGeometry.gridDimensionY] = this.image.getTileHeight();
        return size;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    @Override
    public RenderableImage getRenderableImage(int xAxis, int yAxis) {
        if (xAxis == this.gridGeometry.axisDimensionX && yAxis == this.gridGeometry.axisDimensionY) {
            return new Renderable();
        }
        return super.getRenderableImage(xAxis, yAxis);
    }

    @Override
    public void show(String title, int xAxis, int yAxis) {
        if (title == null || (title = title.trim()).length() == 0) {
            StringBuilder buffer = new StringBuilder(String.valueOf(this.getName()));
            int visibleBandIndex = CoverageUtilities.getVisibleBand((Object)this);
            GridSampleDimension visibleBand = this.getSampleDimension(visibleBandIndex);
            Unit unit = visibleBand.getUnits();
            buffer.append(" - ").append(String.valueOf(visibleBand.getDescription()));
            if (unit != null) {
                buffer.append(" (").append(unit).append(')');
            }
            title = buffer.toString();
        }
        super.show(title, xAxis, yAxis);
    }

    @Override
    public void show(String title) {
        this.show(title, this.gridGeometry.axisDimensionX, this.gridGeometry.axisDimensionY);
    }

    public void prefetch(Rectangle2D area) {
        Point[] tileIndices = this.image.getTileIndices(this.gridGeometry.inverseTransform(area));
        if (tileIndices != null) {
            this.image.prefetchTiles(tileIndices);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        try {
            Field field = GridCoverage2D.class.getDeclaredField("image");
            field.setAccessible(true);
            field.set((Object)this, PlanarImage.wrapRenderedImage((RenderedImage)this.serializedImage));
        }
        catch (NoSuchFieldException cause) {
            InvalidClassException e = new InvalidClassException(cause.getLocalizedMessage());
            e.initCause(cause);
            throw e;
        }
        catch (IllegalAccessException cause) {
            InvalidObjectException e = new InvalidObjectException(cause.getLocalizedMessage());
            e.initCause(cause);
            throw e;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.serializedImage == null) {
            Object source = this.image;
            while (source instanceof RenderedImageAdapter) {
                source = ((RenderedImageAdapter)source).getWrappedImage();
            }
            if (source instanceof SerializableRenderedImage) {
                this.serializedImage = (SerializableRenderedImage)source;
            } else {
                if (this.tileEncoding == null) {
                    this.tileEncoding = "gzip";
                }
                this.serializedImage = new SerializableRenderedImage((RenderedImage)source, false, null, this.tileEncoding, null, null);
                LogRecord record = Loggings.format((Level)Level.FINE, (int)16, (Object)this.getName(), (Object)this.tileEncoding);
                record.setSourceClassName(GridCoverage2D.class.getName());
                record.setSourceMethodName("writeObject");
                record.setLoggerName(LOGGER.getName());
                LOGGER.log(record);
            }
        }
        out.defaultWriteObject();
    }

    @Override
    public synchronized boolean dispose(boolean force) {
        if (!this.disposeImage(force)) {
            return false;
        }
        return super.dispose(force);
    }

    final synchronized boolean disposeImage(boolean force) {
        Vector sinks;
        if (!force && (sinks = this.image.getSinks()) != null && !sinks.isEmpty()) {
            return false;
        }
        this.image.dispose();
        return true;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        String lineSeparator = System.getProperty("line.separator", "\n");
        buffer.append("\u2514 Image=").append(Classes.getShortClassName((Object)this.image)).append('[');
        if (this.image instanceof OperationNode) {
            buffer.append('\"').append(((OperationNode)this.image).getOperationName()).append('\"');
        }
        buffer.append(']');
        return buffer.append(lineSeparator).toString();
    }

    protected class Renderable
    extends AbstractCoverage.Renderable {
        private static final long serialVersionUID = 4544636336787905450L;

        public Renderable() {
            super(GridCoverage2D.this, GridCoverage2D.this.gridGeometry.axisDimensionX, GridCoverage2D.this.gridGeometry.axisDimensionY);
        }

        @Override
        public RenderedImage createDefaultRendering() {
            if (this.xAxis == GridCoverage2D.this.gridGeometry.axisDimensionX && this.yAxis == GridCoverage2D.this.gridGeometry.axisDimensionY) {
                return GridCoverage2D.this.getRenderedImage();
            }
            return super.createDefaultRendering();
        }
    }
}

