/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.quantity.time;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import java.util.function.BinaryOperator;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Time;
import tech.units.indriya.AbstractQuantity;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.function.Calculus;
import tech.units.indriya.internal.function.calc.Calculator;
import tech.units.indriya.quantity.Quantities;
import tech.units.indriya.quantity.time.TimeQuantities;
import tech.units.indriya.unit.Units;

public final class TemporalQuantity
extends AbstractQuantity<Time> {
    private static final long serialVersionUID = -707159906206272775L;
    private final Object $lock1 = new Object[0];
    private final TemporalUnit timeUnit;
    private final Number value;
    private transient TemporalAmount amount;

    TemporalQuantity(Number value, TemporalUnit timeUnit) {
        super(TemporalQuantity.toUnit(timeUnit));
        this.timeUnit = timeUnit;
        this.value = value;
    }

    public static TemporalQuantity of(Number number, TemporalUnit timeUnit) {
        return new TemporalQuantity(Objects.requireNonNull(number), Objects.requireNonNull(timeUnit));
    }

    public static TemporalQuantity of(Quantity<Time> quantity) {
        Quantity seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return new TemporalQuantity(seconds.getValue(), ChronoUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TemporalAmount getTemporalAmount() {
        Object object = this.$lock1;
        synchronized (object) {
            if (this.amount == null) {
                long longValue = this.value.longValue();
                Number error = Calculator.of(this.value).subtract(longValue).abs().peek();
                if (Calculus.currentNumberSystem().compare(error, 1) > 0) {
                    String msg = String.format("cannot round number %s to long", "" + this.value);
                    throw new ArithmeticException(msg);
                }
                this.amount = Duration.of(longValue, this.timeUnit);
            }
        }
        return this.amount;
    }

    public TemporalUnit getTemporalUnit() {
        return this.timeUnit;
    }

    @Override
    public Number getValue() {
        return this.value;
    }

    public Unit<Time> toUnit() {
        return TemporalQuantity.toUnit(this.timeUnit);
    }

    public Quantity<Time> toQuantity() {
        return Quantities.getQuantity(this.value, this.toUnit());
    }

    public TemporalQuantity to(TemporalUnit aTimeUnit) {
        Quantity time = this.toQuantity().to(TemporalQuantity.toUnit(aTimeUnit));
        return new TemporalQuantity(time.getValue().longValue(), aTimeUnit);
    }

    private static Unit<Time> toUnit(TemporalUnit timeUnit) {
        if (timeUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)timeUnit;
            switch (chronoUnit) {
                case MICROS: {
                    return TimeQuantities.MICROSECOND;
                }
                case MILLIS: {
                    return TimeQuantities.MILLISECOND;
                }
                case NANOS: {
                    return TimeQuantities.NANOSECOND;
                }
                case SECONDS: {
                    return Units.SECOND;
                }
                case MINUTES: {
                    return Units.MINUTE;
                }
                case HOURS: {
                    return Units.HOUR;
                }
                case DAYS: {
                    return Units.DAY;
                }
            }
            throw new IllegalArgumentException("TemporalQuantity only supports DAYS, HOURS, MICROS, MILLIS, MINUTES, NANOS, SECONDS ");
        }
        throw new IllegalArgumentException("TemporalQuantity only supports temporal units of type ChronoUnit");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timeUnit, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (TemporalQuantity.class.isInstance(obj)) {
            TemporalQuantity other = (TemporalQuantity)TemporalQuantity.class.cast(obj);
            return Objects.equals(this.timeUnit, other.timeUnit) && Objects.equals(this.value, other.value);
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && Calculus.currentNumberSystem().compare(this.value, that.getValue()) == 0;
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "Temporal unit:" + this.timeUnit + " value: " + this.value;
    }

    @Override
    public ComparableQuantity<Time> add(Quantity<Time> that) {
        UnitConverter thisToThat = this.getUnit().getConverterTo(that.getUnit());
        boolean thatUnitIsSmaller = Calculus.currentNumberSystem().compare(thisToThat.convert(1.0), 1.0) > 0;
        Unit preferedUnit = thatUnitIsSmaller ? that.getUnit() : this.getUnit();
        Number thisValueInPreferedUnit = TemporalQuantity.convertedQuantityValue(this, preferedUnit);
        Number thatValueInPreferedUnit = TemporalQuantity.convertedQuantityValue(that, preferedUnit);
        Number resultValueInPreferedUnit = Calculator.of(thisValueInPreferedUnit).add(thatValueInPreferedUnit).peek();
        return Quantities.getQuantity(resultValueInPreferedUnit, preferedUnit);
    }

    @Override
    public ComparableQuantity<Time> subtract(Quantity<Time> that) {
        return this.add(that.negate());
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, (a, b) -> Calculator.of(a).divide((Number)b).peek(), Unit::divide);
    }

    @Override
    public ComparableQuantity<Time> divide(Number that) {
        return this.applyMultiplicativeNumberOperation(that, (a, b) -> Calculator.of(a).divide((Number)b).peek());
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> that) {
        return this.applyMultiplicativeQuantityOperation(that, (a, b) -> Calculator.of(a).multiply((Number)b).peek(), Unit::multiply);
    }

    @Override
    public ComparableQuantity<Time> multiply(Number that) {
        return this.applyMultiplicativeNumberOperation(that, (a, b) -> Calculator.of(a).multiply((Number)b).peek());
    }

    @Override
    public ComparableQuantity<Frequency> inverse() {
        return Quantities.getQuantity(Calculator.of(this.value).reciprocal().peek(), TemporalQuantity.toUnit(this.timeUnit).inverse()).asType(Frequency.class);
    }

    public Quantity<Time> negate() {
        return TemporalQuantity.of(Calculator.of(this.value).negate().peek(), this.getTemporalUnit());
    }

    private static <R extends Quantity<R>> Number quantityValue(Quantity<R> that) {
        return TemporalQuantity.convertedQuantityValue(that, that.getUnit());
    }

    private static <R extends Quantity<R>> Number convertedQuantityValue(Quantity<R> that, Unit<R> unit) {
        return that.getUnit().getConverterTo(unit).convert(that.getValue());
    }

    private ComparableQuantity<?> applyMultiplicativeQuantityOperation(Quantity<?> that, BinaryOperator<Number> valueOperator, BinaryOperator<Unit<?>> unitOperator) {
        Number thisValue = TemporalQuantity.quantityValue(this);
        Number thatValue = TemporalQuantity.quantityValue(that);
        Number result = (Number)valueOperator.apply(thisValue, thatValue);
        Unit resultUnit = (Unit)unitOperator.apply(this.getUnit(), that.getUnit());
        return Quantities.getQuantity(result, resultUnit);
    }

    private ComparableQuantity<Time> applyMultiplicativeNumberOperation(Number that, BinaryOperator<Number> valueOperator) {
        Number thisValue = this.getValue();
        Number thatValue = that;
        Number result = (Number)valueOperator.apply(thisValue, thatValue);
        return Quantities.getQuantity(result, this.getUnit());
    }
}

