/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.server;

import com.google.common.base.Preconditions;
import java.util.Date;
import org.jclouds.date.DateService;
import org.jclouds.profitbricks.domain.AvailabilityZone;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.OsType;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.http.parser.BaseProfitBricksResponseHandler;
import org.jclouds.profitbricks.http.parser.nic.NicListResponseHandler;
import org.jclouds.profitbricks.http.parser.storage.StorageListResponseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class BaseServerResponseHandler<T>
extends BaseProfitBricksResponseHandler<T> {
    protected final StorageListResponseHandler storageListResponseHandler;
    protected final NicListResponseHandler nicListResponseHandler;
    protected DataCenter.Builder dataCenterBuilder;
    protected Server.Builder builder;
    protected final DateService dateService;
    protected boolean useStorageParser = false;
    protected boolean useNicParser = false;

    BaseServerResponseHandler(DateService dateService, StorageListResponseHandler storageListResponseHandler, NicListResponseHandler nicListResponseHandler) {
        Preconditions.checkNotNull((Object)dateService, (Object)"DateService cannot be null");
        Preconditions.checkNotNull((Object)((Object)storageListResponseHandler), (Object)"StorageListResponseHandler cannot be null");
        Preconditions.checkNotNull((Object)((Object)nicListResponseHandler), (Object)"NicListResponseHandler cannot be null");
        this.dateService = dateService;
        this.storageListResponseHandler = storageListResponseHandler;
        this.nicListResponseHandler = nicListResponseHandler;
        this.builder = Server.builder();
        this.dataCenterBuilder = DataCenter.builder();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("connectedStorages".equals(qName)) {
            this.useStorageParser = true;
        } else if ("nics".equals(qName)) {
            this.useNicParser = true;
        }
        if (this.useStorageParser) {
            this.storageListResponseHandler.startElement(uri, localName, qName, attributes);
        } else if (this.useNicParser) {
            this.nicListResponseHandler.startElement(uri, localName, qName, attributes);
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.useStorageParser) {
            this.storageListResponseHandler.characters(ch, start, length);
        } else if (this.useNicParser) {
            this.nicListResponseHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    protected final Date textToIso8601Date() {
        return this.dateService.iso8601DateOrSecondsDateParse(this.textToStringValue());
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        if ("dataCenterId".equals(qName)) {
            this.dataCenterBuilder.id(this.textToStringValue());
        } else if ("dataCenterVersion".equals(qName)) {
            this.dataCenterBuilder.version(this.textToIntValue());
        } else if ("serverId".equals(qName)) {
            this.builder.id(this.textToStringValue());
        } else if ("serverName".equals(qName)) {
            this.builder.name(this.textToStringValue());
        } else if ("cores".equals(qName)) {
            this.builder.cores(this.textToIntValue());
        } else if ("ram".equals(qName)) {
            this.builder.ram(this.textToIntValue());
        } else if ("provisioningState".equals(qName)) {
            this.builder.state(ProvisioningState.fromValue(this.textToStringValue()));
        } else if ("virtualMachineState".equals(qName)) {
            this.builder.status(Server.Status.fromValue(this.textToStringValue()));
        } else if ("osType".equals(qName)) {
            this.builder.osType(OsType.fromValue(this.textToStringValue()));
        } else if ("availabilityZone".equals(qName)) {
            this.builder.availabilityZone(AvailabilityZone.fromValue(this.textToStringValue()));
        } else if ("creationTime".equals(qName)) {
            this.builder.creationTime(this.textToIso8601Date());
        } else if ("lastModificationTime".equals(qName)) {
            this.builder.lastModificationTime(this.textToIso8601Date());
        } else if ("internetAccess".equals(qName)) {
            this.builder.hasInternetAccess(this.textToBooleanValue());
        } else if ("cpuHotPlug".equals(qName)) {
            this.builder.isCpuHotPlug(this.textToBooleanValue());
        } else if ("ramHotPlug".equals(qName)) {
            this.builder.isRamHotPlug(this.textToBooleanValue());
        } else if ("nicHotPlug".equals(qName)) {
            this.builder.isNicHotPlug(this.textToBooleanValue());
        } else if ("nicHotUnPlug".equals(qName)) {
            this.builder.isNicHotUnPlug(this.textToBooleanValue());
        } else if ("discVirtioHotPlug".equals(qName)) {
            this.builder.isDiscVirtioHotPlug(this.textToBooleanValue());
        } else if ("discVirtioHotUnPlug".equals(qName)) {
            this.builder.isDiscVirtioHotUnPlug(this.textToBooleanValue());
        } else if ("activate".equals(qName)) {
            this.builder.loadBalanced(this.textToBooleanValue());
        } else if ("balancedNicId".equals(qName)) {
            this.builder.balancedNicId(this.textToStringValue());
        }
    }
}

