/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.http.parser.datacenter;

import com.google.inject.Inject;
import java.util.List;
import org.jclouds.profitbricks.domain.DataCenter;
import org.jclouds.profitbricks.domain.Location;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.profitbricks.http.parser.datacenter.BaseDataCenterResponseHandler;
import org.jclouds.profitbricks.http.parser.server.ServerListResponseHandler;
import org.jclouds.profitbricks.http.parser.storage.StorageListResponseHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DataCenterInfoResponseHandler
extends BaseDataCenterResponseHandler<DataCenter> {
    private final ServerListResponseHandler serverListResponseHandler;
    private final StorageListResponseHandler storageListResponseHandler;
    private boolean done = false;
    private boolean useServerParser = false;
    private boolean useStorageParser = false;

    @Inject
    DataCenterInfoResponseHandler(ServerListResponseHandler serverListResponseHandler, StorageListResponseHandler storageListResponseHandler) {
        this.serverListResponseHandler = serverListResponseHandler;
        this.storageListResponseHandler = storageListResponseHandler;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("servers".equals(qName)) {
            this.useServerParser = true;
        } else if ("storages".equals(qName)) {
            this.useStorageParser = true;
        }
        if (this.useServerParser) {
            this.serverListResponseHandler.startElement(uri, localName, qName, attributes);
        } else if (this.useStorageParser) {
            this.storageListResponseHandler.startElement(uri, localName, qName, attributes);
        } else {
            super.startElement(uri, localName, qName, attributes);
        }
    }

    @Override
    protected void setPropertyOnEndTag(String qName) {
        super.setPropertyOnEndTag(qName);
        if ("dataCenterName".equals(qName)) {
            this.builder.name(this.textToStringValue());
        } else if ("location".equals(qName)) {
            this.builder.location(Location.fromId(this.textToStringValue()));
        } else if ("provisioningState".equals(qName)) {
            this.builder.state(ProvisioningState.fromValue(this.textToStringValue()));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.useServerParser) {
            this.serverListResponseHandler.characters(ch, start, length);
        } else if (this.useStorageParser) {
            this.storageListResponseHandler.characters(ch, start, length);
        } else {
            super.characters(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.done) {
            return;
        }
        if (this.useServerParser) {
            this.serverListResponseHandler.endElement(uri, localName, qName);
        } else if (this.useStorageParser) {
            this.storageListResponseHandler.endElement(uri, localName, qName);
        } else {
            this.setPropertyOnEndTag(qName);
            if ("return".equals(qName)) {
                this.done = true;
                this.builder.servers((List<Server>)this.serverListResponseHandler.getResult());
                this.builder.storages((List<Storage>)this.storageListResponseHandler.getResult());
            }
            this.clearTextBuffer();
        }
        if ("servers".equals(qName)) {
            this.useServerParser = false;
        } else if ("storages".equals(qName)) {
            this.useStorageParser = false;
        }
    }

    public DataCenter getResult() {
        return this.builder.build();
    }
}

