/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi.net.example;

import java.net.ServerSocket;
import org.globus.gsi.gssapi.net.example.Client;
import org.globus.gsi.gssapi.net.example.GetOpts;
import org.globus.net.ServerSocketFactory;

public class GssServer {
    private static final String helpMsg = "Where options are:\n -gss-mode mode\t\t\tmode is: 'ssl' or 'gsi' (default)\n -deleg-type type\t\ttype is: 'none', 'limited' (default), or 'full'\n -lifetime time\t\t\tLifetime of context. time is in seconds.\n -rejectLimitedProxy\t\tEnables checking for limited proxies. By default off\n -anonymous\t\t\tDo not require client authentication\n -enable-conf\t\t\tEnables confidentiality (do encryption) (enabled by default)\n -disable-conf\t\t\tDisables confidentiality (no encryption)\n -wrap-mode mode\t\tmode is: 'ssl' (default) or 'gsi'";

    public static void main(String[] args) {
        String usage = "Usage: java GssServer [options] [port]";
        GetOpts opts = new GetOpts(usage, helpMsg);
        int pos = opts.parse(args);
        int port = 0;
        if (pos < args.length) {
            port = Integer.parseInt(args[pos]);
        }
        ServerSocketFactory factory = ServerSocketFactory.getDefault();
        try {
            ServerSocket server = factory.createServerSocket(port);
            System.out.println("Server running at: " + server.getLocalPort());
            while (true) {
                Client c = new Client(server.accept(), opts);
                c.start();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }
}

