/*
 * Decompiled with CFR 0.152.
 */
package org.globus.common;

import java.io.PrintStream;
import java.io.PrintWriter;

public class ChainedException
extends Exception {
    private Throwable exception;

    public ChainedException() {
    }

    public ChainedException(String detail) {
        super(detail);
    }

    public ChainedException(String detail, Throwable ex) {
        super(detail);
        this.exception = ex;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        if (this.exception != null) {
            String superString = this.getLocalMessage();
            PrintStream printStream = ps;
            synchronized (printStream) {
                ps.print(superString);
                ps.print(superString.endsWith(".") ? " Caused by " : ". Caused by ");
                this.exception.printStackTrace(ps);
            }
        } else {
            super.printStackTrace(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        if (this.exception != null) {
            String superString = this.getLocalMessage();
            PrintWriter printWriter = pw;
            synchronized (printWriter) {
                pw.print(superString);
                pw.print(superString.endsWith(".") ? " Caused by " : ". Caused by ");
                this.exception.printStackTrace(pw);
            }
        } else {
            super.printStackTrace(pw);
        }
    }

    public String getMessage() {
        String answer = super.getMessage();
        if (this.exception != null && this.exception != this) {
            String msg = this.exception.getMessage();
            if (msg == null) {
                msg = this.exception.getClass().getName();
            }
            answer = answer + " [Caused by: " + msg + "]";
        }
        return answer;
    }

    private String getLocalMessage() {
        String message = super.getMessage();
        return message == null ? this.getClass().getName() : message;
    }
}

