/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.harvesting;

import com.google.common.collect.Lists;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.exceptions.ObjectNotFoundEx;
import org.fao.geonet.kernel.harvest.HarvestManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.jdom.Content;
import org.jdom.Element;

public class Get
implements Service {
    public void init(Path appPath, ServiceConfig params) throws Exception {
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        List idEls = params.getChildren("id");
        boolean onlyInfo = Util.getParam((Element)params, (String)"onlyInfo", (boolean)false);
        String sortField = Util.getParam((Element)params, (String)"sortField", (String)"site[1]/name[1]");
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        SettingManager settingManager = (SettingManager)gc.getApplicationContext().getBean(SettingManager.class);
        String[] disabledTypes = StringUtils.split((String)StringUtils.defaultIfBlank((String)settingManager.getValue("system/harvester/disabledHarvesterTypes"), (String)"").toLowerCase().replace(',', ' '), (String)" ");
        List<Object> ids = idEls.isEmpty() ? Collections.singletonList(null) : idEls.stream().map(Element::getTextTrim).collect(Collectors.toList());
        HarvestManager harvestManager = (HarvestManager)gc.getBean(HarvestManager.class);
        Element result = new Element("nodes");
        for (String string : ids) {
            Element node = harvestManager.get(string, context, sortField);
            if (node != null) {
                if (idEls.isEmpty() || string.equals("-1")) {
                    List childNodes = node.getChildren();
                    for (Element childNode : childNodes) {
                        String harvesterType = childNode.getAttributeValue("type");
                        if (!Arrays.stream(disabledTypes).noneMatch(disabledType -> disabledType.equalsIgnoreCase(harvesterType))) continue;
                        result.addContent((Content)childNode.clone());
                    }
                    continue;
                }
                String harvesterType = node.getAttributeValue("type");
                if (!Arrays.stream(disabledTypes).noneMatch(disabledType -> disabledType.equalsIgnoreCase(harvesterType))) continue;
                result.addContent(node.detach());
                continue;
            }
            throw new ObjectNotFoundEx("No Harvester found with id: " + string);
        }
        if (onlyInfo) {
            this.removeAllDataExceptInfo(result);
        }
        return result;
    }

    private void removeAllDataExceptInfo(Element node) {
        ArrayList toRemove = Lists.newArrayList();
        List children = node.getChildren();
        for (Element harvesters : children) {
            List harvesterInfo = harvesters.getChildren();
            for (Element element : harvesterInfo) {
                if (element.getName().equalsIgnoreCase("info") || element.getName().equalsIgnoreCase("error")) continue;
                toRemove.add(element);
            }
        }
        for (Element element : toRemove) {
            element.detach();
        }
    }
}

