/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.webdav;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.RemoteRetriever;
import org.fao.geonet.kernel.harvest.harvester.webdav.WAFRemoteFile;
import org.fao.geonet.kernel.harvest.harvester.webdav.WebDavParams;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

class WAFRetriever
implements RemoteRetriever {
    public static final String type_GetCapabilities = "GetCapabilities";
    public static final String type_xml = "xml";
    public static final String type_dir = "directory";
    private final List<RemoteFile> files = new ArrayList<RemoteFile>();
    private final GeonetHttpRequestFactory requestFactory;
    private final SettingManager settingManager;
    private AtomicBoolean cancelMonitor;
    private Logger log;
    private WebDavParams params;
    private CloseableHttpClient httpClient;

    public WAFRetriever(SettingManager settingManager, GeonetHttpRequestFactory requestFactory) {
        this.settingManager = settingManager;
        this.requestFactory = requestFactory;
    }

    public static String getFileType(String path) {
        if (path.toUpperCase().contains("REQUEST=GETCAPABILITIES")) {
            return type_GetCapabilities;
        }
        if (path.toUpperCase().endsWith(".XML")) {
            return type_xml;
        }
        if (path.toUpperCase().endsWith("/")) {
            return type_dir;
        }
        return null;
    }

    @Override
    public void init(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, WebDavParams params) {
        String host;
        this.cancelMonitor = cancelMonitor;
        this.log = log;
        this.params = params;
        try {
            URL url = new URL(StringUtils.trim((String)params.url));
            host = url.getHost();
        }
        catch (MalformedURLException e) {
            log.error("Cannot parse URL " + params.url);
            log.error((Throwable)e);
            throw new IllegalArgumentException("Cannot parse URL " + params.url, e);
        }
        HttpClientBuilder clientBuilder = this.requestFactory.getDefaultHttpClientBuilder().setUserAgent("GeoNetwork/" + this.settingManager.getValue("system/platform/version") + "-" + this.settingManager.getValue("system/platform/subVersion"));
        CredentialsProvider provider = Lib.net.setupProxy(this.settingManager, clientBuilder, host);
        if (params.isUseAccount() && StringUtils.isNotBlank((CharSequence)params.getUsername())) {
            String username = params.getUsername();
            String password = params.getPassword();
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Basic"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Digest"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Negotiate"), (Credentials)new UsernamePasswordCredentials(username, password));
            provider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Kerberos"), (Credentials)new UsernamePasswordCredentials(username, password));
        }
        clientBuilder.setDefaultCredentialsProvider(provider);
        this.httpClient = clientBuilder.build();
    }

    @Override
    public List<RemoteFile> retrieve() throws Exception {
        this.files.clear();
        String url = this.params.url;
        if (!StringUtils.contains((CharSequence)url, (CharSequence)"?") && !StringUtils.endsWith((CharSequence)url, (CharSequence)"/")) {
            url = url + "/";
        }
        this.retrieveFiles(url);
        return this.files;
    }

    @Override
    public void destroy() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                this.log.warning("Error closing WAF http client");
                this.log.error((Throwable)e);
            }
        }
    }

    private void retrieveFiles(String wafUrl) throws IOException {
        Document doc;
        block29: {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Scanning resource : " + wafUrl);
            }
            CloseableHttpResponse response = this.connect(wafUrl);
            Object object = null;
            try {
                if (response.getStatusLine().getStatusCode() / 100 == 2) {
                    try (InputStream responseStream = response.getEntity().getContent();){
                        doc = Jsoup.parse((InputStream)responseStream, null, (String)wafUrl);
                        break block29;
                    }
                }
                throw new HttpResponseException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
            }
            catch (Throwable responseStream) {
                object = responseStream;
                throw responseStream;
            }
            finally {
                if (response != null) {
                    if (object != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable responseStream) {
                            ((Throwable)object).addSuppressed(responseStream);
                        }
                    } else {
                        response.close();
                    }
                }
            }
        }
        Elements links = doc.select("a[href]");
        for (Element link : links) {
            if (this.cancelMonitor.get()) {
                this.files.clear();
                return;
            }
            String url = link.attr("abs:href");
            String fileType = WAFRetriever.getFileType(url);
            if (StringUtils.equals((CharSequence)fileType, (CharSequence)type_dir)) {
                if (!this.params.recurse || !url.contains(wafUrl) || url.equals(wafUrl)) continue;
                this.retrieveFiles(url);
                continue;
            }
            if (!StringUtils.equals((CharSequence)fileType, (CharSequence)type_xml)) continue;
            this.files.add(new WAFRemoteFile(url, this.httpClient));
        }
    }

    private CloseableHttpResponse connect(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        return response;
    }
}

