/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester.oaipmh;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.command.AbortExecutionException;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Logger;
import org.fao.geonet.Util;
import org.fao.geonet.domain.AbstractMetadata;
import org.fao.geonet.domain.ISODate;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.domain.MetadataType;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.UpdateDatestamp;
import org.fao.geonet.kernel.datamanager.IMetadataIndexer;
import org.fao.geonet.kernel.datamanager.IMetadataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.harvest.BaseAligner;
import org.fao.geonet.kernel.harvest.harvester.CategoryMapper;
import org.fao.geonet.kernel.harvest.harvester.GroupMapper;
import org.fao.geonet.kernel.harvest.harvester.HarvestError;
import org.fao.geonet.kernel.harvest.harvester.HarvestResult;
import org.fao.geonet.kernel.harvest.harvester.HarvesterUtil;
import org.fao.geonet.kernel.harvest.harvester.IHarvester;
import org.fao.geonet.kernel.harvest.harvester.UUIDMapper;
import org.fao.geonet.kernel.harvest.harvester.oaipmh.OaiPmhParams;
import org.fao.geonet.kernel.harvest.harvester.oaipmh.RecordInfo;
import org.fao.geonet.kernel.harvest.harvester.oaipmh.Search;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.repository.MetadataValidationRepository;
import org.fao.geonet.repository.OperationAllowedRepository;
import org.fao.geonet.repository.Updater;
import org.fao.geonet.repository.specification.MetadataValidationSpecs;
import org.fao.geonet.utils.GeonetHttpRequestFactory;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.XmlRequest;
import org.fao.oaipmh.OaiPmh;
import org.fao.oaipmh.exceptions.NoRecordsMatchException;
import org.fao.oaipmh.requests.GetRecordRequest;
import org.fao.oaipmh.requests.ListIdentifiersRequest;
import org.fao.oaipmh.responses.GetRecordResponse;
import org.fao.oaipmh.responses.Header;
import org.fao.oaipmh.responses.ListIdentifiersResponse;
import org.jdom.Element;
import org.jdom.JDOMException;

class Harvester
extends BaseAligner<OaiPmhParams>
implements IHarvester<HarvestResult> {
    private HarvestResult result;
    private Logger log;
    private ServiceContext context;
    private DataManager dataMan;
    private IMetadataManager metadataManager;
    private IMetadataIndexer metadataIndexer;
    private IMetadataUtils metadataUtils;
    private CategoryMapper localCateg;
    private GroupMapper localGroups;
    private UUIDMapper localUuids;
    private List<HarvestError> errors = new LinkedList<HarvestError>();

    public Harvester(AtomicBoolean cancelMonitor, Logger log, ServiceContext context, OaiPmhParams params) {
        super(cancelMonitor);
        this.log = log;
        this.context = context;
        this.params = params;
        this.result = new HarvestResult();
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        this.dataMan = (DataManager)gc.getBean(DataManager.class);
        this.metadataManager = (IMetadataManager)gc.getBean(IMetadataManager.class);
        this.metadataIndexer = (IMetadataIndexer)gc.getBean(IMetadataIndexer.class);
        this.metadataUtils = (IMetadataUtils)gc.getBean(IMetadataUtils.class);
    }

    @Override
    public HarvestResult harvest(Logger log) throws Exception {
        this.log = log;
        ListIdentifiersRequest req = new ListIdentifiersRequest((GeonetHttpRequestFactory)this.context.getBean(GeonetHttpRequestFactory.class));
        req.setSchemaPath(this.context.getAppPath().resolve("xml/validation/oai/OAI-PMH.xsd"));
        XmlRequest t = req.getTransport();
        try {
            t.setUrl(new URL(((OaiPmhParams)this.params).url));
        }
        catch (MalformedURLException e1) {
            HarvestError harvestError = new HarvestError(this.context, e1);
            harvestError.setDescription(harvestError.getDescription() + " " + ((OaiPmhParams)this.params).url);
            this.errors.add(harvestError);
            throw new AbortExecutionException((Throwable)e1);
        }
        if (((OaiPmhParams)this.params).isUseAccount()) {
            t.setCredentials(((OaiPmhParams)this.params).getUsername(), ((OaiPmhParams)this.params).getPassword());
        }
        Lib.net.setupProxy(this.context, t);
        HashSet<RecordInfo> records = new HashSet<RecordInfo>();
        boolean error = false;
        for (Search s : ((OaiPmhParams)this.params).getSearches()) {
            if (this.cancelMonitor.get()) {
                return this.result;
            }
            try {
                records.addAll(this.search(req, s));
            }
            catch (Exception e) {
                error = true;
                log.error("Unknown error trying to harvest");
                log.error(e.getMessage());
                log.error((Throwable)e);
                this.errors.add(new HarvestError(this.context, e));
            }
            catch (Throwable e) {
                error = true;
                log.fatal("Something unknown and terrible happened while harvesting");
                log.fatal(e.getMessage());
                log.error(e);
                this.errors.add(new HarvestError(this.context, e));
            }
        }
        if (((OaiPmhParams)this.params).isSearchEmpty()) {
            try {
                log.debug("Doing an empty search");
                records.addAll(this.search(req, Search.createEmptySearch()));
            }
            catch (Exception e) {
                error = true;
                log.error("Unknown error trying to harvest");
                log.error(e.getMessage());
                log.error((Throwable)e);
                this.errors.add(new HarvestError(this.context, e));
            }
            catch (Throwable e) {
                error = true;
                log.fatal("Something unknown and terrible happened while harvesting");
                log.fatal(e.getMessage());
                log.error(e);
                this.errors.add(new HarvestError(this.context, e));
            }
        }
        log.info("Total records processed in all searches :" + records.size());
        if (!error) {
            this.align(t, records);
        } else {
            log.warning("Due to previous errors the align process has not been called");
        }
        return this.result;
    }

    private Set<RecordInfo> search(ListIdentifiersRequest req, Search s) throws OperationAbortedEx {
        if (s.from.length() != 0) {
            req.setFrom(new ISODate(s.from));
        } else {
            req.setFrom(null);
        }
        if (s.until.length() != 0) {
            req.setUntil(new ISODate(s.until));
        } else {
            req.setUntil(null);
        }
        if (s.set.length() != 0) {
            req.setSet(s.set);
        } else {
            req.setSet(null);
        }
        req.setMetadataPrefix(s.prefix);
        HashSet<RecordInfo> records = new HashSet<RecordInfo>();
        this.log.info("Searching on : " + ((OaiPmhParams)this.params).getName());
        try {
            ListIdentifiersResponse response = req.execute();
            while (response.hasNext()) {
                if (this.cancelMonitor.get()) {
                    return Collections.emptySet();
                }
                Header h = response.next();
                if (h.isDeleted()) continue;
                records.add(new RecordInfo(h, s.prefix));
            }
            this.log.info("Records added to result list : " + records.size());
            return records;
        }
        catch (NoRecordsMatchException e) {
            this.log.warning("No records were matched: " + e.getMessage());
            this.errors.add(new HarvestError(this.context, e));
            return records;
        }
        catch (Exception e) {
            this.log.warning("Raised exception when searching : " + e);
            this.log.warning(Util.getStackTrace((Throwable)e));
            this.errors.add(new HarvestError(this.context, e));
            throw new OperationAbortedEx("Raised exception when searching", (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void align(XmlRequest t, Set<RecordInfo> records) throws Exception {
        this.log.info("Start of alignment for : " + ((OaiPmhParams)this.params).getName());
        this.localCateg = new CategoryMapper(this.context);
        this.localGroups = new GroupMapper(this.context);
        this.localUuids = new UUIDMapper((IMetadataUtils)this.context.getBean(IMetadataUtils.class), ((OaiPmhParams)this.params).getUuid());
        Pair<String, Map<String, Object>> filter = HarvesterUtil.parseXSLFilter(((OaiPmhParams)this.params).xslfilter);
        String processName = (String)filter.one();
        Map processParams = (Map)filter.two();
        this.dataMan.flush();
        for (String uuid : this.localUuids.getUUIDs()) {
            if (this.cancelMonitor.get()) {
                return;
            }
            if (this.exists(records, uuid)) continue;
            String id = this.localUuids.getID(uuid);
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Removing old metadata with local id:" + id);
            }
            this.metadataManager.deleteMetadataGroup(this.context, id);
            this.metadataManager.flush();
            ++this.result.locallyRemoved;
        }
        for (RecordInfo ri : records) {
            if (this.cancelMonitor.get()) {
                return;
            }
            try {
                String databaseId = this.metadataUtils.getMetadataId(ri.id);
                if (databaseId == null) {
                    this.log.debug(String.format("Adding record with id %s", ri.id));
                    processParams.put("mdChangeDate", ri.changeDate);
                    this.addMetadata(t, ri, processName, processParams);
                } else if (this.localUuids.getID(ri.id) == null) {
                    ++this.result.datasetUuidExist;
                    switch (((OaiPmhParams)this.params).getOverrideUuid()) {
                        case OVERRIDE: {
                            processParams.put("mdChangeDate", ri.changeDate);
                            this.updateMetadata(t, ri, Integer.toString(this.metadataUtils.findOneByUuid(ri.id).getId()), processName, processParams, true);
                            ++this.result.updatedMetadata;
                            break;
                        }
                        case RANDOM: {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug(String.format("Generating random uuid for remote record with uuid %s", ri.id));
                            }
                            String newRandomUuid = UUID.randomUUID().toString();
                            processParams.put("mdChangeDate", ri.changeDate);
                            this.addMetadata(t, ri, processName, processParams, newRandomUuid);
                            break;
                        }
                        case SKIP: {
                            this.log.debug("Skipping record with uuid " + ri.id);
                            ++this.result.uuidSkipped;
                            break;
                        }
                    }
                } else {
                    String id = this.localUuids.getID(ri.id);
                    processParams.put("mdChangeDate", ri.changeDate);
                    this.updateMetadata(t, ri, id, processName, processParams, false);
                }
                ++this.result.totalMetadata;
            }
            catch (Throwable tr) {
                this.errors.add(new HarvestError(this.context, tr));
                this.log.error("Unable to process record from OAI (" + ((OaiPmhParams)this.params).getName() + ")");
                this.log.error("   Record failed: " + ri.id + ". Error is: " + tr.getMessage());
                this.log.error(tr);
            }
            finally {
                ++this.result.originalMetadata;
            }
        }
        this.dataMan.forceIndexChanges();
        this.log.info("End of alignment for : " + ((OaiPmhParams)this.params).getName());
    }

    private boolean exists(Set<RecordInfo> records, String uuid) {
        for (RecordInfo ri : records) {
            if (!uuid.equals(ri.id)) continue;
            return true;
        }
        return false;
    }

    private void addMetadata(XmlRequest t, RecordInfo ri, String processName, Map<String, Object> processParams) throws Exception {
        this.addMetadata(t, ri, processName, processParams, null);
    }

    private void addMetadata(XmlRequest t, RecordInfo ri, String processName, Map<String, Object> processParams, String newUuid) throws Exception {
        Element md = this.retrieveMetadata(t, ri);
        if (md == null) {
            return;
        }
        String schema = this.dataMan.autodetectSchema(md);
        if (this.log.isDebugEnabled()) {
            this.log.debug("  - Adding metadata with remote id : " + ri.id);
        }
        if (StringUtils.isNotEmpty((String)((OaiPmhParams)this.params).xslfilter)) {
            md = HarvesterUtil.processMetadata(this.dataMan.getSchema(schema), md, processName, processParams);
            schema = this.dataMan.autodetectSchema(md);
        }
        Metadata metadata = new Metadata();
        if (newUuid != null) {
            metadata.setUuid(newUuid);
            md = this.metadataUtils.setUUID(schema, newUuid, md);
        } else {
            metadata.setUuid(ri.id);
        }
        metadata.getDataInfo().setSchemaId(schema).setRoot(md.getQualifiedName()).setType(MetadataType.METADATA).setChangeDate(ri.changeDate).setCreateDate(ri.changeDate);
        metadata.getSourceInfo().setSourceId(((OaiPmhParams)this.params).getUuid()).setOwner(Integer.valueOf(this.getOwner()));
        metadata.getHarvestInfo().setHarvested(true).setUuid(((OaiPmhParams)this.params).getUuid());
        try {
            metadata.getSourceInfo().setGroupOwner(Integer.valueOf(((OaiPmhParams)this.params).getOwnerIdGroup()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.addCategories((AbstractMetadata)metadata, ((OaiPmhParams)this.params).getCategories(), this.localCateg, this.context, null, false);
        metadata = this.metadataManager.insertMetadata(this.context, (AbstractMetadata)metadata, md, true, false, false, UpdateDatestamp.NO, false, false);
        String id = String.valueOf(metadata.getId());
        this.addPrivileges(id, ((OaiPmhParams)this.params).getPrivileges(), this.localGroups, this.context);
        this.metadataManager.flush();
        this.dataMan.indexMetadata(id, Math.random() < 0.01, null);
        ++this.result.addedMetadata;
    }

    private Element retrieveMetadata(XmlRequest transport, RecordInfo ri) {
        block12: {
            try {
                String schema;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  - Getting remote metadata with id : " + ri.id);
                }
                GetRecordRequest req = new GetRecordRequest(transport);
                req.setSchemaPath(this.context.getAppPath().resolve("xml/validation/oai/OAI-PMH.xsd"));
                req.setIdentifier(ri.id);
                req.setMetadataPrefix(ri.prefix);
                GetRecordResponse res = req.execute();
                Element md = res.getRecord().getMetadata();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("    - Record got:\n" + Xml.getString((Element)md));
                }
                if (this.isOaiDc(md)) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("    - Converting oai_dc to dublin core");
                    }
                    if ((md = this.toDublinCore(md)) == null) {
                        return null;
                    }
                }
                if ((schema = this.dataMan.autodetectSchema(md, null)) == null) {
                    this.log.warning("Skipping metadata with unknown schema. Remote id : " + ri.id);
                    ++this.result.unknownSchema;
                    break block12;
                }
                try {
                    Integer groupIdVal = null;
                    if (StringUtils.isNotEmpty((String)((OaiPmhParams)this.params).getOwnerIdGroup())) {
                        groupIdVal = Integer.parseInt(((OaiPmhParams)this.params).getOwnerIdGroup());
                    }
                    ((OaiPmhParams)this.params).getValidate().validate(this.dataMan, this.context, md, groupIdVal);
                    return (Element)md.detach();
                }
                catch (Exception e) {
                    this.log.info("Skipping metadata that does not validate. Remote id : " + ri.id);
                    ++this.result.doesNotValidate;
                }
            }
            catch (JDOMException e) {
                HarvestError harvestError = new HarvestError(this.context, e);
                harvestError.setDescription("Skipping metadata with bad XML format. Remote id : " + ri.id);
                harvestError.printLog();
                this.errors.add(harvestError);
                ++this.result.badFormat;
            }
            catch (Exception e) {
                HarvestError harvestError = new HarvestError(this.context, e);
                harvestError.setDescription("Raised exception while getting metadata file : " + e);
                this.errors.add(harvestError);
                harvestError.printLog();
                ++this.result.unretrievable;
            }
        }
        return null;
    }

    private boolean isOaiDc(Element md) {
        return md.getName().equals("dc") && md.getNamespace().equals((Object)OaiPmh.Namespaces.OAI_DC);
    }

    private Element toDublinCore(Element md) {
        Path styleSheet = this.context.getAppPath().resolve("conversion/oai_dc-to-dublin-core/main.xsl");
        try {
            return Xml.transform((Element)md, (Path)styleSheet);
        }
        catch (Exception e) {
            HarvestError harvestError = new HarvestError(this.context, e);
            harvestError.setDescription("Cannot convert oai_dc to dublin core : " + e);
            this.errors.add(harvestError);
            harvestError.printLog();
            return null;
        }
    }

    private void updateMetadata(XmlRequest t, RecordInfo ri, String id, String processName, Map<String, Object> processParams, boolean force) throws Exception {
        String date = this.localUuids.getChangeDate(ri.id);
        if (!force && !ri.isMoreRecentThan(date)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Metadata XML not changed for remote id : " + ri.id);
            }
            ++this.result.unchangedMetadata;
        } else {
            Element md;
            if (this.log.isDebugEnabled()) {
                this.log.debug("  - Updating local metadata for remote id : " + ri.id);
            }
            if ((md = this.retrieveMetadata(t, ri)) == null) {
                ++this.result.unchangedMetadata;
                return;
            }
            String schema = this.dataMan.autodetectSchema(md, null);
            boolean updateSchema = false;
            if (StringUtils.isNotEmpty((String)((OaiPmhParams)this.params).xslfilter)) {
                md = HarvesterUtil.processMetadata(this.dataMan.getSchema(schema), md, processName, processParams);
                schema = this.dataMan.autodetectSchema(md);
                updateSchema = true;
            }
            boolean validate = false;
            boolean ufo = false;
            boolean index = false;
            String language = this.context.getLanguage();
            if (updateSchema) {
                MetadataValidationRepository metadataValidationRepository = (MetadataValidationRepository)this.context.getBean(MetadataValidationRepository.class);
                final String newSchema = schema;
                this.metadataManager.update(Integer.parseInt(id), (Updater)new Updater<AbstractMetadata>(){

                    public void apply(@Nonnull AbstractMetadata entity) {
                        entity.getDataInfo().setSchemaId(newSchema);
                    }
                });
                metadataValidationRepository.deleteAll(MetadataValidationSpecs.hasMetadataId((int)Integer.parseInt(id)));
            }
            AbstractMetadata metadata = this.metadataManager.updateMetadata(this.context, id, md, validate, ufo, index, language, ri.changeDate.toString(), true);
            if (force) {
                metadata.getHarvestInfo().setUuid(((OaiPmhParams)this.params).getUuid());
                metadata.getSourceInfo().setSourceId(((OaiPmhParams)this.params).getUuid());
                this.metadataManager.save(metadata);
            }
            OperationAllowedRepository repository = (OperationAllowedRepository)this.context.getBean(OperationAllowedRepository.class);
            repository.deleteAllByMetadataId(Integer.parseInt(id));
            this.addPrivileges(id, ((OaiPmhParams)this.params).getPrivileges(), this.localGroups, this.context);
            metadata.getCategories().clear();
            this.addCategories(metadata, ((OaiPmhParams)this.params).getCategories(), this.localCateg, this.context, null, true);
            this.metadataManager.flush();
            this.dataMan.indexMetadata(id, Math.random() < 0.01, null);
            ++this.result.updatedMetadata;
            this.metadataIndexer.indexMetadata(id, true, null);
            ++this.result.updatedMetadata;
        }
    }

    @Override
    public List<HarvestError> getErrors() {
        return this.errors;
    }
}

