/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.springsecurity.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.adapters.springsecurity.facade.SimpleHttpFacade;
import org.keycloak.adapters.springsecurity.token.AdapterTokenStoreFactory;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.keycloak.adapters.springsecurity.token.SpringSecurityAdapterTokenStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.util.Assert;

public class KeycloakLogoutHandler
implements LogoutHandler {
    private static final Logger log = LoggerFactory.getLogger(KeycloakLogoutHandler.class);
    private AdapterDeploymentContext adapterDeploymentContext;
    private AdapterTokenStoreFactory adapterTokenStoreFactory = new SpringSecurityAdapterTokenStoreFactory();

    public KeycloakLogoutHandler(AdapterDeploymentContext adapterDeploymentContext) {
        Assert.notNull((Object)adapterDeploymentContext);
        this.adapterDeploymentContext = adapterDeploymentContext;
    }

    public void setAdapterTokenStoreFactory(AdapterTokenStoreFactory adapterTokenStoreFactory) {
        this.adapterTokenStoreFactory = adapterTokenStoreFactory;
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        if (authentication == null) {
            log.warn("Cannot log out without authentication");
            return;
        }
        if (!KeycloakAuthenticationToken.class.isAssignableFrom(authentication.getClass())) {
            log.warn("Cannot log out a non-Keycloak authentication: {}", (Object)authentication);
            return;
        }
        this.handleSingleSignOut(request, response, (KeycloakAuthenticationToken)authentication);
    }

    protected void handleSingleSignOut(HttpServletRequest request, HttpServletResponse response, KeycloakAuthenticationToken authenticationToken) {
        SimpleHttpFacade facade = new SimpleHttpFacade(request, response);
        KeycloakDeployment deployment = this.adapterDeploymentContext.resolveDeployment((HttpFacade)facade);
        this.adapterTokenStoreFactory.createAdapterTokenStore(deployment, request, response).logout();
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)authenticationToken.getAccount().getKeycloakSecurityContext();
        session.logout(deployment);
    }
}

