/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.suppliers.all;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.Iso3166;
import org.jclouds.location.Provider;

@Singleton
public class JustProvider
implements Supplier<Set<? extends Location>> {
    private final String providerName;
    private final Supplier<URI> endpointSupplier;
    private final Set<String> isoCodesSupplier;

    @Inject
    public JustProvider(@Provider String providerName, @Provider Supplier<URI> endpointSupplier, @Iso3166 Set<String> isoCodesSupplier) {
        this.providerName = (String)Preconditions.checkNotNull((Object)providerName, (Object)"providerName");
        this.endpointSupplier = (Supplier)Preconditions.checkNotNull(endpointSupplier, (Object)"endpoint");
        this.isoCodesSupplier = (Set)Preconditions.checkNotNull(isoCodesSupplier, (Object)"isoCodes");
    }

    public Set<? extends Location> get() {
        return ImmutableSet.of((Object)new LocationBuilder().scope(LocationScope.PROVIDER).id(this.providerName).description(((URI)this.endpointSupplier.get()).toASCIIString()).iso3166Codes(this.isoCodesSupplier).build());
    }
}

