/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.ui.SailTableModel;
import org.openrdf.sesame.config.ui.XCellEditor;
import org.openrdf.sesame.config.ui.XTable;
import org.openrdf.sesame.config.ui.util.Util;

public class SailTable
extends XTable {
    protected String _id;

    public SailTable(String id, SystemConfig config) {
        super(config);
        this._id = id;
        this.setXTableModel(new SailTableModel(id, config));
    }

    protected TableCellRenderer _createCellRenderer(int columnNo) {
        if (columnNo == 0) {
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(this._model.getColumnAlignment(columnNo));
            return renderer;
        }
        return null;
    }

    protected TableCellEditor _createCellEditor(int columnNo) {
        ClassCellEditor editor = null;
        if (columnNo == 0) {
            editor = new ClassCellEditor(this);
        }
        return editor;
    }

    public void removeRow() {
        String sailClass = this.getIdentifierForSelectedRow();
        if (sailClass == null) {
            this._showWarningDialog("No sail selected.", "Remove Sail");
            return;
        }
        if (Util.showYesNoDialog(this._getOwner(), "Are you sure you want to remove Sail\n" + sailClass + "\nfrom the sail stack?", "Remove Sail") == 0) {
            int row = this.getSelectedRow();
            this._config.removeSail(this._id, sailClass);
            this.selectPreviousRowTo(row);
        }
    }

    public void sailUp() {
        String sailClass = this.getIdentifierForSelectedRow();
        if (sailClass == null) {
            this._showWarningDialog("No sail selected.", "Sail Up");
            return;
        }
        this._value = sailClass;
        this._config.sailUp(this._id, sailClass);
    }

    public void sailDown() {
        String sailClass = this.getIdentifierForSelectedRow();
        if (sailClass == null) {
            this._showWarningDialog("No sail selected.", "Sail Down");
            return;
        }
        this._value = sailClass;
        this._config.sailDown(this._id, sailClass);
    }

    class ClassCellEditor
    extends XCellEditor {
        public ClassCellEditor(SailTable sailTable) {
            super(new JTextField(), (XTable)sailTable);
        }

        public boolean isValid() {
            String newClass = this.getCellEditorValue().toString();
            if (newClass.length() == 0) {
                SailTable.this._showWarningDialog("Class required.", "Edit Sail");
                return false;
            }
            String oldClass = (String)this._value;
            if (!newClass.equals(oldClass) && SailTable.this._config.hasSail(SailTable.this._id, newClass)) {
                SailTable.this._showWarningDialog(newClass + " already exists.", "Edit Sail");
                return false;
            }
            return true;
        }
    }
}

