/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.util.NoSuchElementException;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureIterator;
import org.opengis.feature.Feature;

public class PushBackFeatureIterator
extends DecoratingFeatureIterator<Feature> {
    Feature last;
    Feature current;

    public PushBackFeatureIterator(FeatureIterator<Feature> iterator) {
        super(iterator);
    }

    @Override
    public boolean hasNext() {
        return this.current != null || this.delegate.hasNext();
    }

    @Override
    public Feature next() throws NoSuchElementException {
        if (this.current != null) {
            this.last = this.current;
            this.current = null;
        } else {
            this.last = this.delegate.next();
        }
        return this.last;
    }

    public void pushBack() {
        if (this.last == null) {
            throw new IllegalStateException("There is no feature to push back");
        }
        this.current = this.last;
        this.last = null;
    }

    @Override
    public void close() {
        this.delegate.close();
    }
}

