/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.collection;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.GeometryDimensionCollector;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.algorithm.RobustLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.locationtech.jts.geom.util.GeometryEditor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;

public class ClippedFeatureIterator
implements SimpleFeatureIterator {
    static final Logger LOGGER = Logging.getLogger(ClippedFeatureIterator.class);
    protected SimpleFeatureIterator delegate;
    GeometryClipper clipper;
    boolean preserveTopology;
    protected SimpleFeatureBuilder fb;
    protected SimpleFeature next;
    protected Geometry clip;
    boolean preserveZ;

    public ClippedFeatureIterator(SimpleFeatureIterator delegate, Geometry clip, SimpleFeatureType schema, boolean preserveZ) {
        this.delegate = delegate;
        if (clip.getEnvelope().equals(clip)) {
            this.clipper = new GeometryClipper(clip.getEnvelopeInternal());
        } else {
            this.clip = clip;
        }
        this.fb = new SimpleFeatureBuilder(schema);
        this.preserveZ = preserveZ;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean hasNext() {
        while (this.next == null && this.delegate.hasNext()) {
            SimpleFeature f = (SimpleFeature)this.delegate.next();
            boolean clippedOut = this.prepareBuilderForNextFeature(f);
            if (!clippedOut) {
                this.next = this.fb.buildFeature(f.getID());
            }
            this.fb.reset();
        }
        return this.next != null;
    }

    protected boolean prepareBuilderForNextFeature(SimpleFeature f) {
        boolean clippedOut = false;
        for (AttributeDescriptor ad : f.getFeatureType().getAttributeDescriptors()) {
            Class target;
            Object attribute = f.getAttribute(ad.getName());
            if (ad instanceof GeometryDescriptor && (attribute = this.clipGeometry((Geometry)attribute, target = ad.getType().getBinding(), ((GeometryDescriptor)ad).getCoordinateReferenceSystem())) == null && f.getFeatureType().getGeometryDescriptor() == ad) {
                this.fb.reset();
                clippedOut = true;
                break;
            }
            this.fb.add(attribute);
        }
        return clippedOut;
    }

    @Override
    public SimpleFeature next() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("hasNext() returned false!");
        }
        SimpleFeature result = this.next;
        this.next = null;
        return result;
    }

    private Object clipGeometry(Geometry geom, Class target, CoordinateReferenceSystem crs) {
        Geometry clipped = null;
        if (this.clipper != null) {
            clipped = this.clipper.clip(geom, true);
        } else if (geom.getEnvelopeInternal().intersects(this.clip.getEnvelopeInternal())) {
            clipped = this.clip.intersection(geom);
        }
        if (clipped == null) {
            return null;
        }
        GeometryDimensionCollector collector = new GeometryDimensionCollector(geom.getDimension());
        clipped.apply((GeometryComponentFilter)collector);
        Geometry result = collector.collect();
        if (result == null) {
            return null;
        }
        if (this.preserveZ && !geom.equalsExact(clipped)) {
            GeometryEditor editor = new GeometryEditor();
            if ((result = editor.edit(result, (GeometryEditor.GeometryEditorOperation)new GeometryEditor.CoordinateOperation(){

                public Coordinate[] edit(Coordinate[] coordinates, Geometry geometry) {
                    return CoordinateArrays.enforceConsistency((Coordinate[])coordinates, (int)3, (int)0);
                }
            })).getDimension() == 2 || result.getDimension() == 0) {
                result.apply((CoordinateSequenceFilter)new IDWElevationInterpolator(geom, crs));
            } else if (result.getDimension() == 1) {
                result.apply((GeometryComponentFilter)new LinearElevationInterpolator(geom, crs));
            }
        }
        return result;
    }

    protected boolean hasElevations(CoordinateSequence seq) {
        return seq instanceof CoordinateArraySequence && !Double.isNaN(seq.getCoordinate(0).getZ()) || !(seq instanceof CoordinateArraySequence) && seq.getDimension() > 2;
    }

    static class ClippingException
    extends RuntimeException {
        private static final long serialVersionUID = -1373822214375482149L;

        public ClippingException() {
        }

        public ClippingException(String message, Throwable cause) {
            super(message, cause);
        }

        public ClippingException(String message) {
            super(message);
        }

        public ClippingException(Throwable cause) {
            super(cause);
        }
    }

    private class LinearElevationInterpolator
    implements GeometryComponentFilter {
        private final ArrayList<LineString> originalLines = new ArrayList();

        public LinearElevationInterpolator(Geometry original, CoordinateReferenceSystem crs) {
            original.apply(new GeometryComponentFilter(){

                public void filter(Geometry geom) {
                    if (geom instanceof LineString) {
                        LinearElevationInterpolator.this.originalLines.add((LineString)geom);
                    }
                }
            });
        }

        public void filter(Geometry geom) {
            if (geom instanceof LineString) {
                LineString ls = (LineString)geom;
                LineString original = this.getOriginator(ls);
                if (original == null) {
                    LOGGER.log(Level.WARNING, "Could not find the original line from which the output line " + geom + " originated");
                    return;
                }
                try {
                    this.applyElevations(ls, original, false);
                }
                catch (ClippingException e) {
                    this.applyElevations(ls, original, true);
                }
            }
        }

        private void applyElevations(LineString ls, LineString original, boolean tolerant) {
            if (!ClippedFeatureIterator.this.hasElevations(original.getCoordinateSequence())) {
                return;
            }
            CoordinateSequence cs = ls.getCoordinateSequence();
            CoordinateSequence csOrig = original.getCoordinateSequence();
            Coordinate c1 = cs.getCoordinate(0);
            Coordinate c2 = cs.getCoordinate(1);
            int localIdx = 0;
            Coordinate o1 = csOrig.getCoordinate(0);
            Coordinate o2 = csOrig.getCoordinate(1);
            int origIdx = 0;
            RobustLineIntersector intersector = new RobustLineIntersector();
            int matched = 0;
            boolean flipped = false;
            while (true) {
                intersector.computeIntersection(c1, c2, o1, o2);
                int intersectionNum = intersector.getIntersectionNum();
                if (intersectionNum == 1 || tolerant && intersectionNum != 2) {
                    LineSegment segment = new LineSegment(o1, o2);
                    double d1 = segment.distance(c1);
                    double d2 = segment.distance(c2);
                    if (d1 <= 1.0E-6 && d2 <= 1.0E-6) {
                        intersectionNum = 2;
                    }
                }
                if (intersectionNum == 2) {
                    ++matched;
                    this.applyZValues(cs, localIdx, csOrig, origIdx);
                    if (++localIdx == cs.size() - 1) break;
                    c1 = c2;
                    c2 = cs.getCoordinate(localIdx + 1);
                    continue;
                }
                if (++origIdx >= csOrig.size() - 1) {
                    if (!flipped) {
                        ls = ls.reverse();
                        cs = ls.getCoordinateSequence();
                        flipped = true;
                        c1 = cs.getCoordinate(0);
                        c2 = cs.getCoordinate(1);
                        localIdx = 0;
                        o1 = csOrig.getCoordinate(0);
                        o2 = csOrig.getCoordinate(1);
                        origIdx = 0;
                        continue;
                    }
                    throw new ClippingException("Could not find collinear segments between " + ls.toText() + "\n and \n" + original.toText() + "\n after matching " + matched + " points");
                }
                o1 = o2;
                o2 = csOrig.getCoordinate(origIdx + 1);
            }
            this.applyZValues(cs, localIdx, csOrig, origIdx);
        }

        private void applyZValues(CoordinateSequence cs, int idx, CoordinateSequence csOrig, int origIdx) {
            double lz1;
            if (!cs.hasZ()) {
                return;
            }
            double lx1 = cs.getOrdinate(idx, 0);
            double ly1 = cs.getOrdinate(idx, 1);
            double ox1 = csOrig.getX(origIdx);
            double oy1 = csOrig.getY(origIdx);
            double oz1 = csOrig.getZ(origIdx);
            double ox2 = csOrig.getX(origIdx + 1);
            double oy2 = csOrig.getY(origIdx + 1);
            double oz2 = csOrig.getZ(origIdx + 1);
            if (lx1 == ox1 && ly1 == oy1) {
                lz1 = oz1;
            } else {
                double d1 = this.distance(ox1, oy1, lx1, ly1);
                double d = this.distance(ox1, oy1, ox2, oy2);
                lz1 = oz1 + (oz2 - oz1) * (d1 / d);
            }
            cs.setOrdinate(idx, 2, lz1);
        }

        private double distance(double x1, double y1, double x2, double y2) {
            double dx = x1 - x2;
            double dy = y1 - y2;
            return Math.sqrt(dx * dx + dy * dy);
        }

        private LineString getOriginator(LineString ls) {
            LineString original = null;
            for (LineString ol : this.originalLines) {
                if (!ls.equals((Geometry)ol) && !ls.overlaps((Geometry)ol) && !ol.contains((Geometry)ls)) continue;
                original = ol;
                break;
            }
            if (original == null) {
                for (LineString ol : this.originalLines) {
                    if (!ol.buffer(1.0E-6).contains((Geometry)ls)) continue;
                    original = ol;
                    break;
                }
            }
            return original;
        }
    }

    static final class PointDistance
    implements Comparable<PointDistance> {
        static final double EPS_METERS = 1.0E-6;
        static final double EPS_DEGREES = 1.0E-9;
        Coordinate c;
        double squareDistance;

        public PointDistance(Coordinate c) {
            this.c = c;
        }

        public boolean isSame(double x, double y, CoordinateReferenceSystem crs) {
            double tolerance = crs instanceof GeographicCRS ? 1.0E-9 : 1.0E-6;
            return Math.abs(this.c.x - x) < tolerance && Math.abs(this.c.x - y) < tolerance;
        }

        public double updateDistance(double x, double y, CoordinateReferenceSystem crs) {
            if (crs instanceof DefaultGeographicCRS) {
                double d = ((DefaultGeographicCRS)crs).distance(new double[]{this.c.x, this.c.y}, new double[]{x, y}).doubleValue();
                this.squareDistance = d * d;
            } else {
                double dx = this.c.x - x;
                double dy = this.c.y - y;
                this.squareDistance = dx * dx + dy * dy;
            }
            return this.squareDistance;
        }

        @Override
        public int compareTo(PointDistance o) {
            return (int)Math.signum(this.squareDistance - o.squareDistance);
        }

        public String toString() {
            return "[" + this.c.x + " " + this.c.y + " " + this.c.getZ() + "] - " + this.squareDistance;
        }
    }

    private class IDWElevationInterpolator
    implements CoordinateSequenceFilter {
        private static final int MAX_POINTS = 12;
        private final int scale;
        private final List<PointDistance> elevations;
        private final CoordinateReferenceSystem crs;

        public IDWElevationInterpolator(Geometry geom, CoordinateReferenceSystem crs) {
            this.elevations = this.gatherElevationPointCloud(geom);
            this.scale = crs instanceof GeographicCRS ? 9 : 6;
            this.crs = crs;
        }

        List<PointDistance> gatherElevationPointCloud(Geometry geom) {
            final ArrayList<PointDistance> results = new ArrayList<PointDistance>();
            geom.apply(new CoordinateSequenceFilter(){

                public boolean isGeometryChanged() {
                    return false;
                }

                public boolean isDone() {
                    return false;
                }

                public void filter(CoordinateSequence seq, int i) {
                    if (i > 0) {
                        return;
                    }
                    if (ClippedFeatureIterator.this.hasElevations(seq)) {
                        Coordinate[] coords = seq.toCoordinateArray();
                        for (int j = 0; j < coords.length; ++j) {
                            Coordinate c = coords[j];
                            if (j >= coords.length - 1 && c.equals((Object)coords[0]) || Double.isNaN(c.getZ())) continue;
                            results.add(new PointDistance(c));
                        }
                    }
                }
            });
            if (results.isEmpty()) {
                return null;
            }
            return results;
        }

        public boolean isGeometryChanged() {
            return true;
        }

        public boolean isDone() {
            return this.elevations == null;
        }

        public void filter(CoordinateSequence seq, int i) {
            if (this.elevations == null) {
                return;
            }
            if (seq.getDimension() < 3) {
                throw new IllegalArgumentException("Expecting a 3 dimensional coordinate sequence to re-apply the Z values");
            }
            double x = seq.getX(i);
            double y = seq.getY(i);
            for (PointDistance pd : this.elevations) {
                double distance = pd.updateDistance(x, y, this.crs);
                if (!(distance < 1.0E-6)) continue;
                seq.setOrdinate(i, 2, pd.c.getZ());
                return;
            }
            Collections.sort(this.elevations);
            double sum = 0.0;
            double weights = 0.0;
            int usedPoints = Math.min(12, this.elevations.size());
            for (int j = 0; j < usedPoints; ++j) {
                PointDistance pd = this.elevations.get(j);
                sum += pd.c.getZ() / pd.squareDistance;
                weights += 1.0 / pd.squareDistance;
            }
            double z = sum / weights;
            BigDecimal bd = BigDecimal.valueOf(z);
            double rz = bd.setScale(this.scale, RoundingMode.HALF_EVEN).doubleValue();
            seq.setOrdinate(i, 2, rz);
        }
    }
}

