/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.inspireatom;

import com.google.common.base.Joiner;
import java.nio.file.Path;
import java.util.List;
import jeeves.interfaces.Service;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.constants.Edit;
import org.fao.geonet.csw.common.util.Xml;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.MetadataNotFoundEx;
import org.fao.geonet.inspireatom.InspireAtomService;
import org.fao.geonet.inspireatom.util.InspireAtomUtil;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.setting.SettingManager;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.services.main.Result;
import org.fao.geonet.services.main.Search;
import org.fao.geonet.utils.Log;
import org.jdom.Content;
import org.jdom.Element;

public class AtomSearch
implements Service {
    private Search search = new Search();
    private Result result = new Result();

    public void init(Path appPath, ServiceConfig params) throws Exception {
        this.search.init(appPath, params);
        this.result.init(appPath, params);
    }

    public Element exec(Element params, ServiceContext context) throws Exception {
        SettingManager sm = (SettingManager)context.getBean(SettingManager.class);
        DataManager dm = (DataManager)context.getBean(DataManager.class);
        InspireAtomService service = (InspireAtomService)context.getBean(InspireAtomService.class);
        boolean inspireEnable = sm.getValueAsBool("system/inspire/enable");
        if (!inspireEnable) {
            Log.info((String)"geonetwork.atom", (Object)"Inspire is disabled");
            throw new Exception("Inspire is disabled");
        }
        String fileIdentifier = params.getChildText("fileIdentifier");
        if (StringUtils.isNotEmpty((String)fileIdentifier)) {
            String id = dm.getMetadataId(fileIdentifier);
            if (id == null) {
                throw new MetadataNotFoundEx("Metadata not found.");
            }
            Element md = dm.getMetadata(id);
            String schema = dm.getMetadataSchema(id);
            Lib.resource.checkPrivilege(context, id, ReservedOperation.view);
            List<String> datasetIdentifiers = InspireAtomUtil.extractRelatedDatasetsIdentifiers(schema, md, dm);
            params.removeChild("fileIdentifier");
            String values = Joiner.on((String)" or ").join(datasetIdentifiers);
            params.addContent((Content)new Element("identifier").setText(values));
        }
        params.addContent((Content)new Element("has_atom").setText("y"));
        params.addContent((Content)new Element("fast").setText("true"));
        String atomFormat = sm.getValue("system/inspire/atom");
        this.search.exec(params, context);
        if (atomFormat.equalsIgnoreCase("local")) {
            return this.result.exec(params, context);
        }
        Element results = this.result.exec(params, context);
        Element feeds = new Element("feeds");
        for (int i = 1; i < results.getChildren().size(); ++i) {
            String id = ((Element)results.getChildren().get(i)).getChild("info", Edit.NAMESPACE).getChildText("id");
            InspireAtomFeed feed = service.findByMetadataId(Integer.parseInt(id));
            Element feedEl = Xml.loadString((String)feed.getAtom(), (boolean)false);
            feeds.addContent((Content)feedEl.clone());
        }
        return feeds;
    }
}

