/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.PackageDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.jar.asm.MethodVisitor;

public interface InstrumentedType
extends TypeDescription {
    public InstrumentedType withField(String var1, TypeDescription var2, int var3);

    public InstrumentedType withMethod(String var1, TypeDescription var2, List<? extends TypeDescription> var3, List<? extends TypeDescription> var4, int var5);

    public InstrumentedType withInitializer(LoadedTypeInitializer var1);

    public InstrumentedType withInitializer(ByteCodeAppender var1);

    public LoadedTypeInitializer getLoadedTypeInitializer();

    public TypeInitializer getTypeInitializer();

    public TypeDescription detach();

    public static abstract class AbstractBase
    extends TypeDescription.AbstractTypeDescription.OfSimpleType
    implements InstrumentedType {
        protected final LoadedTypeInitializer loadedTypeInitializer;
        protected final TypeInitializer typeInitializer;
        protected final List<FieldDescription> fieldDescriptions;
        protected final List<MethodDescription> methodDescriptions;

        protected AbstractBase() {
            this.loadedTypeInitializer = LoadedTypeInitializer.NoOp.INSTANCE;
            this.typeInitializer = TypeInitializer.None.INSTANCE;
            this.fieldDescriptions = Collections.emptyList();
            this.methodDescriptions = Collections.emptyList();
        }

        protected AbstractBase(LoadedTypeInitializer loadedTypeInitializer, TypeInitializer typeInitializer, String typeName, List<? extends FieldDescription> fieldDescriptions, List<? extends MethodDescription> methodDescriptions) {
            this.loadedTypeInitializer = loadedTypeInitializer;
            this.typeInitializer = typeInitializer;
            this.fieldDescriptions = new ArrayList<FieldDescription>(fieldDescriptions.size());
            for (FieldDescription fieldDescription : fieldDescriptions) {
                this.fieldDescriptions.add(new FieldToken(typeName, fieldDescription));
            }
            this.methodDescriptions = new ArrayList<MethodDescription>(methodDescriptions.size());
            for (MethodDescription methodDescription : methodDescriptions) {
                this.methodDescriptions.add(new MethodToken(typeName, methodDescription));
            }
        }

        private TypeDescription withSubstitutedSelfReference(String typeName, TypeDescription typeDescription) {
            int arity = 0;
            TypeDescription componentType = typeDescription;
            while (componentType.isArray()) {
                ++arity;
                componentType = componentType.getComponentType();
            }
            return componentType.getName().equals(typeName) ? TypeDescription.ArrayProjection.of(this, arity) : typeDescription;
        }

        @Override
        public MethodDescription getEnclosingMethod() {
            return null;
        }

        @Override
        public TypeDescription getEnclosingType() {
            return null;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return null;
        }

        @Override
        public boolean isAnonymousClass() {
            return false;
        }

        @Override
        public String getCanonicalName() {
            return this.getName();
        }

        @Override
        public boolean isLocalClass() {
            return false;
        }

        @Override
        public boolean isMemberClass() {
            return false;
        }

        @Override
        public FieldList getDeclaredFields() {
            return new FieldList.Explicit(this.fieldDescriptions);
        }

        @Override
        public MethodList getDeclaredMethods() {
            return new MethodList.Explicit(this.methodDescriptions);
        }

        @Override
        public LoadedTypeInitializer getLoadedTypeInitializer() {
            return this.loadedTypeInitializer;
        }

        @Override
        public TypeInitializer getTypeInitializer() {
            return this.typeInitializer;
        }

        @Override
        public PackageDescription getPackage() {
            String packageName = this.getPackageName();
            return packageName == null ? null : new PackageDescription.Simple(packageName);
        }

        protected class MethodToken
        extends MethodDescription.AbstractMethodDescription {
            private final String internalName;
            private final TypeDescription returnType;
            private final List<TypeDescription> exceptionTypes;
            private final int modifiers;
            private final List<AnnotationDescription> declaredAnnotations;
            private final List<ParameterDescription> parameters;
            private final Object defaultValue;

            private MethodToken(String typeName, MethodDescription methodDescription) {
                this.internalName = methodDescription.getInternalName();
                this.returnType = AbstractBase.this.withSubstitutedSelfReference(typeName, methodDescription.getReturnType());
                this.exceptionTypes = new ArrayList<TypeDescription>(methodDescription.getExceptionTypes().size());
                for (TypeDescription typeDescription : methodDescription.getExceptionTypes()) {
                    this.exceptionTypes.add(AbstractBase.this.withSubstitutedSelfReference(typeName, typeDescription));
                }
                this.modifiers = methodDescription.getModifiers();
                this.declaredAnnotations = methodDescription.getDeclaredAnnotations();
                this.parameters = new ArrayList<ParameterDescription>(methodDescription.getParameters().size());
                for (ParameterDescription parameterDescription : methodDescription.getParameters()) {
                    this.parameters.add(new ParameterToken(typeName, parameterDescription));
                }
                this.defaultValue = methodDescription.getDefaultValue();
            }

            @Override
            public TypeDescription getReturnType() {
                return this.returnType;
            }

            @Override
            public TypeList getExceptionTypes() {
                return new TypeList.Explicit(this.exceptionTypes);
            }

            @Override
            public ParameterList getParameters() {
                return new ParameterList.Explicit(this.parameters);
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Explicit(this.declaredAnnotations);
            }

            @Override
            public String getInternalName() {
                return this.internalName;
            }

            @Override
            public TypeDescription getDeclaringType() {
                return AbstractBase.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }

            @Override
            public Object getDefaultValue() {
                return this.defaultValue;
            }

            protected class ParameterToken
            extends ParameterDescription.AbstractParameterDescription {
                private final TypeDescription parameterType;
                private final int index;
                private final String name;
                private final Integer modifiers;
                private final List<AnnotationDescription> parameterAnnotations;

                protected ParameterToken(String typeName, ParameterDescription parameterDescription) {
                    this.parameterType = AbstractBase.this.withSubstitutedSelfReference(typeName, parameterDescription.getTypeDescription());
                    this.index = parameterDescription.getIndex();
                    this.name = parameterDescription.isNamed() ? parameterDescription.getName() : null;
                    this.modifiers = parameterDescription.hasModifiers() ? Integer.valueOf(this.getModifiers()) : null;
                    this.parameterAnnotations = Collections.emptyList();
                }

                @Override
                public TypeDescription getTypeDescription() {
                    return this.parameterType;
                }

                @Override
                public MethodDescription getDeclaringMethod() {
                    return MethodToken.this;
                }

                @Override
                public int getIndex() {
                    return this.index;
                }

                @Override
                public boolean isNamed() {
                    return this.name != null;
                }

                @Override
                public boolean hasModifiers() {
                    return this.modifiers != null;
                }

                @Override
                public AnnotationList getDeclaredAnnotations() {
                    return new AnnotationList.Explicit(this.parameterAnnotations);
                }

                @Override
                public int getModifiers() {
                    return this.hasModifiers() ? this.modifiers.intValue() : super.getModifiers();
                }

                @Override
                public String getName() {
                    return this.isNamed() ? this.name : super.getName();
                }
            }
        }

        protected class FieldToken
        extends FieldDescription.AbstractFieldDescription {
            private final String name;
            private final TypeDescription fieldType;
            private final int modifiers;
            private final List<AnnotationDescription> declaredAnnotations;

            private FieldToken(String typeName, FieldDescription fieldDescription) {
                this.name = fieldDescription.getName();
                this.fieldType = AbstractBase.this.withSubstitutedSelfReference(typeName, fieldDescription.getFieldType());
                this.modifiers = fieldDescription.getModifiers();
                this.declaredAnnotations = fieldDescription.getDeclaredAnnotations();
            }

            @Override
            public TypeDescription getFieldType() {
                return this.fieldType;
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Explicit(this.declaredAnnotations);
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public String getDescriptor() {
                return this.fieldType.getDescriptor();
            }

            @Override
            public TypeDescription getDeclaringType() {
                return AbstractBase.this;
            }

            @Override
            public int getModifiers() {
                return this.modifiers;
            }
        }
    }

    public static interface TypeInitializer
    extends ByteCodeAppender {
        public boolean isDefined();

        public TypeInitializer expandWith(ByteCodeAppender var1);

        public ByteCodeAppender withReturn();

        public static class Simple
        implements TypeInitializer {
            private final ByteCodeAppender byteCodeAppender;

            public Simple(ByteCodeAppender byteCodeAppender) {
                this.byteCodeAppender = byteCodeAppender;
            }

            @Override
            public boolean isDefined() {
                return true;
            }

            @Override
            public TypeInitializer expandWith(ByteCodeAppender byteCodeAppender) {
                return new Simple(new ByteCodeAppender.Compound(this.byteCodeAppender, byteCodeAppender));
            }

            @Override
            public ByteCodeAppender withReturn() {
                return new ByteCodeAppender.Compound(this.byteCodeAppender, new ByteCodeAppender.Simple(MethodReturn.VOID));
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                return this.byteCodeAppender.apply(methodVisitor, implementationContext, instrumentedMethod);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.byteCodeAppender.equals(((Simple)other).byteCodeAppender);
            }

            public int hashCode() {
                return this.byteCodeAppender.hashCode();
            }

            public String toString() {
                return "InstrumentedType.TypeInitializer.Simple{byteCodeAppender=" + this.byteCodeAppender + '}';
            }
        }

        public static enum None implements TypeInitializer
        {
            INSTANCE;


            @Override
            public boolean isDefined() {
                return false;
            }

            @Override
            public TypeInitializer expandWith(ByteCodeAppender byteCodeAppender) {
                return new Simple(byteCodeAppender);
            }

            @Override
            public ByteCodeAppender withReturn() {
                throw new IllegalStateException("Cannot append return to non-defined type initializer");
            }

            @Override
            public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
                throw new IllegalStateException("Cannot apply a non-defined type initializer");
            }

            public String toString() {
                return "InstrumentedType.TypeInitializer.None." + this.name();
            }
        }
    }
}

