/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.locator.wildcard;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardContext;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardExpanderHandlerAware;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardStreamLocator;
import ro.isdc.wro.util.Function;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWildcardStreamLocator
implements WildcardStreamLocator,
WildcardExpanderHandlerAware {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultWildcardStreamLocator.class);
    public static final String RECURSIVE_WILDCARD = "**";
    private static final String WILDCARD_REGEX = "^(?:(?!http))(.)*[\\*\\?]+(.)*";
    private static final String REGEX_QUERY_PATH = "\\?.*";
    private static final Comparator<File> ALPHABETIC_FILE_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File o1, File o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };
    private Function<Collection<File>, Void> wildcardExpanderHandler;

    public static String stripQueryPath(String path) {
        return path.replaceFirst(REGEX_QUERY_PATH, "");
    }

    @Override
    public boolean hasWildcard(String uri) {
        return uri.matches(WILDCARD_REGEX);
    }

    @Override
    public InputStream locateStream(String uri, File folder) throws IOException {
        Collection<File> files = this.findMatchedFiles(new WildcardContext(uri, folder));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (File file : files) {
            if (file.isFile()) {
                FileInputStream is = new FileInputStream(file);
                IOUtils.copy((InputStream)is, (OutputStream)out);
                ((InputStream)is).close();
                continue;
            }
            LOG.debug("Ignoring folder: " + file);
        }
        return new BufferedInputStream(new ByteArrayInputStream(out.toByteArray()));
    }

    private IOFileFilter createWildcardCollectorFileFilter(WildcardContext wildcardContext, final Collection<File> allFiles) {
        Validate.notNull((Object)wildcardContext);
        Validate.notNull(allFiles);
        return new WildcardFileFilter(wildcardContext.getWildcard()){

            public boolean accept(File file) {
                boolean accept = super.accept(file);
                if (accept) {
                    LOG.debug("\tfound resource: {}", (Object)file.getPath());
                    allFiles.add(file);
                }
                return accept;
            }
        };
    }

    private Collection<File> findMatchedFiles(WildcardContext wildcardContext) throws IOException {
        this.validate(wildcardContext);
        TreeSet<File> allFiles = new TreeSet<File>(ALPHABETIC_FILE_COMPARATOR);
        IOFileFilter fileFilter = this.createWildcardCollectorFileFilter(wildcardContext, allFiles);
        FileUtils.listFiles((File)wildcardContext.getFolder(), (IOFileFilter)fileFilter, (IOFileFilter)this.getFolderFilter(wildcardContext.getWildcard()));
        this.triggerWildcardExpander(allFiles, wildcardContext);
        return allFiles;
    }

    private void validate(WildcardContext wildcardContext) throws IOException {
        Validate.notNull((Object)wildcardContext);
        String uri = wildcardContext.getUri();
        File folder = wildcardContext.getFolder();
        if (uri == null || folder == null || !folder.isDirectory()) {
            StringBuffer message = new StringBuffer("Invalid folder provided");
            if (folder != null) {
                message.append(", with path: ").append(folder.getPath());
            }
            message.append(", with fileNameWithWildcard: ").append(uri);
            throw new IOException(message.toString());
        }
        if (!this.hasWildcard(uri)) {
            throw new IOException("No wildcard detected for the uri: " + uri);
        }
        LOG.debug("uri: {}", (Object)uri);
        LOG.debug("folder: {}", (Object)folder.getPath());
        LOG.debug("wildcard: {}", (Object)wildcardContext.getWildcard());
    }

    void triggerWildcardExpander(Collection<File> allFiles, WildcardContext wildcardContext) throws IOException {
        LOG.debug("wildcard resources: {}", allFiles);
        if (allFiles.isEmpty()) {
            String message = String.format("No resource found for wildcard: %s", wildcardContext.getWildcard());
            LOG.warn(message);
            throw new IOException(message);
        }
        if (this.wildcardExpanderHandler != null) {
            try {
                this.wildcardExpanderHandler.apply(allFiles);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.debug("wildcard expanding error. Reporting original exception", (Throwable)e);
                throw new IOException("Exception during expanding wildcard: " + e.getMessage());
            }
        }
    }

    private IOFileFilter getFolderFilter(String wildcard) {
        boolean recursive = wildcard.contains(RECURSIVE_WILDCARD);
        return recursive ? TrueFileFilter.INSTANCE : FalseFileFilter.INSTANCE;
    }

    @Override
    public void setWildcardExpanderHandler(Function<Collection<File>, Void> handler) {
        this.wildcardExpanderHandler = handler;
    }
}

