/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import java.util.Collections;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom.NodeWrapper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected int documentNumber;
    protected boolean domLevel3;

    public DocumentWrapper(Node doc, String baseURI, Configuration config) {
        super(doc, null, 0);
        if (doc.getNodeType() != 9 && doc.getNodeType() != 11) {
            throw new IllegalArgumentException("Node must be a DOM Document or DocumentFragment");
        }
        this.node = doc;
        this.nodeKind = (short)9;
        this.baseURI = baseURI;
        this.docWrapper = this;
        this.domLevel3 = config.getDOMLevel() == 3;
        this.setConfiguration(config);
    }

    public NodeWrapper wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        Document doc = node.getOwnerDocument();
        if (doc == this.node || this.domLevel3 && doc != null && doc.isSameNode(this.node)) {
            return this.makeWrapper(node, this);
        }
        throw new IllegalArgumentException("DocumentWrapper#wrap: supplied node does not belong to the wrapped DOM document");
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String id) {
        if (this.node instanceof Document) {
            Element el = ((Document)this.node).getElementById(id);
            if (el == null) {
                return null;
            }
            return this.wrap(el);
        }
        return null;
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof DocumentWrapper)) {
            return false;
        }
        return this.node == ((DocumentWrapper)other).node;
    }

    public Iterator getUnparsedEntityNames() {
        return Collections.EMPTY_LIST.iterator();
    }

    public String[] getUnparsedEntity(String name) {
        return null;
    }
}

