/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgOperationRunner;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnNgGetProperties
extends SvnNgOperationRunner<SVNProperties, SvnGetProperties> {
    @Override
    protected SVNProperties run(SVNWCContext context) throws SVNException {
        for (SvnTarget target : ((SvnGetProperties)this.getOperation()).getTargets()) {
            if (!target.isFile()) continue;
            this.run(context, target.getFile());
        }
        return (SVNProperties)((SvnGetProperties)this.getOperation()).first();
    }

    protected SVNProperties run(SVNWCContext context, File target) throws SVNException {
        SVNProperties properties;
        boolean pristine = ((SvnGetProperties)this.getOperation()).getRevision() == SVNRevision.COMMITTED || ((SvnGetProperties)this.getOperation()).getRevision() == SVNRevision.BASE;
        SVNNodeKind kind = context.readKind(target, false);
        if (kind == SVNNodeKind.UNKNOWN || kind == SVNNodeKind.NONE) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", (Object)target);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (kind == SVNNodeKind.DIR) {
            if (((SvnGetProperties)this.getOperation()).getDepth() == SVNDepth.EMPTY) {
                if (!this.matchesChangelist(target)) {
                    return (SVNProperties)((SvnGetProperties)this.getOperation()).first();
                }
                properties = null;
                properties = pristine ? context.getDb().readPristineProperties(target) : context.getDb().readProperties(target);
                if (properties != null && !properties.isEmpty()) {
                    ((SvnGetProperties)this.getOperation()).receive(SvnTarget.fromFile(target), properties);
                }
            } else {
                SVNWCDb db = (SVNWCDb)context.getDb();
                db.readPropertiesRecursively(target, ((SvnGetProperties)this.getOperation()).getDepth(), false, pristine, ((SvnGetProperties)this.getOperation()).getApplicableChangelists(), (ISvnObjectReceiver)this.getOperation());
            }
        } else {
            properties = null;
            if (pristine) {
                properties = context.getDb().readPristineProperties(target);
            } else if (!context.isNodeStatusDeleted(target)) {
                properties = context.getDb().readProperties(target);
            }
            if (properties != null && !properties.isEmpty()) {
                ((SvnGetProperties)this.getOperation()).receive(SvnTarget.fromFile(target), properties);
            }
        }
        return (SVNProperties)((SvnGetProperties)this.getOperation()).first();
    }

    @Override
    public boolean isApplicable(SvnGetProperties operation, SvnWcGeneration wcGeneration) throws SVNException {
        return !operation.isRevisionProperties() && super.isApplicable(operation, wcGeneration);
    }
}

