/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services.thumbnail;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.services.ReadWriteController;
import lizard.tiff.Tiff;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.api.records.attachments.Store;
import org.fao.geonet.domain.MetadataResourceVisibility;
import org.fao.geonet.exceptions.ConcurrentUpdateEx;
import org.fao.geonet.kernel.DataManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.lib.Lib;
import org.fao.geonet.utils.IO;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@ReadWriteController
@Deprecated
public class Set {
    private static final ImageObserver IMAGE_OBSERVER = (img, infoflags, x, y, width, height) -> false;
    private static final String IMAGE_TYPE = "png";
    private static final String SMALL_SUFFIX = "_s";
    private static final String FNAME_PARAM = "fname=";

    @RequestMapping(value={"/{portal}/{lang}/md.thumbnail.upload"}, produces={"application/xml", "application/json"})
    @ResponseBody
    public Response serviceSpecificExec(HttpServletRequest request, @PathVariable String lang, @RequestParam(value="id") String id, @RequestParam(value="type") String type, @RequestParam(value="version") String version, @RequestParam(value="fname") MultipartFile file, @RequestParam(value="scalingDir") String scalingDir, @RequestParam(value="scaling", defaultValue="false") boolean scaling, @RequestParam(value="scalingFactor") int scalingFactor, @RequestParam(value="createSmall", defaultValue="false") boolean createSmall, @RequestParam(value="smallScalingDir", defaultValue="") String smallScalingDir, @RequestParam(value="smallScalingFactor", defaultValue="0") int smallScalingFactor) throws Exception {
        ServiceManager serviceManager = (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
        try (ServiceContext context = serviceManager.createServiceContext("md.thumbnail.upload", lang, request);){
            Lib.resource.checkEditPrivilege(context, id);
            GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
            DataManager dataMan = gc.getBean(DataManager.class);
            if (version != null && !StringUtils.isEmpty((String)version) && !dataMan.getVersion(id).equals(version)) {
                throw new ConcurrentUpdateEx(id);
            }
            if (createSmall) {
                Path smallFile = this.getFileName(file.getOriginalFilename(), true);
                this.removeOldThumbnail(context, id, "small", false);
                this.createThumbnail(context, file, id, smallScalingFactor, smallScalingDir, smallFile);
                dataMan.setThumbnail(context, id, true, smallFile.toString(), false);
            }
            this.removeOldThumbnail(context, id, type, false);
            if (scaling) {
                Path newFile = this.getFileName(file.getOriginalFilename(), type.equals("small"));
                this.createThumbnail(context, file, id, scalingFactor, scalingDir, newFile);
                dataMan.setThumbnail(context, id, type.equals("small"), newFile.toString(), false);
            } else {
                Store store = context.getBean("resourceStore", Store.class);
                IMetadataUtils metadataUtils = context.getBean(IMetadataUtils.class);
                String metadataUuid = metadataUtils.getMetadataUuid(id);
                store.putResource(context, metadataUuid, file, MetadataResourceVisibility.PUBLIC);
                dataMan.setThumbnail(context, id, type.equals("small"), file.getOriginalFilename(), false);
            }
            dataMan.indexMetadata(id, true, null);
            Response response = new Response(id, dataMan.getNewVersion(id));
            return response;
        }
    }

    public Element execOnHarvest(Element params, ServiceContext context, DataManager dataMan) throws Exception {
        String id = Util.getParam((Element)params, (String)"id");
        boolean createSmall = Util.getParam((Element)params, (String)"createSmall", (boolean)false);
        String file = Util.getParam((Element)params, (String)"fname");
        String scalingDir = Util.getParam((Element)params, (String)"scalingDir", (String)"width");
        boolean scaling = Util.getParam((Element)params, (String)"scaling", (boolean)false);
        int scalingFactor = Util.getParam((Element)params, (String)"scalingFactor", (int)1);
        String type = Util.getParam((Element)params, (String)"type");
        if (createSmall) {
            Path smallFile = this.getFileName(file, true);
            Path inFile = context.getUploadDir().resolve(file);
            FileWrappingMultipartFile multipartFile = new FileWrappingMultipartFile(inFile, file);
            String smallScalingDir = Util.getParam((Element)params, (String)"smallScalingDir", (String)"");
            int smallScalingFactor = Util.getParam((Element)params, (String)"smallScalingFactor", (int)0);
            this.createThumbnail(context, multipartFile, id, smallScalingFactor, smallScalingDir, smallFile);
            dataMan.setThumbnail(context, id, true, smallFile.toString(), false);
        }
        this.removeOldThumbnail(context, id, type, false);
        this.saveThumbnail(scaling, file, type, scalingDir, scalingFactor, dataMan, id, context);
        dataMan.indexMetadata(id, true, null);
        Element response = new Element("Response");
        response.addContent((Content)new Element("id").setText(id));
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveThumbnail(boolean scaling, String file, String type, String scalingDir, int scalingFactor, DataManager dataMan, String id, ServiceContext context) throws Exception {
        if (scaling) {
            Path newFile = this.getFileName(file, type.equals("small"));
            Path inFile = context.getUploadDir().resolve(file);
            FileWrappingMultipartFile multipartFile = new FileWrappingMultipartFile(inFile, file);
            this.createThumbnail(context, multipartFile, id, scalingFactor, scalingDir, newFile);
            try {
                Files.delete(inFile);
            }
            catch (IOException e) {
                context.error("Error while deleting thumbnail : " + inFile);
            }
            dataMan.setThumbnail(context, id, type.equals("small"), newFile.toString(), false);
        } else {
            Path inFile = context.getUploadDir().resolve(file);
            try {
                Store store = context.getBean("resourceStore", Store.class);
                IMetadataUtils metadataUtils = context.getBean(IMetadataUtils.class);
                String metadataUuid = metadataUtils.getMetadataUuid(id);
                store.putResource(context, metadataUuid, inFile, MetadataResourceVisibility.PUBLIC);
            }
            finally {
                IO.deleteFileOrDirectory((Path)inFile);
            }
            dataMan.setThumbnail(context, id, type.equals("small"), file, false);
        }
    }

    private void removeOldThumbnail(ServiceContext context, String id, String type, boolean indexAfterChange) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        DataManager dataMan = gc.getBean(DataManager.class);
        Element result = dataMan.getThumbnails(context, id);
        if (result == null) {
            throw new IllegalArgumentException("Metadata not found --> " + id);
        }
        if ((result = result.getChild(type)) == null) {
            return;
        }
        dataMan.unsetThumbnail(context, id, type.equals("small"), indexAfterChange);
        Store store = context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = context.getBean(IMetadataUtils.class);
        String metadataUuid = metadataUtils.getMetadataUuid(id);
        store.delResource(context, metadataUuid, this.getFileName(result.getText()));
    }

    private void createThumbnail(ServiceContext context, MultipartFile inFile, String metadataId, int scalingFactor, String scalingDir, Path filename) throws Exception {
        int height;
        int width;
        BufferedImage origImg = this.getImage(inFile);
        int imgWidth = origImg.getWidth();
        int imgHeight = origImg.getHeight();
        if (scalingDir.equals("width")) {
            width = scalingFactor;
            height = width * imgHeight / imgWidth;
        } else {
            height = scalingFactor;
            width = height * imgWidth / imgHeight;
        }
        Image thumb = origImg.getScaledInstance(width, height, 4);
        BufferedImage bimg = new BufferedImage(width, height, 3);
        Graphics2D g = bimg.createGraphics();
        g.drawImage(thumb, 0, 0, null);
        g.dispose();
        Store store = context.getBean("resourceStore", Store.class);
        IMetadataUtils metadataUtils = context.getBean(IMetadataUtils.class);
        String metadataUuid = metadataUtils.getMetadataUuid(metadataId);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bimg, IMAGE_TYPE, os);
        store.putResource(context, metadataUuid, filename.toString(), new ByteArrayInputStream(os.toByteArray()), null, MetadataResourceVisibility.PUBLIC, true);
    }

    private Path getFileName(String file, boolean small) {
        int pos = file.lastIndexOf(46);
        if (pos != -1) {
            file = file.substring(0, pos);
        }
        String path = small ? file + SMALL_SUFFIX + "." + IMAGE_TYPE : file + "." + IMAGE_TYPE;
        return IO.toPath((String)path, (String[])new String[0]);
    }

    @Nonnull
    public BufferedImage getImage(MultipartFile inFile) throws IOException {
        String lcFile = inFile.getName().toLowerCase();
        if (lcFile.endsWith(".tif") || lcFile.endsWith(".tiff")) {
            Image image = this.getTiffImage(inFile);
            int width = image.getWidth(IMAGE_OBSERVER);
            int height = image.getHeight(IMAGE_OBSERVER);
            BufferedImage bimg = new BufferedImage(width, height, 5);
            Graphics2D g = bimg.createGraphics();
            g.drawImage(image, 0, 0, null);
            g.dispose();
            return bimg;
        }
        try (InputStream in = inFile.getInputStream();){
            BufferedImage bufferedImage = ImageIO.read(in);
            return bufferedImage;
        }
    }

    private Image getTiffImage(MultipartFile inFile) throws IOException {
        Tiff t = new Tiff();
        t.read(inFile.getBytes());
        if (t.getPageCount() == 0) {
            throw new IOException("No images inside TIFF file");
        }
        return t.getImage(0);
    }

    private String getFileName(String file) {
        if (!file.contains(FNAME_PARAM)) {
            return file;
        }
        return file.substring(file.lastIndexOf(FNAME_PARAM) + FNAME_PARAM.length());
    }

    private static class FileWrappingMultipartFile
    implements MultipartFile {
        private final Path inFile;

        public FileWrappingMultipartFile(Path inFile, String file) {
            this.inFile = inFile;
        }

        public String getName() {
            return this.inFile.getFileName().toString();
        }

        public String getOriginalFilename() {
            return this.inFile.getFileName().toString();
        }

        public String getContentType() {
            return "image/" + com.google.common.io.Files.getFileExtension((String)this.getName());
        }

        public boolean isEmpty() {
            return this.getSize() == 0L;
        }

        public long getSize() {
            try {
                return Files.size(this.inFile);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public byte[] getBytes() throws IOException {
            return Files.readAllBytes(this.inFile);
        }

        public InputStream getInputStream() throws IOException {
            return IO.newInputStream((Path)this.inFile);
        }

        public void transferTo(File dest) throws IOException, IllegalStateException {
            Files.copy(this.inFile, dest.toPath(), new CopyOption[0]);
        }
    }

    @XmlRootElement(name="response")
    @XmlAccessorType(value=XmlAccessType.PROPERTY)
    public static final class Response {
        private final String id;
        private final String version;

        public Response(String id, String newVersion) {
            this.id = id;
            this.version = newVersion;
        }

        public String getId() {
            return this.id;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

