/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.services;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.Util;
import org.fao.geonet.domain.MetadataDraft;
import org.fao.geonet.exceptions.MissingParameterEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.datamanager.IMetadataUtils;
import org.fao.geonet.kernel.search.IndexAndTaxonomy;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.index.GeonetworkMultiReader;
import org.fao.geonet.repository.MetadataDraftRepository;
import org.jdom.Element;

public class Utils {
    public static String getIdentifierFromParameters(Element params, ServiceContext context, String uuidParamName, String idParamName) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        IMetadataUtils dm = gc.getBean(IMetadataUtils.class);
        String id = Utils.lookupByFileId(params, gc);
        if (id == null) {
            try {
                MetadataDraft draft;
                AccessManager am;
                String uuid = Util.getParam((Element)params, (String)uuidParamName);
                id = dm.getMetadataId(uuid);
                Boolean approved = Util.getParam((Element)params, (String)"approved", (boolean)true);
                if (!approved.booleanValue() && (am = context.getBean(AccessManager.class)).canEdit(context, id) && (draft = gc.getBean(MetadataDraftRepository.class).findOneByUuid(uuid)) != null) {
                    id = String.valueOf(draft.getId());
                }
            }
            catch (MissingParameterEx x) {
                try {
                    id = Util.getParam((Element)params, (String)idParamName);
                }
                catch (MissingParameterEx xx) {
                    throw new Exception("Request must contain a UUID (" + uuidParamName + ") or an ID (" + idParamName + ")");
                }
            }
        }
        return id;
    }

    private static String lookupByFileId(Element params, GeonetContext gc) throws Exception {
        String fileId = Util.getParam((Element)params, (String)"fileIdentifier", null);
        if (fileId == null) {
            return null;
        }
        return Utils.lookupMetadataIdFromFileId(gc, fileId);
    }

    public static String lookupMetadataIdFromFileId(GeonetContext gc, String fileId) throws IOException, InterruptedException {
        SearchManager searchManager = gc.getBean(SearchManager.class);
        return Utils.lookupMetadataIdFromFileId(fileId, searchManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lookupMetadataIdFromFileId(String fileId, SearchManager searchManager) throws IOException, InterruptedException {
        TermQuery query = new TermQuery(new Term("fileId", fileId));
        IndexAndTaxonomy indexAndTaxonomy = searchManager.getIndexReader(null, -1L);
        GeonetworkMultiReader reader = indexAndTaxonomy.indexReader;
        try {
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            TopDocs tdocs = searcher.search((Query)query, 1);
            if (tdocs.totalHits > 0) {
                Set<String> id = Collections.singleton("_id");
                Document element = reader.document(tdocs.scoreDocs[0].doc, id);
                String string = element.get("_id");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            searchManager.releaseIndexReader(indexAndTaxonomy);
        }
    }

    public static String getIdentifierFromParameters(Element params, ServiceContext context) throws Exception {
        return Utils.getIdentifierFromParameters(params, context, "uuid", "id");
    }
}

