/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.resources;

import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.XmlRequest;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public abstract class Resources {
    protected static final Set<String> IMAGE_READ_SUFFIXES;
    protected static final Set<String> IMAGE_WRITE_SUFFIXES;
    protected static final Set<String> IMAGE_EXTENSIONS;

    public Path locateLogosDir(ServiceContext context) {
        return this.getPath(context, "logos");
    }

    @Nullable
    protected abstract Path findImagePath(String var1, Path var2) throws IOException;

    @Nullable
    public abstract ResourceHolder getImage(ServiceContext var1, String var2, Path var3) throws IOException;

    public abstract ResourceHolder getWritableImage(ServiceContext var1, String var2, Path var3);

    private Path getPath(ServiceContext context, String logos) {
        Path base = this.getBasePath(context);
        return base.resolve("images").resolve(logos);
    }

    protected Path getBasePath(ServiceContext context) {
        ServletContext servletContext = null;
        if (context.getServlet() != null) {
            servletContext = context.getServlet().getServletContext();
        }
        return servletContext == null ? context.getAppPath() : this.locateResourcesDir(servletContext, (ApplicationContext)context.getApplicationContext());
    }

    public Path locateHarvesterLogosDir(ServiceContext context) {
        return this.getPath(context, "harvesting");
    }

    public Path locateHarvesterLogosDirSMVC(ApplicationContext applicationContext) {
        return this.locateResourcesDir(null, applicationContext).resolve("images").resolve("harvesting");
    }

    protected Path locateResourcesDir(ServiceContext context) {
        if (context.getServlet() != null) {
            return this.locateResourcesDir(context.getServlet().getServletContext(), (ApplicationContext)context.getApplicationContext());
        }
        return context.getBean(GeonetworkDataDirectory.class).getResourcesDir();
    }

    public Path locateResourcesDir(ServletContext context, ApplicationContext applicationContext) {
        Path property;
        block3: {
            property = null;
            try {
                property = ((GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class)).getResourcesDir();
            }
            catch (NoSuchBeanDefinitionException e) {
                String realPath = context.getRealPath("/WEB-INF/data/resources");
                if (realPath == null) break block3;
                property = IO.toPath((String)realPath, (String[])new String[0]);
            }
        }
        if (property == null) {
            return IO.toPath((String)"resources", (String[])new String[0]);
        }
        return property;
    }

    abstract Pair<byte[], Long> loadResource(Path var1, ServletContext var2, Path var3, String var4, byte[] var5, long var6) throws IOException;

    public Pair<byte[], Long> loadImage(ServletContext context, Path appPath, String filename, byte[] defaultValue) throws IOException {
        return this.loadResource(null, context, appPath, filename, defaultValue, -1L);
    }

    protected abstract Path locateResource(@Nullable Path var1, ServletContext var2, Path var3, @Nonnull String var4) throws IOException;

    public void copyLogo(ServiceContext context, String icon, String destName) {
        ServletContext servletContext = null;
        if (context.getServlet() != null) {
            servletContext = context.getServlet().getServletContext();
        }
        Path appDir = context.getAppPath();
        Path logosDir = this.locateLogosDir(context);
        try {
            Path srcPath = this.locateResource(this.locateResourcesDir(context), servletContext, appDir, icon);
            String extension = com.google.common.io.Files.getFileExtension((String)srcPath.getFileName().toString());
            try (ResourceHolder src = this.getImage(context, srcPath.getFileName().toString(), srcPath.getParent());){
                if (src == null) {
                    throw new IOException("Resource not found: " + srcPath.toString());
                }
                try (ResourceHolder des = this.getWritableImage(context, destName + "." + extension, logosDir);){
                    if (src != null) {
                        Files.copy(src.getPath(), des.getPath(), StandardCopyOption.REPLACE_EXISTING, LinkOption.NOFOLLOW_LINKS);
                    } else {
                        des.abort();
                    }
                }
            }
        }
        catch (IOException e) {
            context.warning("Cannot copy icon -> " + e.getMessage());
            context.warning(" (C) Source : " + icon);
            context.warning(" (C) Destin : " + logosDir);
        }
    }

    public void copyUnknownLogo(ServiceContext context, String destName) {
        this.copyLogo(context, "unknown-filename.png", destName);
    }

    public Set<Path> listFiles(ServiceContext context, String logosDir, DirectoryStream.Filter<Path> iconFilter) {
        Path dir = this.locateResourcesDir(context).resolve("images").resolve(logosDir);
        HashSet<Path> result = new HashSet<Path>();
        this.addFiles(iconFilter, dir, result);
        return result;
    }

    protected abstract void addFiles(DirectoryStream.Filter<Path> var1, Path var2, HashSet<Path> var3);

    @Nullable
    public abstract FileTime getLastModified(Path var1, ServletContext var2, Path var3, String var4) throws IOException;

    public abstract void deleteImageIfExists(String var1, Path var2) throws IOException;

    public void createImageFromReq(ServiceContext context, Path logoDir, String filename, XmlRequest req) throws IOException {
        try (ResourceHolder file = this.getWritableImage(context, filename, logoDir);){
            try {
                req.executeLarge(file.getPath());
            }
            catch (IOException e) {
                file.abort();
                throw e;
            }
        }
    }

    static {
        IMAGE_EXTENSIONS = Sets.newHashSet((Object[])ImageIO.getReaderFileSuffixes());
        HashSet<String> suffixes = new HashSet<String>();
        for (String string : ImageIO.getReaderFileSuffixes()) {
            suffixes.add(string.toLowerCase());
        }
        IMAGE_READ_SUFFIXES = Collections.unmodifiableSet(suffixes);
        suffixes = new HashSet();
        for (String string : ImageIO.getReaderFileSuffixes()) {
            suffixes.add(string.toLowerCase());
        }
        IMAGE_WRITE_SUFFIXES = Collections.unmodifiableSet(suffixes);
    }

    public static interface ResourceHolder
    extends Closeable {
        public Path getPath();

        public String getRelativePath();

        public FileTime getLastModifiedTime() throws IOException;

        public void abort();
    }
}

