/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.lib;

import java.nio.file.Path;
import java.util.Set;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.GeonetContext;
import org.fao.geonet.domain.Operation;
import org.fao.geonet.domain.ReservedOperation;
import org.fao.geonet.exceptions.OperationNotAllowedEx;
import org.fao.geonet.kernel.AccessManager;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.security.access.AccessDeniedException;

public class ResourceLib {
    public Path getDir(String access, int id) {
        Path mdDir = this.getMetadataDir((GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class), id);
        String subDir = access != null && access.equals("public") ? "public" : "private";
        return mdDir.resolve(subDir);
    }

    public Path getMetadataDir(GeonetworkDataDirectory dataDirectory, int id) {
        return this.getMetadataDir(dataDirectory, id + "");
    }

    public Path getMetadataDir(GeonetworkDataDirectory dataDirectory, String id) {
        Path dataDir = dataDirectory.getMetadataDataDir();
        return this.getMetadataDir(dataDir, id);
    }

    public Path getMetadataDir(Path dataDir, String id) {
        String group = this.pad(Integer.parseInt(id) / 100, 3);
        String groupDir = group + "00-" + group + "99";
        return dataDir.resolve(groupDir).resolve(id);
    }

    public void checkPrivilege(ServiceContext context, String id, ReservedOperation operation) throws Exception {
        AccessManager accessMan = context.getBean(AccessManager.class);
        Set<Operation> hsOper = accessMan.getOperations(context, id, context.getIpAddress());
        for (Operation op : hsOper) {
            if (!op.is(operation)) continue;
            return;
        }
        this.denyAccess(context);
    }

    public void denyAccess(ServiceContext context) throws Exception {
        if (context.getUserSession().isAuthenticated()) {
            throw new AccessDeniedException("User is not permitted to access this resource");
        }
        throw new OperationNotAllowedEx();
    }

    public void checkEditPrivilege(ServiceContext context, String id) throws Exception {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        AccessManager am = gc.getBean(AccessManager.class);
        if (!am.canEdit(context, id)) {
            this.denyAccess(context);
        }
    }

    @Deprecated
    public Path getRemovedDir(ServiceContext context) {
        GeonetContext gc = (GeonetContext)context.getHandlerContext("contextName");
        return gc.getBean(GeonetworkDataDirectory.class).getBackupDir();
    }

    @Deprecated
    public Path getRemovedDir(ServiceContext context, String id) {
        return this.getRemovedDir(this.getRemovedDir(context), id);
    }

    public Path getRemovedDir(int id) {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        GeonetworkDataDirectory dataDirectory = (GeonetworkDataDirectory)appContext.getBean(GeonetworkDataDirectory.class);
        return this.getRemovedDir(dataDirectory.getBackupDir(), String.valueOf(id));
    }

    public Path getRemovedDir(Path removedDir, String id) {
        String group = this.pad(Integer.parseInt(id) / 100, 3);
        String groupDir = group + "00-" + group + "99";
        return removedDir.resolve(groupDir);
    }

    private String pad(int group, int lenght) {
        String text = Integer.toString(group);
        while (text.length() < lenght) {
            text = "0" + text;
        }
        return text;
    }
}

