/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.security.keycloak;

import java.util.ArrayList;
import java.util.Collection;
import org.fao.geonet.kernel.security.keycloak.KeycloakUserUtils;
import org.keycloak.KeycloakPrincipal;
import org.keycloak.adapters.spi.KeycloakAccount;
import org.keycloak.adapters.springsecurity.account.KeycloakRole;
import org.keycloak.adapters.springsecurity.token.KeycloakAuthenticationToken;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchyAuthoritiesMapper;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleAuthorityMapper;
import org.springframework.security.core.userdetails.UserDetails;

public class KeycloakAuthenticationProvider
extends org.keycloak.adapters.springsecurity.authentication.KeycloakAuthenticationProvider {
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;
    @Autowired
    private KeycloakUserUtils keycloakUserUtils;

    @Autowired
    public KeycloakAuthenticationProvider(RoleHierarchy roleHierarchy) {
        SimpleAuthorityMapper grantedAuthorityMapper = new SimpleAuthorityMapper();
        grantedAuthorityMapper.setPrefix("");
        KeycloakRoleHierarchyAuthoritiesMapper resolvingMapper = new KeycloakRoleHierarchyAuthoritiesMapper(roleHierarchy, (GrantedAuthoritiesMapper)grantedAuthorityMapper);
        this.grantedAuthoritiesMapper = resolvingMapper;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        KeycloakAuthenticationToken token = (KeycloakAuthenticationToken)authentication;
        Collection<? extends GrantedAuthority> keycloakAuthorities = this.mapAuthorities(this.getKeycloakRoles(token));
        Collection<? extends GrantedAuthority> grantedAuthorities = this.addUserSpecificAuthorities(authentication, keycloakAuthorities);
        return new KeycloakAuthenticationToken((KeycloakAccount)token.getAccount(), token.isInteractive(), grantedAuthorities);
    }

    protected Collection<? extends GrantedAuthority> addUserSpecificAuthorities(Authentication authentication, Collection<? extends GrantedAuthority> authorities) {
        UserDetails userDetails;
        KeycloakPrincipal keycloakPrincipal;
        ArrayList<? extends GrantedAuthority> result = new ArrayList<GrantedAuthority>();
        result.addAll(authorities);
        if (authentication.getPrincipal() instanceof KeycloakPrincipal && (keycloakPrincipal = (KeycloakPrincipal)authentication.getPrincipal()) != null && (userDetails = this.keycloakUserUtils.getUserDetails(keycloakPrincipal.getKeycloakSecurityContext().getToken(), true)) != null && userDetails.getAuthorities() != null) {
            result.addAll(userDetails.getAuthorities());
        }
        return result;
    }

    protected Collection<? extends GrantedAuthority> getKeycloakRoles(KeycloakAuthenticationToken token) {
        ArrayList<KeycloakRole> keycloakRoles = new ArrayList<KeycloakRole>();
        for (String role : token.getAccount().getRoles()) {
            keycloakRoles.add(new KeycloakRole(role));
        }
        return keycloakRoles;
    }

    private Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
        return this.grantedAuthoritiesMapper != null ? this.grantedAuthoritiesMapper.mapAuthorities(authorities) : authorities;
    }

    public boolean supports(Class<?> aClass) {
        return KeycloakAuthenticationToken.class.isAssignableFrom(aClass);
    }

    public class KeycloakRoleHierarchyAuthoritiesMapper
    extends RoleHierarchyAuthoritiesMapper {
        private final GrantedAuthoritiesMapper delegate;

        public KeycloakRoleHierarchyAuthoritiesMapper(RoleHierarchy roleHierarchy, GrantedAuthoritiesMapper delegate) {
            super(roleHierarchy);
            this.delegate = delegate;
        }

        public Collection<? extends GrantedAuthority> mapAuthorities(Collection<? extends GrantedAuthority> authorities) {
            Collection transformedAuthorities = this.delegate.mapAuthorities(authorities);
            Collection expanededAuthorities = super.mapAuthorities(transformedAuthorities);
            return expanededAuthorities;
        }
    }
}

