/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.spatial;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.OpenBitSet;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.search.spatial.SpatialFilter;
import org.fao.geonet.kernel.search.spatial.SpatialIndexWriter;
import org.geotools.data.FeatureSource;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class OverlapsBBoxFilter
extends SpatialFilter {
    private Set<String> intersected;

    public OverlapsBBoxFilter(Query query, int numHits, Geometry geom, Pair<FeatureSource<SimpleFeatureType, SimpleFeature>, SpatialIndex> sourceAccessor) throws IOException {
        super(query, numHits, geom, sourceAccessor);
    }

    @Override
    public DocIdSet getDocIdSet(AtomicReaderContext context, Bits acceptDocs) throws IOException {
        final OpenBitSet bits = new OpenBitSet((long)context.reader().maxDoc());
        final Set<String> intersected = this.intersected();
        if (intersected.isEmpty() || this._hits >= this._numHits) {
            return bits;
        }
        new IndexSearcher((IndexReader)context.reader()).search(this._query, new Collector(){
            private int docBase;
            private Document document;
            private AtomicReader reader;

            public void setScorer(Scorer scorer) {
            }

            public boolean acceptsDocsOutOfOrder() {
                return true;
            }

            public void collect(int doc) {
                doc += this.docBase;
                try {
                    this.document = this.reader.document(doc, OverlapsBBoxFilter.this._fieldsToLoad);
                    String key = this.document.get("_id");
                    if (intersected.contains(key) && OverlapsBBoxFilter.this._hits < OverlapsBBoxFilter.this._numHits) {
                        ++OverlapsBBoxFilter.this._hits;
                        bits.set((long)(doc + this.docBase));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public void setNextReader(AtomicReaderContext context) throws IOException {
                this.docBase = context.docBase;
                this.reader = context.reader();
            }
        });
        return bits;
    }

    protected synchronized Set<String> intersected() {
        if (this.intersected == null) {
            this.intersected = new HashSet<String>();
            SpatialIndex spatialIndex = (SpatialIndex)this.sourceAccessor.two();
            Envelope env = this._geom.getEnvelopeInternal();
            spatialIndex.query(env, new ItemVisitor(){

                public void visitItem(Object o) {
                    SpatialIndexWriter.Data data = (SpatialIndexWriter.Data)o;
                    OverlapsBBoxFilter.this.intersected.add(data.getMetadataId());
                }
            });
        }
        return this.intersected;
    }

    @Override
    protected Filter createFilter(FeatureSource<SimpleFeatureType, SimpleFeature> source) {
        return null;
    }
}

