/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.index;

import com.google.common.base.Predicate;
import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherLifetimeManager;
import org.apache.lucene.search.SearcherManager;
import org.fao.geonet.kernel.search.LuceneConfig;
import org.fao.geonet.kernel.search.index.SearcherVersionTracker;
import org.fao.geonet.kernel.search.index.TaxonomyIndexTracker;
import org.fao.geonet.utils.Log;

class GeonetworkNRTManager
implements Closeable {
    String language;
    private ControlledRealTimeReopenThread<IndexSearcher> reopenThread;
    private SearcherManager actualManager;
    private SearcherLifetimeManager lifetimeManager = new SearcherLifetimeManager();
    private TaxonomyIndexTracker taxonomyTracker;

    public GeonetworkNRTManager(LuceneConfig luceneConfig, String language, TrackingIndexWriter writer, IndexWriter iWriter, SearcherFactory searcherFactory, boolean applyAllDeletes, TaxonomyIndexTracker taxonomyTracker) throws IOException {
        this.taxonomyTracker = taxonomyTracker;
        this.actualManager = new SearcherManager(iWriter, applyAllDeletes, searcherFactory);
        this.language = language;
        if (luceneConfig.useNRTManagerReopenThread()) {
            double targetMaxStaleSec = luceneConfig.getNRTManagerReopenThreadMaxStaleSec();
            double targetMinStaleSec = luceneConfig.getNRTManagerReopenThreadMinStaleSec();
            this.reopenThread = new ControlledRealTimeReopenThread(writer, (ReferenceManager)this.actualManager, targetMaxStaleSec, targetMinStaleSec);
            this.reopenThread.setName("NRT Reopen Thread for " + language + " index");
            this.reopenThread.setPriority(Math.min(Thread.currentThread().getPriority() + 2, 10));
            this.reopenThread.setDaemon(true);
            this.reopenThread.start();
        }
    }

    public SearcherLifetimeManager getLifetimeManager() {
        return this.lifetimeManager;
    }

    public String toString() {
        return "NRT Manager for " + this.language + " index";
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.reopenThread);
        IOUtils.closeQuietly((Closeable)this.lifetimeManager);
        IOUtils.closeQuietly((Closeable)this.actualManager);
    }

    public synchronized AcquireResult acquire(long versionToken, SearcherVersionTracker versionTracker) throws IOException {
        Long version = -1L;
        if (versionToken != -1L && (version = Long.valueOf(versionTracker.get(this.language, versionToken))) == null) {
            version = -1L;
        }
        IndexSearcher searcher = this.lifetimeManager.acquire(version.longValue());
        boolean lastVersionUpToDate = false;
        if (searcher == null) {
            IndexSearcher lastSearcher;
            searcher = (IndexSearcher)this.actualManager.acquire();
            version = this.lifetimeManager.record(searcher);
            Long lastVersion = versionTracker.last(this.language);
            if (lastVersion != null && (lastSearcher = this.lifetimeManager.acquire(lastVersion.longValue())) == searcher) {
                this.actualManager.release((Object)searcher);
                searcher = lastSearcher;
                lastVersionUpToDate = true;
            }
        } else {
            version = versionToken;
        }
        return new AcquireResult(version, lastVersionUpToDate, searcher, version != versionToken);
    }

    public void maybeRefreshBlocking() throws IOException {
        this.taxonomyTracker.maybeRefresh();
        this.actualManager.maybeRefreshBlocking();
    }

    public void release(IndexSearcher searcher) throws IOException {
        this.actualManager.release((Object)searcher);
    }

    public void purgeExpiredSearchers(SearcherVersionTracker versionTracker) {
        try {
            this.lifetimeManager.prune((SearcherLifetimeManager.Pruner)new SearcherLifetimeManager.PruneByAge(1800.0));
        }
        catch (IOException e) {
            Log.error((String)"geonetwork.lucene", (Object)("error pruning SearcherLifetimeManager for: " + this), (Throwable)e);
        }
        versionTracker.prune(this.language, new Predicate<Long>(){

            public boolean apply(Long version) {
                IndexSearcher searcher = GeonetworkNRTManager.this.lifetimeManager.acquire(version.longValue());
                if (searcher != null) {
                    try {
                        GeonetworkNRTManager.this.lifetimeManager.release(searcher);
                    }
                    catch (IOException e) {
                        Log.error((String)"geonetwork.lucene", (Object)e.getMessage(), (Throwable)e);
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public String getLanguage() {
        return this.language;
    }

    static final class AcquireResult {
        final long version;
        final boolean lastVersionUpToDate;
        final IndexSearcher searcher;
        final boolean newSearcher;

        private AcquireResult(long version, boolean lastVersionUpToDate, IndexSearcher searcher, boolean newSearcher) {
            this.version = version;
            this.lastVersionUpToDate = lastVersionUpToDate;
            this.searcher = searcher;
            this.newSearcher = newSearcher;
        }
    }
}

