/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.facet;

import java.util.ArrayList;
import java.util.List;
import org.fao.geonet.exceptions.BadParameterEx;
import org.fao.geonet.kernel.search.facet.Format;
import org.fao.geonet.kernel.search.facet.ItemConfig;

public class SummaryType {
    private static final String TEMPLATE = "  * %s {format=%s}%n";
    private String name;
    private List<ItemConfig> items;
    private Format format;

    public SummaryType(String name, List<ItemConfig> items) {
        this.name = name;
        this.items = items;
        this.format = Format.FACET_NAME;
    }

    public String getName() {
        return this.name;
    }

    public List<ItemConfig> getItems() {
        return this.items;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public ItemConfig get(String name) {
        for (ItemConfig item : this.items) {
            if (!item.getDimension().getName().equals(name)) continue;
            return item;
        }
        throw new BadParameterEx("summaryItems", (Object)(name + " Legal values are: " + this.getDimensionNames()));
    }

    private List<String> getDimensionNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ItemConfig item : this.items) {
            result.add(item.getDimension().getName());
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(TEMPLATE, new Object[]{this.name, this.format}));
        for (ItemConfig item : this.items) {
            sb.append(item);
        }
        return sb.toString();
    }
}

