/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.facet;

import org.fao.geonet.kernel.search.Translator;
import org.fao.geonet.kernel.search.TranslatorFactory;
import org.fao.geonet.kernel.search.facet.Dimension;
import org.fao.geonet.kernel.search.facet.SortBy;
import org.fao.geonet.kernel.search.facet.SortOrder;

public class ItemConfig {
    public static final int DEFAULT_MAX_KEYS = 10;
    public static final int DEFAULT_PAGE_SIZE = 5000;
    public static final int DEFAULT_DEPTH = 1;
    private static final String TEMPLATE = "   * %s: {max=%s, sort by=%s, sort order=%s, translator=%s, depth=%s}%n";
    private final Dimension dimension;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private int max;
    private int depth;
    private String translator;
    private TranslatorFactory translatorFactory;
    private int pageSize;

    public ItemConfig(Dimension dimension, TranslatorFactory translatorFactory) {
        this.dimension = dimension;
        this.translatorFactory = translatorFactory;
        this.max = 10;
        this.sortBy = SortBy.COUNT;
        this.sortOrder = SortOrder.DESCENDING;
        this.depth = 1;
        this.pageSize = 5000;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public void setSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTranslator(String translator) {
        this.translator = translator;
    }

    public Translator getTranslator(String langCode) {
        return this.translatorFactory.getTranslator(this.translator, langCode);
    }

    public String toString() {
        return String.format(TEMPLATE, new Object[]{this.dimension.getName(), this.max, this.sortBy, this.sortOrder, this.translator, this.depth});
    }
}

