/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.search.facet;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.facet.FacetsConfig;
import org.fao.geonet.kernel.search.facet.Dimension;

public class Facets {
    private static final String FACET_CONFIGURATION_HEADER = " * Facet configuration:\n";
    private List<Dimension> dimensions;

    public Facets(List<Dimension> dimensions) {
        this.dimensions = dimensions;
    }

    public List<Dimension> getDimensions() {
        return new ArrayList<Dimension>(this.dimensions);
    }

    public List<Dimension> getDimensionsUsing(String indexKey) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        for (Dimension dimension : this.dimensions) {
            String dimensionIndexKey = dimension.getIndexKey();
            if (dimensionIndexKey == null || !dimensionIndexKey.equals(indexKey)) continue;
            result.add(dimension);
        }
        return result;
    }

    public FacetsConfig getAsLuceneFacetsConfig() {
        FacetsConfig result = new FacetsConfig();
        for (Dimension dimension : this.dimensions) {
            if (dimension.isLocalized()) {
                for (String langCode : dimension.getLocales()) {
                    String dimensionName = dimension.getName(langCode);
                    result.setIndexFieldName(dimensionName, dimension.getFacetFieldName(langCode));
                    result.setMultiValued(dimensionName, true);
                    result.setHierarchical(dimensionName, true);
                }
            }
            String dimensionName = dimension.getName();
            result.setIndexFieldName(dimensionName, dimension.getFacetFieldName(null));
            result.setMultiValued(dimensionName, true);
            result.setHierarchical(dimensionName, true);
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(FACET_CONFIGURATION_HEADER);
        for (Dimension dimension : this.dimensions) {
            sb.append(dimension);
        }
        return sb.toString();
    }
}

