/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.mef;

import java.nio.file.Path;
import org.fao.geonet.exceptions.BadFormatEx;
import org.fao.geonet.kernel.mef.IMEFVisitor;
import org.fao.geonet.kernel.mef.IVisitor;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;

public class XmlVisitor
implements IVisitor {
    @Override
    public void visit(Path xmlFile, IMEFVisitor v) throws Exception {
        this.handleXml(xmlFile, v);
    }

    @Override
    public Element handleXml(Path xmlFile, IMEFVisitor v) throws Exception {
        Element md = Xml.loadFile((Path)xmlFile);
        if (md == null) {
            throw new BadFormatEx("Missing xml metadata file .");
        }
        v.handleMetadata(md, 0);
        Element info = new Element("info");
        v.handleInfo(info, 0);
        return info;
    }

    @Override
    public void handleBin(Path mefFile, IMEFVisitor v, Element info, int index) throws Exception {
    }
}

