/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.guiservices.XmlFile;
import jeeves.server.overrides.ConfigurationOverrides;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.SystemInfo;
import org.fao.geonet.ZipUtil;
import org.fao.geonet.constants.Geonet;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.exceptions.NoSchemaMatchesException;
import org.fao.geonet.exceptions.OperationAbortedEx;
import org.fao.geonet.exceptions.SchemaMatchConflictException;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.kernel.Schema;
import org.fao.geonet.kernel.SchemaPluginUrlRewrite;
import org.fao.geonet.kernel.SchemaSuggestions;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.kernel.schema.MetadataSchemaOperationFilter;
import org.fao.geonet.kernel.schema.SchemaLoader;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.kernel.setting.SettingInfo;
import org.fao.geonet.repository.SchematronCriteriaGroupRepository;
import org.fao.geonet.repository.SchematronRepository;
import org.fao.geonet.utils.IO;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.PrefixUrlRewrite;
import org.fao.geonet.utils.ResolverRewriteDirective;
import org.fao.geonet.utils.ResolverWrapper;
import org.fao.geonet.utils.Version;
import org.fao.geonet.utils.Xml;
import org.fao.geonet.utils.nio.NioPathAwareCatalogResolver;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.springframework.context.ApplicationContext;

public class SchemaManager {
    private static final int MODE_NEEDLE = 0;
    private static final int MODE_ROOT = 1;
    private static final int MODE_NEEDLEWITHVALUE = 2;
    private static final int MODE_ATTRIBUTEWITHVALUE = 3;
    private static final int MODE_NAMESPACE = 4;
    private static final String GEONET_SCHEMA_URI = "http://geonetwork-opensource.org/schemas/schema-ident";
    private static final Namespace GEONET_SCHEMA_PREFIX_NS = Namespace.getNamespace((String)"gns", (String)"http://geonetwork-opensource.org/schemas/schema-ident");
    private static final Namespace GEONET_SCHEMA_NS = Namespace.getNamespace((String)"http://geonetwork-opensource.org/schemas/schema-ident");
    private static int activeReaders = 0;
    private static int activeWriters = 0;
    private Map<String, Schema> hmSchemas = new HashMap<String, Schema>();
    private Map<String, Namespace> hmSchemasTypenames = new HashMap<String, Namespace>();
    private String[] fnames = new String[]{"labels.xml", "codelists.xml", "strings.xml"};
    private Path schemaPluginsDir;
    private Path schemaPluginsCat;
    private boolean createOrUpdateSchemaCatalog;
    private String defaultLang;
    private String defaultSchema;
    private Path basePath;
    private Path resourcePath;
    private int numberOfCoreSchemasAdded = 0;

    public static Path registerXmlCatalogFiles(Path webappDir, Path schemapluginUriCatalog) {
        Path webInf = webappDir.resolve("WEB-INF");
        String catalogProp = System.getProperty("jeeves.xml.catalog.files");
        if (catalogProp == null) {
            catalogProp = "";
        }
        if (!catalogProp.equals("")) {
            Log.info((String)"geonetwork.schemamanager", (Object)("Overriding jeeves.xml.catalog.files property (was set to " + catalogProp + ")"));
        }
        catalogProp = webInf.resolve("oasis-catalog.xml") + ";" + schemapluginUriCatalog;
        System.setProperty("jeeves.xml.catalog.files", catalogProp);
        Log.info((String)"geonetwork.schemamanager", (Object)("jeeves.xml.catalog.files property set to " + catalogProp));
        Path blankXSLFile = webappDir.resolve("xsl").resolve("blanks.xsl");
        System.setProperty("jeeves.xml.catalog.blankxslfile", blankXSLFile.toUri().toASCIIString());
        Log.info((String)"geonetwork.schemamanager", (Object)("jeeves.xml.catalog.blankxslfile property set to " + blankXSLFile));
        return webInf;
    }

    public static SchemaPlugin getSchemaPlugin(String schemaIdentifier) {
        SchemaPlugin schemaPlugin;
        block3: {
            String schemaBeanIdentifier = schemaIdentifier + "SchemaPlugin";
            schemaPlugin = null;
            try {
                if (ApplicationContextHolder.get() != null && (schemaPlugin = (SchemaPlugin)ApplicationContextHolder.get().getBean(schemaBeanIdentifier)) == null && schemaIdentifier.startsWith("iso19139")) {
                    schemaBeanIdentifier = "iso19139SchemaPlugin";
                    schemaPlugin = (SchemaPlugin)ApplicationContextHolder.get().getBean(schemaBeanIdentifier);
                }
            }
            catch (Exception e) {
                if (!Log.isDebugEnabled((String)"geonetwork.schemamanager")) break block3;
                Log.debug((String)"geonetwork.schemamanager", (Object)("No bean defined for the schema plugin '" + schemaIdentifier + "'. " + e.getMessage()));
            }
        }
        return schemaPlugin;
    }

    @VisibleForTesting
    public void configureFrom(SchemaManager schemaManager, Path basePath, GeonetworkDataDirectory dataDir) {
        this.basePath = basePath;
        this.resourcePath = dataDir.getResourcesDir();
        this.schemaPluginsDir = dataDir.getSchemaPluginsDir();
        this.schemaPluginsCat = this.schemaPluginsDir.resolve("schemaplugin-uri-catalog.xml");
        this.defaultLang = schemaManager.defaultLang;
        this.defaultSchema = schemaManager.defaultSchema;
        this.createOrUpdateSchemaCatalog = schemaManager.createOrUpdateSchemaCatalog;
        this.addResolverRewriteDirectives(dataDir);
        this.hmSchemas.clear();
        this.hmSchemas.putAll(schemaManager.hmSchemas);
        this.fnames = new String[schemaManager.fnames.length];
        System.arraycopy(schemaManager.fnames, 0, this.fnames, 0, this.fnames.length);
        this.numberOfCoreSchemasAdded = schemaManager.numberOfCoreSchemasAdded;
    }

    private void addResolverRewriteDirectives(GeonetworkDataDirectory dataDir) {
        NioPathAwareCatalogResolver.addRewriteDirective((ResolverRewriteDirective)new PrefixUrlRewrite("sharedFormatterDir/", dataDir.getFormatterDir().toAbsolutePath().toUri() + "/"));
    }

    public void configure(ApplicationContext applicationContext, Path basePath, Path resourcePath, Path schemaPluginsCat, Path sPDir, String defaultLang, String defaultSchema, boolean createOrUpdateSchemaCatalog) throws Exception {
        this.hmSchemas.clear();
        this.basePath = basePath;
        this.resourcePath = resourcePath;
        this.schemaPluginsDir = sPDir;
        this.schemaPluginsCat = schemaPluginsCat;
        this.defaultLang = defaultLang;
        this.defaultSchema = defaultSchema;
        this.createOrUpdateSchemaCatalog = createOrUpdateSchemaCatalog;
        Element schemaPluginCatRoot = this.getSchemaPluginCatalogTemplate();
        this.addResolverRewriteDirectives((GeonetworkDataDirectory)applicationContext.getBean(GeonetworkDataDirectory.class));
        try (DirectoryStream<Path> saSchemas = Files.newDirectoryStream(this.schemaPluginsDir);){
            for (Path schemaDir : saSchemas) {
                if (schemaDir.getFileName().toString().equals("CVS") || schemaDir.getFileName().startsWith(".") || !Files.isDirectory(schemaDir, new LinkOption[0])) continue;
                Log.info((String)"geonetwork.schemamanager", (Object)("Loading schema " + schemaDir.getFileName() + "..."));
                this.processSchema(applicationContext, schemaDir, schemaPluginCatRoot);
            }
            this.checkAppSupported(schemaPluginCatRoot);
            this.checkDependencies(schemaPluginCatRoot);
        }
        this.writeSchemaPluginCatalog(schemaPluginCatRoot);
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataSchema getSchema(String name) {
        this.beforeRead();
        try {
            MetadataSchema mds;
            Schema schema = this.hmSchemas.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Schema not registered : " + name);
            }
            MetadataSchema metadataSchema = mds = schema.getMetadataSchema();
            return metadataSchema;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDependencies(String name) {
        HashSet<String> dependencies = new HashSet<String>();
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            if (schema != null) {
                List<Element> dependsList = schema.getDependElements();
                for (Element depends : dependsList) {
                    String depSchemaName = depends.getText();
                    dependencies.add(depSchemaName);
                }
            }
            HashSet<String> hashSet = dependencies;
            return hashSet;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, String> getIdVersion(String name) {
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Schema not registered : " + name);
            }
            Pair pair = Pair.read((Object)schema.getId(), (Object)schema.getVersion());
            return pair;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPluginSchema(ApplicationContext applicationContext, String name, FileSystem zipFs) throws Exception {
        this.beforeWrite();
        try {
            this.realAddPluginSchema(applicationContext, name, zipFs);
        }
        finally {
            this.afterWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePluginSchema(ApplicationContext applicationContext, String name, FileSystem zipFs) throws Exception {
        this.beforeWrite();
        try {
            try {
                boolean doDependencies = false;
                this.realDeletePluginSchema(name, doDependencies);
            }
            catch (Exception e) {
                String errStr = "Could not update schema " + name + ", remove of outdated schema failed. Exception message if any is " + e.getMessage();
                Log.error((String)"geonetwork.schemamanager", (Object)errStr, (Throwable)e);
                throw new OperationAbortedEx(errStr, (Object)e);
            }
            this.realAddPluginSchema(applicationContext, name, zipFs);
        }
        finally {
            this.afterWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getSchemaDir(String name) {
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Schema not registered : " + name);
            }
            Path path = schema.getDir();
            return path;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attribute getSchemaLocation(String name, ServiceContext context) {
        Attribute out = null;
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Schema not registered : " + name);
            }
            String nsUri = schema.getMetadataSchema().getPrimeNS();
            String schemaLoc = schema.getSchemaLocation();
            Path schemaFile = schema.getDir().resolve("schema.xsd");
            if (schemaLoc.equals("")) {
                if (Files.exists(schemaFile, new LinkOption[0])) {
                    String schemaUrl = this.getSchemaUrl(context, name);
                    if (nsUri == null || nsUri.equals("")) {
                        out = new Attribute("noNamespaceSchemaLocation", schemaUrl, Geonet.Namespaces.XSI);
                    } else {
                        schemaLoc = nsUri + " " + schemaUrl;
                        out = new Attribute("schemaLocation", schemaLoc, Geonet.Namespaces.XSI);
                    }
                }
            } else {
                out = nsUri == null || nsUri.equals("") ? new Attribute("noNamespaceSchemaLocation", schemaLoc, Geonet.Namespaces.XSI) : new Attribute("schemaLocation", schemaLoc, Geonet.Namespaces.XSI);
            }
            Attribute attribute = out;
            return attribute;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getSchemaTemplatesDir(String name) {
        this.beforeRead();
        try {
            Path dir = this.getSchemaDir(name);
            dir = dir.resolve("templates");
            if (!Files.exists(dir, new LinkOption[0])) {
                Path path = null;
                return path;
            }
            Path path = dir;
            return path;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getSchemaSampleDataDir(String name) {
        this.beforeRead();
        try {
            Path dir = this.getSchemaDir(name);
            dir = dir.resolve("sample-data");
            if (!Files.exists(dir, new LinkOption[0])) {
                Path path = null;
                return path;
            }
            Path path = dir;
            return path;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getSchemaCSWPresentDir(String name) {
        this.beforeRead();
        try {
            Path dir = this.getSchemaDir(name);
            Path path = dir = dir.resolve("present").resolve("csw");
            return path;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, XmlFile> getSchemaInfo(String name) {
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Schema not registered : " + name);
            }
            Map<String, XmlFile> map = schema.getInfo();
            return map;
        }
        finally {
            this.afterRead();
        }
    }

    public Set<String> getSchemas() {
        this.beforeRead();
        try {
            Set<String> set = this.hmSchemas.keySet();
            return set;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> getConversionElements(String name) throws Exception {
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            List<Element> childs = schema.getConversionElements();
            ArrayList<Element> dChilds = new ArrayList<Element>();
            for (Element child : childs) {
                if (child == null) continue;
                dChilds.add((Element)child.clone());
            }
            ArrayList<Element> arrayList = dChilds;
            return arrayList;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Path> existsConverter(String name, String namespaceUri) throws Exception {
        ArrayList<Path> result = new ArrayList<Path>();
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            List<Element> converterElems = schema.getConversionElements();
            for (Element elem : converterElems) {
                String xslt;
                String nsUri = elem.getAttributeValue("nsUri");
                if (nsUri == null || !nsUri.equals(namespaceUri) || (xslt = elem.getAttributeValue("xslt")) == null) continue;
                result.add(schema.getDir().resolve(xslt));
            }
            ArrayList<Path> arrayList = result;
            return arrayList;
        }
        finally {
            this.afterRead();
        }
    }

    public boolean existsSchema(String name) {
        this.beforeRead();
        try {
            boolean bl = this.hmSchemas.containsKey(name);
            return bl;
        }
        finally {
            this.afterRead();
        }
    }

    public void deletePluginSchema(String name) throws Exception {
        this.beforeWrite();
        try {
            boolean doDependencies = true;
            this.realDeletePluginSchema(name, doDependencies);
        }
        finally {
            this.afterWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaSuggestions getSchemaSuggestions(String name) {
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Schema suggestions not registered : " + name);
            }
            SchemaSuggestions schemaSuggestions = schema.getSuggestions();
            return schemaSuggestions;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNamespaceURI(String name, String prefix) {
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Schema not registered : " + name);
            }
            MetadataSchema mds = schema.getMetadataSchema();
            String string = mds.getNS(prefix);
            return string;
        }
        finally {
            this.afterRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNamespaceString(String name) {
        this.beforeRead();
        try {
            Schema schema = this.hmSchemas.get(name);
            if (schema == null) {
                throw new IllegalArgumentException("Schema not registered : " + name);
            }
            MetadataSchema mds = schema.getMetadataSchema();
            StringBuilder sb = new StringBuilder();
            for (Namespace ns : mds.getSchemaNS()) {
                if (ns.getPrefix().length() == 0 || ns.getURI().length() == 0) continue;
                sb.append("xmlns:" + ns.getPrefix() + "=\"" + ns.getURI() + "\" ");
            }
            String string = sb.toString().trim();
            return string;
        }
        finally {
            this.afterRead();
        }
    }

    public String autodetectSchema(Element md) throws SchemaMatchConflictException, NoSchemaMatchesException {
        return this.autodetectSchema(md, this.defaultSchema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String autodetectSchema(Element md, String defaultSchema) throws SchemaMatchConflictException, NoSchemaMatchesException {
        this.beforeRead();
        try {
            String defaultSchemaOrDependencySchema;
            String schema = this.compareElementsAndAttributes(md, 3);
            if (schema != null && Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                Log.debug((String)"geonetwork.schemamanager", (Object)("  => Found schema " + schema + " using AUTODETECT(attributes) examination"));
            }
            if (schema == null && (schema = this.compareElementsAndAttributes(md, 2)) != null && Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                Log.debug((String)"geonetwork.schemamanager", (Object)("  => Found schema " + schema + " using AUTODETECT(elements with value) examination"));
            }
            if (schema == null && (schema = this.compareElementsAndAttributes(md, 0)) != null && Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                Log.debug((String)"geonetwork.schemamanager", (Object)("  => Found schema " + schema + " using AUTODETECT(elements) examination"));
            }
            if (schema == null && (schema = this.compareElementsAndAttributes(md, 1)) != null && Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                Log.debug((String)"geonetwork.schemamanager", (Object)("  => Found schema " + schema + " using AUTODETECT(elements with root) examination"));
            }
            if (schema == null && (schema = this.compareElementsAndAttributes(md, 4)) != null && Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                Log.debug((String)"geonetwork.schemamanager", (Object)("  => Found schema " + schema + " using AUTODETECT(namespaces) examination"));
            }
            if (schema == null && defaultSchema != null && (defaultSchemaOrDependencySchema = this.checkNamespace(md, defaultSchema)) != null) {
                Log.warning((String)"geonetwork.schemamanager", (Object)("  Autodetecting schema failed for " + md.getName() + " in namespace " + md.getNamespace() + ". Using default schema or one of its dependency: " + defaultSchemaOrDependencySchema));
                schema = defaultSchemaOrDependencySchema;
            }
            if (schema == null) {
                throw new NoSchemaMatchesException("Autodetecting schema failed for metadata record with root element " + md.getName() + " in namespace " + md.getNamespace() + ".");
            }
            String string = schema;
            return string;
        }
        finally {
            this.afterRead();
        }
    }

    private String checkNamespace(Element md, String schema) {
        String result = null;
        try {
            MetadataSchema mds = this.getSchema(schema);
            if (mds != null) {
                String primeNs = mds.getPrimeNS();
                if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                    Log.debug((String)"geonetwork.schemamanager", (Object)("  primeNs " + primeNs + " for schema " + schema));
                }
                if (md.getNamespace().getURI().equals(primeNs)) {
                    result = schema;
                } else {
                    Schema sch = this.hmSchemas.get(schema);
                    List<Element> dependsList = sch.getDependElements();
                    Iterator<Element> iterator = dependsList.iterator();
                    if (iterator.hasNext()) {
                        Element depends = iterator.next();
                        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                            Log.debug((String)"geonetwork.schemamanager", (Object)("  checkNamespace for dependency: " + depends.getText()));
                        }
                        return this.checkNamespace(md, depends.getText());
                    }
                }
            }
        }
        catch (Exception e) {
            Log.warning((String)"geonetwork.schemamanager", (Object)("Schema " + schema + " not registered?"));
        }
        return result;
    }

    private synchronized void beforeRead() {
        while (activeWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++activeReaders;
    }

    private synchronized void afterRead() {
        --activeReaders;
        this.notifyAll();
    }

    private synchronized void beforeWrite() {
        while (activeReaders > 0 || activeWriters > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++activeWriters;
    }

    private synchronized void afterWrite() {
        --activeWriters;
        this.notifyAll();
    }

    private void realDeletePluginSchema(String name, boolean doDependencies) throws Exception {
        Schema schema = this.hmSchemas.get(name);
        if (schema != null) {
            List<String> dependsOnMe;
            if (doDependencies && !(dependsOnMe = this.getSchemasThatDependOnMe(name)).isEmpty()) {
                String errStr = "Cannot remove schema " + name + " because the following schemas list it as a dependency: " + dependsOnMe;
                Log.error((String)"geonetwork.schemamanager", (Object)errStr);
                throw new OperationAbortedEx(errStr);
            }
            this.removeSchemaInfo(name);
        }
    }

    private void realAddPluginSchema(ApplicationContext applicationContext, String name, FileSystem zipFs) throws Exception {
        Element schemaPluginCatRoot = this.getSchemaPluginCatalog();
        Path schemaDir = this.buildSchemaFolderPath(name);
        Files.createDirectories(schemaDir, new FileAttribute[0]);
        try {
            ZipUtil.extract((FileSystem)zipFs, (Path)schemaDir);
            this.processSchema(applicationContext, schemaDir, schemaPluginCatRoot);
            Schema schema = this.hmSchemas.get(name);
            this.checkDepends(name, schema.getDependElements());
            this.writeSchemaPluginCatalog(schemaPluginCatRoot);
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.schemamanager", (Object)e.getMessage(), (Throwable)e);
            this.hmSchemas.remove(name);
            IO.deleteFileOrDirectory((Path)schemaDir);
            throw new OperationAbortedEx("Failed to add schema " + name + " : " + e.getMessage(), (Object)e);
        }
    }

    private void addSchema(ApplicationContext applicationContext, Path schemaDir, Element schemaPluginCatRoot, Path xmlSchemaFile, Path xmlSuggestFile, Path xmlSubstitutionsFile, Path xmlIdFile, Path oasisCatFile, Path conversionsFile) throws Exception {
        int baseNrInt;
        Path path = schemaDir;
        if (Files.exists(oasisCatFile, new LinkOption[0])) {
            String catalogProp = System.getProperty("jeeves.xml.catalog.files");
            if (catalogProp == null) {
                catalogProp = "";
            }
            catalogProp = catalogProp.equals("") ? oasisCatFile.toString() : catalogProp + ";" + oasisCatFile;
            System.setProperty("jeeves.xml.catalog.files", catalogProp);
            Xml.resetResolver();
        }
        SchematronRepository schemaRepo = (SchematronRepository)applicationContext.getBean(SchematronRepository.class);
        SchematronCriteriaGroupRepository criteriaGroupRepository = (SchematronCriteriaGroupRepository)applicationContext.getBean(SchematronCriteriaGroupRepository.class);
        MetadataSchema mds = new SchemaLoader().load(xmlSchemaFile, xmlSubstitutionsFile, schemaRepo, criteriaGroupRepository);
        mds.setName(path.getFileName().toString());
        mds.setSchemaDir(path);
        mds.loadSchematronRules(this.basePath);
        if (mds.getSchemaPlugin() != null && mds.getSchemaPlugin().getCswTypeNames() != null) {
            this.hmSchemasTypenames.putAll(mds.getSchemaPlugin().getCswTypeNames());
        }
        String schemaName = schemaDir.getFileName().toString();
        Path locBase = schemaDir.resolve("loc");
        HashMap<String, XmlFile> xfMap = new HashMap<String, XmlFile>();
        for (String fname : this.fnames) {
            Path filePath = path.resolve("loc").resolve(this.defaultLang).resolve(fname);
            if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                Log.debug((String)"geonetwork.schemamanager", (Object)("Searching for " + filePath));
            }
            if (Files.exists(filePath, new LinkOption[0])) {
                Element config = new Element("xml");
                config.setAttribute("name", schemaName);
                config.setAttribute("base", locBase.toUri().toString());
                config.setAttribute("file", fname);
                if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                    Log.debug((String)"geonetwork.schemamanager", (Object)("Adding XmlFile " + Xml.getString((Element)config)));
                }
                XmlFile xf = new XmlFile(config, this.defaultLang, true);
                xfMap.put(fname, xf);
                continue;
            }
            Log.warning((String)"geonetwork.schemamanager", (Object)("Unable to load loc file: " + filePath));
        }
        Pair<String, String> idInfo = this.extractIdInfo(xmlIdFile, schemaName);
        this.extractMetadata(mds, xmlIdFile);
        mds.setReadwriteUUID(this.extractReadWriteUuid(xmlIdFile));
        mds.setOperationFilters(this.extractOperationFilters(xmlIdFile));
        Log.debug((String)"geonetwork.schemamanager", (Object)("  UUID is read/write mode: " + mds.isReadwriteUUID()));
        this.putSchemaInfo(schemaName, (String)idInfo.one(), (String)idInfo.two(), mds, path, new SchemaSuggestions(xmlSuggestFile), this.extractADElements(xmlIdFile), xfMap, true, this.extractSchemaLocation(xmlIdFile), this.extractConvElements(conversionsFile), this.extractDepends(xmlIdFile));
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.debug((String)"geonetwork.schemamanager", (Object)("Property jeeves.xml.catalog.files is " + System.getProperty("jeeves.xml.catalog.files")));
        }
        if ((baseNrInt = this.getHighestSchemaPluginCatalogId(schemaName, schemaPluginCatRoot)) == 0) {
            baseNrInt = this.numberOfCoreSchemasAdded;
        }
        if (baseNrInt != -1) {
            this.createUriEntryInSchemaPluginCatalog(schemaName, baseNrInt, schemaPluginCatRoot);
        }
        this.copySchemaXSDsToWebApp(schemaName, path);
    }

    public void reloadSchema(String schemaIdentifier) {
        MetadataSchema metadataSchema = this.getSchema(schemaIdentifier);
        metadataSchema.loadSchematronRules(this.basePath);
    }

    private Element getSchemaPluginCatalog() throws Exception {
        return Xml.loadFile((Path)this.schemaPluginsCat);
    }

    private Element getSchemaPluginCatalogTemplate() throws Exception {
        return Xml.loadFile((Path)this.basePath.resolve("WEB-INF").resolve("schemaplugin-uri-catalog.xml"));
    }

    private Path buildSchemaFolderPath(String name) {
        return this.schemaPluginsDir.resolve(name);
    }

    private Element deleteSchemaFromPluginCatalog(String name, Element root) throws Exception {
        List contents = root.getContent();
        Path ourUri = this.buildSchemaFolderPath(name);
        int index = -1;
        for (Content content : contents) {
            if (!(content instanceof Element)) continue;
            Element uri = (Element)content;
            if (!uri.getName().equals("uri") || !uri.getNamespace().equals((Object)Geonet.Namespaces.OASIS_CATALOG)) {
                if (!Log.isDebugEnabled((String)"geonetwork.schemamanager")) continue;
                Log.debug((String)"geonetwork.schemamanager", (Object)("Skipping element " + uri.getQualifiedName() + ":" + uri.getNamespace()));
                continue;
            }
            if (!uri.getAttributeValue("uri").equals(ourUri.toString())) continue;
            index = root.indexOf((Content)uri);
        }
        if (index != -1) {
            root.removeContent(index);
        }
        return root;
    }

    private int getHighestSchemaPluginCatalogId(String name, Element root) throws Exception {
        List contents = root.getContent();
        String baseBlank = "blanks/metadata-schema00";
        Path ourUri = this.buildSchemaFolderPath(name);
        for (Content content : contents) {
            Element uri = null;
            if (!(content instanceof Element)) continue;
            uri = (Element)content;
            if (!uri.getName().equals("rewriteURI") || !uri.getNamespace().equals((Object)Geonet.Namespaces.OASIS_CATALOG)) {
                if (!Log.isDebugEnabled((String)"geonetwork.schemamanager")) continue;
                Log.debug((String)"geonetwork.schemamanager", (Object)("Skipping element " + uri.getQualifiedName() + ":" + uri.getNamespace()));
                continue;
            }
            if (uri.getAttributeValue("rewritePrefix").equals(ourUri.toString())) {
                return -1;
            }
            String nameAttr = uri.getAttributeValue("uriStartString");
            if (!nameAttr.startsWith("blanks/metadata-schema") || nameAttr.compareTo(baseBlank) <= 0) continue;
            baseBlank = nameAttr;
        }
        String baseNr = baseBlank.replace("blanks/metadata-schema", "");
        int baseNrInt = 0;
        try {
            baseNrInt = Integer.parseInt(baseNr);
        }
        catch (NumberFormatException nfe) {
            Log.error((String)"geonetwork.schemamanager", (Object)("Cannot decode blank number from " + baseBlank), (Throwable)nfe);
            throw new IllegalArgumentException("Cannot decode blank number from " + baseBlank);
        }
        return baseNrInt;
    }

    private void createUriEntryInSchemaPluginCatalog(String name, int baseNrInt, Element root) throws Exception {
        Element newBlank = new Element("rewriteURI", Geonet.Namespaces.OASIS_CATALOG);
        if (++baseNrInt <= 20) {
            String zero = "";
            if (baseNrInt < 10) {
                zero = "0";
            }
            newBlank.setAttribute("uriStartString", "blanks/metadata-schema" + zero + baseNrInt);
            Path schemaFolderPath = this.buildSchemaFolderPath(name);
            try {
                newBlank.setAttribute("rewritePrefix", schemaFolderPath.toFile().toString());
            }
            catch (UnsupportedOperationException e) {
                newBlank.setAttribute("rewritePrefix", schemaFolderPath.toUri().toString());
            }
        } else {
            throw new IllegalArgumentException("Exceeded maximum number of plugin schemas 20");
        }
        root.addContent((Content)newBlank);
    }

    private void writeSchemaPluginCatalog(Element root) throws Exception {
        if (this.createOrUpdateSchemaCatalog) {
            NioPathAwareCatalogResolver.addRewriteDirective((ResolverRewriteDirective)new SchemaPluginUrlRewrite(root));
            try (OutputStream out = Files.newOutputStream(this.schemaPluginsCat, new OpenOption[0]);){
                Xml.writeResponse((Document)new Document((Element)root.detach()), (OutputStream)out);
                Xml.resetResolver();
                Xml.clearTransformerFactoryStylesheetCache();
            }
        }
    }

    private void putSchemaInfo(String name, String id, String version, MetadataSchema mds, Path schemaDir, SchemaSuggestions sugg, List<Element> adElems, Map<String, XmlFile> xfMap, boolean isPlugin, String schemaLocation, List<Element> convElems, List<Element> dependElems) {
        Schema schema = new Schema();
        schema.setId(id);
        schema.setVersion(version);
        schema.setMetadataSchema(mds);
        schema.setDir(schemaDir);
        schema.setSuggestions(sugg);
        schema.setAutodetectElements(adElems);
        schema.setInfo(xfMap);
        schema.setPluginSchema(isPlugin);
        schema.setSchemaLocation(schemaLocation);
        schema.setConversionElements(convElems);
        schema.setDependElements(dependElems);
        this.hmSchemas.put(name, schema);
    }

    private void removeSchemaInfo(String name) throws Exception {
        Schema schema = this.hmSchemas.get(name);
        this.removeSchemaDir(schema.getDir(), name);
        this.hmSchemas.remove(name);
        Element schemaPluginCatRoot = this.getSchemaPluginCatalog();
        schemaPluginCatRoot = this.deleteSchemaFromPluginCatalog(name, schemaPluginCatRoot);
        this.writeSchemaPluginCatalog(schemaPluginCatRoot);
    }

    private void removeSchemaDir(Path schemaDir, String name) {
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.debug((String)"geonetwork.schemamanager", (Object)("Removing schema directory " + schemaDir));
        }
        this.deleteDir(schemaDir);
        Path pubSchemaDir = this.resourcePath.resolve("xml/schemas/").resolve(name);
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.debug((String)"geonetwork.schemamanager", (Object)("Removing published schemas directory " + pubSchemaDir));
        }
        this.deleteDir(pubSchemaDir);
    }

    private void processSchema(ApplicationContext applicationContext, Path schemasDir, Element schemaPluginCatRoot) throws OperationAbortedEx {
        Path schemaFile = schemasDir.resolve("schema.xsd");
        Path suggestFile = schemasDir.resolve("schema-suggestions.xml");
        Path substitutesFile = schemasDir.resolve("schema-substitutes.xml");
        Path idFile = schemasDir.resolve("schema-ident.xml");
        Path oasisCatFile = schemasDir.resolve("oasis-catalog.xml");
        Path conversionsFile = schemasDir.resolve("schema-conversions.xml");
        if (!Files.exists(idFile, new LinkOption[0])) {
            Log.error((String)"geonetwork.schemamanager", (Object)("    Skipping : " + schemasDir.getFileName() + " as it doesn't have " + "schema-ident.xml"));
            return;
        }
        Log.info((String)"geonetwork.schemamanager", (Object)("    Adding xml schema : " + schemasDir.getFileName()));
        String stage = "";
        try {
            stage = "reading schema-ident file " + idFile;
            Element root = Xml.loadFile((Path)idFile);
            stage = "validating schema-ident file " + idFile;
            Xml.validate((Element)root);
            String schemaName = schemasDir.getFileName().toString();
            if (this.hmSchemas.containsKey(schemaName)) {
                Log.error((String)"geonetwork.schemamanager", (Object)("Schema " + schemaName + " already exists - cannot add!"));
            } else {
                stage = "adding the schema information";
                this.addSchema(applicationContext, schemasDir, schemaPluginCatRoot, schemaFile, suggestFile, substitutesFile, idFile, oasisCatFile, conversionsFile);
                ResolverWrapper.createResolverForSchema((String)schemasDir.getFileName().toString(), (Path)oasisCatFile);
            }
        }
        catch (Exception e) {
            String errStr = "Failed whilst " + stage + ". Exception message if any is " + e.getMessage();
            Log.error((String)"geonetwork.schemamanager", (Object)errStr, (Throwable)e);
            throw new OperationAbortedEx(errStr, (Object)e);
        }
    }

    private void checkDependencies(Element schemaPluginCatRoot) throws Exception {
        ArrayList<String> removes = new ArrayList<String>();
        for (String schemaName : this.hmSchemas.keySet()) {
            Schema schema = this.hmSchemas.get(schemaName);
            try {
                this.checkDepends(schemaName, schema.getDependElements());
            }
            catch (Exception e) {
                Log.error((String)"geonetwork.schemamanager", (Object)("check dependencies failed: " + e.getMessage()));
                removes.add(schemaName);
            }
        }
        for (String removeSchema : removes) {
            this.hmSchemas.remove(removeSchema);
            this.deleteSchemaFromPluginCatalog(removeSchema, schemaPluginCatRoot);
        }
    }

    private void checkAppSupported(Element schemaPluginCatRoot) throws Exception {
        ArrayList<String> removes = new ArrayList<String>();
        SystemInfo systemInfo = (SystemInfo)ApplicationContextHolder.get().getBean(SystemInfo.class);
        String version = systemInfo.getVersion();
        Version appVersion = Version.parseVersionNumber((String)version);
        for (String schemaName : this.hmSchemas.keySet()) {
            Version schemaMajorAppVersion;
            Schema schema = this.hmSchemas.get(schemaName);
            String minorAppVersionSupported = schema.getMetadataSchema().getAppMinorVersionSupported();
            Version schemaMinorAppVersion = Version.parseVersionNumber((String)minorAppVersionSupported);
            if (appVersion.compareTo(schemaMinorAppVersion) < 0) {
                Log.error((String)"geonetwork.schemamanager", (Object)("Schema " + schemaName + " requires min Geonetwork version: " + minorAppVersionSupported + ", current is: " + version + ". Skip load schema."));
                removes.add(schemaName);
                continue;
            }
            String majorAppVersionSupported = schema.getMetadataSchema().getAppMajorVersionSupported();
            if (!StringUtils.isNotEmpty((String)majorAppVersionSupported) || appVersion.compareTo(schemaMajorAppVersion = Version.parseVersionNumber((String)majorAppVersionSupported)) <= 0) continue;
            Log.error((String)"geonetwork.schemamanager", (Object)("Schema " + schemaName + " requires max Geonetwork version: " + majorAppVersionSupported + ", current is: " + version + ". Skip load schema."));
            removes.add(schemaName);
        }
        for (String removeSchema : removes) {
            this.hmSchemas.remove(removeSchema);
            this.deleteSchemaFromPluginCatalog(removeSchema, schemaPluginCatRoot);
        }
    }

    public List<String> getSchemasThatDependOnMe(String schemaName) {
        ArrayList<String> myDepends = new ArrayList<String>();
        for (String schemaNameToTest : this.hmSchemas.keySet()) {
            if (schemaNameToTest.equals(schemaName)) continue;
            Schema schema = this.hmSchemas.get(schemaNameToTest);
            List<Element> dependsList = schema.getDependElements();
            for (Element depends : dependsList) {
                if (!depends.getText().equals(schemaName)) continue;
                myDepends.add(schemaNameToTest);
            }
        }
        return myDepends;
    }

    private void checkDepends(String thisSchema, List<Element> dependsList) throws Exception {
        for (Element depends : dependsList) {
            String schema = depends.getText();
            if (schema.length() <= 0 || this.hmSchemas.containsKey(schema)) continue;
            throw new IllegalArgumentException("Schema " + thisSchema + " depends on " + schema + ", but that schema is not loaded");
        }
    }

    private List<Element> extractDepends(Path xmlIdFile) throws Exception {
        Element root = Xml.loadFile((Path)xmlIdFile);
        List dependsList = root.getChildren("depends", GEONET_SCHEMA_NS);
        if (dependsList.isEmpty()) {
            dependsList = root.getChildren("depends", GEONET_SCHEMA_PREFIX_NS);
        }
        return dependsList;
    }

    private boolean extractReadWriteUuid(Path xmlIdFile) throws Exception {
        Element root = Xml.loadFile((Path)xmlIdFile);
        String id = root.getChildText("readwriteUuid", GEONET_SCHEMA_NS);
        if (id == null) {
            return false;
        }
        return "true".equals(id);
    }

    private void extractMetadata(MetadataSchema mds, Path xmlIdFile) throws JDOMException, NoSuchFileException {
        Element root = Xml.loadFile((Path)xmlIdFile);
        mds.setStandardUrl(root.getChildText("standardUrl", GEONET_SCHEMA_NS));
        mds.setTitles(this.getSchemaIdentMultilingualProperty(root, "title"));
        mds.setDescriptions(this.getSchemaIdentMultilingualProperty(root, "description"));
        mds.setVersion(root.getChildText("version", GEONET_SCHEMA_NS));
        mds.setAppMinorVersionSupported(root.getChildText("appMinorVersionSupported", GEONET_SCHEMA_NS));
        mds.setAppMajorVersionSupported(root.getChildText("appMajorVersionSupported", GEONET_SCHEMA_NS));
        mds.setDependsOn(root.getChildText("depends", GEONET_SCHEMA_NS));
    }

    private Map<String, String> getSchemaIdentMultilingualProperty(Element root, String propName) {
        HashMap<String, String> props = new HashMap<String, String>();
        root.getChildren(propName, GEONET_SCHEMA_NS).forEach(o -> {
            Element e;
            String lang;
            if (o instanceof Element && (lang = (e = (Element)o).getAttributeValue("lang", Geonet.Namespaces.XML)) != null) {
                props.put(lang, e.getTextNormalize());
            }
        });
        return props;
    }

    private Map<String, MetadataSchemaOperationFilter> extractOperationFilters(Path xmlIdFile) throws Exception {
        Element root = Xml.loadFile((Path)xmlIdFile);
        Element filters = root.getChild("filters", GEONET_SCHEMA_NS);
        HashMap<String, MetadataSchemaOperationFilter> filterRules = new HashMap<String, MetadataSchemaOperationFilter>();
        if (filters == null) {
            return filterRules;
        }
        for (Object rule : filters.getChildren("filter", GEONET_SCHEMA_NS)) {
            if (!(rule instanceof Element)) continue;
            Element ruleElement = (Element)rule;
            String xpath = ruleElement.getAttributeValue("xpath");
            String ifNotOperation = ruleElement.getAttributeValue("ifNotOperation");
            Element markedElement = ruleElement.getChild("keepMarkedElement", GEONET_SCHEMA_NS);
            if (!StringUtils.isNotBlank((String)ifNotOperation) || !StringUtils.isNotBlank((String)xpath)) continue;
            MetadataSchemaOperationFilter filter = new MetadataSchemaOperationFilter(xpath, ifNotOperation, markedElement);
            filterRules.put(ifNotOperation, filter);
        }
        return filterRules;
    }

    private Pair<String, String> extractIdInfo(Path xmlIdFile, String name) throws Exception {
        Element idName;
        Element version;
        Element root = Xml.loadFile((Path)xmlIdFile);
        Element id = root.getChild("id", GEONET_SCHEMA_NS);
        if (id == null) {
            id = root.getChild("id", GEONET_SCHEMA_PREFIX_NS);
        }
        if ((version = root.getChild("version", GEONET_SCHEMA_NS)) == null) {
            version = root.getChild("version", GEONET_SCHEMA_PREFIX_NS);
        }
        if ((idName = root.getChild("name", GEONET_SCHEMA_NS)) == null) {
            idName = root.getChild("name", GEONET_SCHEMA_PREFIX_NS);
        }
        if (!idName.getText().equals(name)) {
            throw new IllegalArgumentException("Schema name supplied " + name + " does not match the name of the schema in the schema-id.xml file " + idName.getText());
        }
        return Pair.read((Object)id.getText(), (Object)version.getText());
    }

    private List<Element> extractADElements(Path xmlIdFile) throws Exception {
        Element root = Xml.loadFile((Path)xmlIdFile);
        Element autodetect = root.getChild("autodetect", GEONET_SCHEMA_NS);
        if (autodetect == null) {
            autodetect = root.getChild("autodetect", GEONET_SCHEMA_PREFIX_NS);
        }
        List children = autodetect.getChildren();
        return children;
    }

    private List<Element> extractConvElements(Path xmlConvFile) throws Exception {
        if (!Files.exists(xmlConvFile, new LinkOption[0])) {
            if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                Log.debug((String)"geonetwork.schemamanager", (Object)"Schema conversions file not present");
            }
            return new ArrayList<Element>();
        }
        Element root = Xml.loadFile((Path)xmlConvFile);
        ConfigurationOverrides.DEFAULT.updateWithOverrides(xmlConvFile.toString(), null, this.basePath, root);
        if (!root.getName().equals("conversions")) {
            throw new IllegalArgumentException("Schema conversions file " + xmlConvFile + " is invalid, no <conversions> root element");
        }
        List result = root.getChildren();
        return result;
    }

    private String extractSchemaLocation(Path xmlIdFile) throws Exception {
        Element root = Xml.loadFile((Path)xmlIdFile);
        Element schemaLocElem = root.getChild("schemaLocation", GEONET_SCHEMA_NS);
        if (schemaLocElem == null) {
            schemaLocElem = root.getChild("schemaLocation", GEONET_SCHEMA_PREFIX_NS);
        }
        return schemaLocElem.getTextNormalize();
    }

    /*
     * Unable to fully structure code
     */
    private String compareElementsAndAttributes(Element md, int mode) throws SchemaMatchConflictException {
        returnVal = null;
        allSchemas = this.getSchemas();
        matches = new ArrayList<String>();
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.debug((String)"geonetwork.schemamanager", (Object)("Schema autodetection starting on " + md.getName() + " (Namespace: " + md.getNamespace() + ") using mode: " + mode + "..."));
        }
        for (String schemaName : allSchemas) {
            if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                Log.debug((String)"geonetwork.schemamanager", (Object)("\tDoing schema " + schemaName));
            }
            schema = this.hmSchemas.get(schemaName);
            adElems = schema.getAutodetectElements();
            for (Element elem : adElems) {
                block22: {
                    block24: {
                        block23: {
                            if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                                Log.debug((String)"geonetwork.schemamanager", (Object)("\t\tChecking autodetect element " + Xml.getString((Element)elem) + " with name " + elem.getName()));
                            }
                            elemKids = elem.getChildren();
                            match = false;
                            type = elem.getAttribute("type");
                            if (mode != 3 || !elem.getName().equals("attributes")) break block23;
                            atts = elem.getAttributes();
                            for (Attribute searchAtt : atts) {
                                if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                                    Log.debug((String)"geonetwork.schemamanager", (Object)("\t\t\t\tFinding attribute " + searchAtt.toString()));
                                }
                                if (this.isMatchingAttributeInMetadata(searchAtt, md)) {
                                    match = true;
                                    continue;
                                }
                                match = false;
                                break block22;
                            }
                            break block22;
                        }
                        if (mode != 4 || !elem.getName().equals("namespaces")) break block24;
                        nss = elem.getAdditionalNamespaces();
                        for (Namespace ns : nss) {
                            if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                                Log.debug((String)"geonetwork.schemamanager", (Object)("\t\t\t\tFinding namespace " + ns.toString()));
                            }
                            if (this.isMatchingNamespaceInMetadata(ns, md)) {
                                match = true;
                                continue;
                            }
                            match = false;
                            break block22;
                        }
                        break block22;
                    }
                    for (Element kid : elemKids) {
                        if (mode != 1 || type == null || !"root".equals(type.getValue())) ** GOTO lbl50
                        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                            Log.debug((String)"geonetwork.schemamanager", (Object)("\t\t\t\tComparing " + Xml.getString((Element)kid) + " with " + md.getName() + " with namespace " + md.getNamespace() + " : " + (kid.getName().equals(md.getName()) != false && kid.getNamespace().equals((Object)md.getNamespace()) != false)));
                        }
                        if (kid.getName().equals(md.getName()) && kid.getNamespace().equals((Object)md.getNamespace())) {
                            match = true;
                        } else {
                            match = false;
                            continue;
lbl50:
                            // 1 sources

                            if (mode == 0 && type != null && "search".equals(type.getValue())) {
                                if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                                    Log.debug((String)"geonetwork.schemamanager", (Object)("\t\t\t\tComparing " + Xml.getString((Element)kid) + " with " + md.getName() + " with namespace " + md.getNamespace() + " : " + (kid.getName().equals(md.getName()) != false && kid.getNamespace().equals((Object)md.getNamespace()) != false)));
                                }
                                if (this.isMatchingElementInMetadata(kid, md, false)) {
                                    match = true;
                                    continue;
                                }
                                match = false;
                            } else {
                                if (mode != 2) continue;
                                if (this.isMatchingElementInMetadata(kid, md, true)) {
                                    match = true;
                                    continue;
                                }
                                match = false;
                            }
                        }
                        break;
                    }
                }
                if (!match || matches.contains(schemaName)) continue;
                matches.add(schemaName);
            }
        }
        if (matches.size() > 1) {
            throw new SchemaMatchConflictException("Metadata record with " + md.getName() + " (Namespace " + md.getNamespace() + " matches more than one schema - namely: " + matches.toString() + " - during schema autodetection mode " + mode);
        }
        if (matches.size() == 1) {
            returnVal = (String)matches.get(0);
        }
        return returnVal;
    }

    private boolean isMatchingAttributeInMetadata(Attribute needle, Element haystack) {
        boolean returnVal = false;
        Iterator haystackIterator = haystack.getDescendants((Filter)new ElementFilter());
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.debug((String)"geonetwork.schemamanager", (Object)("Matching " + needle.toString()));
        }
        while (haystackIterator.hasNext()) {
            Element tempElement = (Element)haystackIterator.next();
            Attribute tempAtt = tempElement.getAttribute(needle.getName());
            if (!tempAtt.equals((Object)needle)) continue;
            returnVal = true;
            break;
        }
        return returnVal;
    }

    private boolean isMatchingNamespaceInMetadata(Namespace needle, Element haystack) {
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.debug((String)"geonetwork.schemamanager", (Object)("Matching " + needle.toString()));
        }
        if (this.checkNamespacesOnElement(needle, haystack)) {
            return true;
        }
        Iterator haystackIterator = haystack.getDescendants((Filter)new ElementFilter());
        while (haystackIterator.hasNext()) {
            Element tempElement = (Element)haystackIterator.next();
            if (!this.checkNamespacesOnElement(needle, tempElement)) continue;
            return true;
        }
        return false;
    }

    private boolean checkNamespacesOnElement(Namespace ns, Element elem) {
        if (elem.getNamespace().equals((Object)ns)) {
            return true;
        }
        List nss = elem.getAdditionalNamespaces();
        for (Namespace ans : nss) {
            if (!ans.equals((Object)ns)) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchingElementInMetadata(Element needle, Element haystack, boolean checkValue) {
        boolean returnVal = false;
        Iterator haystackIterator = haystack.getDescendants((Filter)new ElementFilter());
        String needleName = needle.getName();
        Namespace needleNS = needle.getNamespace();
        if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
            Log.debug((String)"geonetwork.schemamanager", (Object)("Matching " + Xml.getString((Element)needle)));
        }
        while (haystackIterator.hasNext()) {
            Element tempElement = (Element)haystackIterator.next();
            if (!tempElement.getName().equals(needleName) || !tempElement.getNamespace().equals((Object)needleNS)) continue;
            if (checkValue) {
                if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                    Log.debug((String)"geonetwork.schemamanager", (Object)("  Searching value for element: " + tempElement.getName()));
                }
                String needleVal = StringUtils.deleteWhitespace((String)needle.getValue());
                String tempVal = StringUtils.deleteWhitespace((String)tempElement.getValue());
                returnVal = Pattern.matches(needleVal, tempVal);
                if (Log.isDebugEnabled((String)"geonetwork.schemamanager")) {
                    Log.debug((String)"geonetwork.schemamanager", (Object)("    Pattern " + needleVal + " applied to value " + tempVal + " match: " + returnVal));
                }
                if (!returnVal) continue;
                break;
            }
            returnVal = true;
            break;
        }
        return returnVal;
    }

    private void deleteDir(Path dir) {
        try {
            IO.deleteFileOrDirectory((Path)dir);
        }
        catch (IOException e) {
            Log.warning((String)"geonetwork.schemamanager", (Object)("Unable to delete directory: " + dir));
        }
    }

    private String getSchemaUrl(ServiceContext context, String schemaName) {
        SettingInfo si = context.getBean(SettingInfo.class);
        String relativePath = "xml/schemas/" + schemaName + "/schema.xsd";
        return si.getSiteUrl() + context.getBaseUrl() + "/" + relativePath;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    private void copySchemaXSDsToWebApp(String name, Path schemaPluginDir) throws Exception {
        Path schemasDir = this.resourcePath.resolve("xml/schemas/");
        Files.createDirectories(schemasDir, new FileAttribute[0]);
        Path webAppDirSchemaXSD = schemasDir.resolve(name);
        IO.deleteFileOrDirectory((Path)webAppDirSchemaXSD, (boolean)true);
        if (!Files.exists(webAppDirSchemaXSD, new LinkOption[0])) {
            Files.createDirectories(webAppDirSchemaXSD, new FileAttribute[0]);
        }
        DirectoryStream.Filter<Path> xsdFilter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return entry.getFileName().toString().toLowerCase().endsWith(".xsd");
            }
        };
        try (DirectoryStream<Path> schemaplugins = Files.newDirectoryStream(schemaPluginDir, (DirectoryStream.Filter<? super Path>)xsdFilter);){
            boolean missingXsdFiles = true;
            for (Path schemaplugin : schemaplugins) {
                IO.copyDirectoryOrFile((Path)schemaplugin, (Path)webAppDirSchemaXSD.resolve(schemaplugin), (boolean)false);
                missingXsdFiles = false;
            }
            if (missingXsdFiles) {
                Log.error((String)"geonetwork.schemamanager", (Object)("Schema " + name + " does not have any XSD files!"));
            }
        }
        Path fileSchemaDir = schemaPluginDir.resolve("schema");
        if (Files.exists(fileSchemaDir, new LinkOption[0])) {
            IO.copyDirectoryOrFile((Path)fileSchemaDir, (Path)webAppDirSchemaXSD.resolve("schema"), (boolean)false);
        }
    }

    public Map<String, Namespace> getHmSchemasTypenames() {
        return this.hmSchemasTypenames;
    }

    public List<String> getListOfOutputSchemaURI() {
        Iterator<String> iterator = this.hmSchemasTypenames.keySet().iterator();
        ArrayList<String> listOfSchemaURI = new ArrayList<String>();
        while (iterator.hasNext()) {
            String typeLocalName = iterator.next();
            Namespace ns = this.hmSchemasTypenames.get(typeLocalName);
            listOfSchemaURI.add(ns.getURI());
        }
        return listOfSchemaURI;
    }

    public List<String> getListOfTypeNames() {
        Iterator<String> iterator = this.hmSchemasTypenames.keySet().iterator();
        ArrayList<String> listOfTypenames = new ArrayList<String>();
        while (iterator.hasNext()) {
            String typeName = iterator.next();
            listOfTypenames.add(typeName);
        }
        return listOfTypenames;
    }
}

