/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server.context;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.persistence.EntityManager;
import jeeves.component.ProfileManager;
import jeeves.server.UserSession;
import jeeves.server.context.BasicContext;
import jeeves.server.context.ServiceExecutionFailedException;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.server.local.LocalServiceRequest;
import jeeves.server.sources.ServiceRequest;
import jeeves.server.sources.http.JeevesServlet;
import jeeves.transaction.TransactionManager;
import jeeves.transaction.TransactionTask;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Logger;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.utils.Log;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.transaction.TransactionStatus;

public class ServiceContext
extends BasicContext
implements AutoCloseable {
    private static final ThreadLocalPolicy POLICY;
    private static final InheritableThreadLocal<ServiceContext> THREAD_LOCAL_INSTANCE;
    protected Throwable allocation = null;
    protected Throwable deAllocation = null;
    protected UserSession _userSession = new UserSession();
    protected ServiceRequest.InputMethod _input;
    protected ServiceRequest.OutputMethod _output;
    protected Map<String, String> _headers;
    protected String _language;
    protected String _service;
    protected String _ipAddress;
    protected int _maxUploadSize;
    protected JeevesServlet _servlet;
    protected boolean _startupError = false;
    protected Map<String, String> _startupErrors;
    protected Map<String, String> _responseHeaders;
    protected Integer _statusCode;

    public ServiceContext(String service, ConfigurableApplicationContext jeevesApplicationContext, Map<String, Object> contexts, EntityManager entityManager) {
        super(jeevesApplicationContext, contexts, entityManager);
        this.setService(service);
        this.setResponseHeaders(new HashMap<String, String>());
    }

    @CheckForNull
    public static ServiceContext get() {
        ServiceContext context = (ServiceContext)THREAD_LOCAL_INSTANCE.get();
        if (context != null && context.isCleared()) {
            context.checkCleared("Thread local access");
        }
        return context;
    }

    @Override
    public void close() {
        try {
            ServiceContext check = (ServiceContext)THREAD_LOCAL_INSTANCE.get();
            if (this == check) {
                this.clearAsThreadLocal();
            }
        }
        finally {
            if (!this.isCleared()) {
                this.clear();
                this.deAllocation = new Throwable("ServiceContext " + this._service + " closed");
            }
        }
    }

    public void setAsThreadLocal() {
        ServiceContext check = (ServiceContext)THREAD_LOCAL_INSTANCE.get();
        if (POLICY == ThreadLocalPolicy.DIRECT || check == null) {
            THREAD_LOCAL_INSTANCE.set(this);
            ApplicationContextHolder.set((ConfigurableApplicationContext)this.getApplicationContext());
            this.allocation = new Throwable("ServiceContext " + this._service + " allocated to thread");
            return;
        }
        if (this == check) {
            String unexpected = "Service " + this._service + " Context: already in use for this thread";
            if (this.allocation != null) {
                unexpected = unexpected + "\n\tContext '" + check._service + "' conflict: " + check.allocation.getStackTrace()[1];
                this.checkUnexpectedState(unexpected);
            }
            if (ApplicationContextHolder.get() != null) {
                if (ApplicationContextHolder.get() != this.getApplicationContext()) {
                    ApplicationContextHolder.clear();
                    ApplicationContextHolder.set((ConfigurableApplicationContext)this.getApplicationContext());
                }
            } else {
                ApplicationContextHolder.set((ConfigurableApplicationContext)this.getApplicationContext());
            }
            this.allocation = new Throwable("ServiceContext " + this._service + " allocated to thread");
            unexpected = unexpected + "\n\tService '" + this._service + "' allocate: " + this.allocation.getStackTrace()[1];
            this.checkUnexpectedState(unexpected);
            return;
        }
        THREAD_LOCAL_INSTANCE.remove();
        String unexpected = "Service " + this._service + " Context: Clearing prior service context " + check._service;
        if (check.allocation != null) {
            unexpected = unexpected + "\n\tContext '" + check._service + "' conflict: " + check.allocation.getStackTrace()[1];
        }
        THREAD_LOCAL_INSTANCE.set(this);
        if (ApplicationContextHolder.get() != null) {
            if (ApplicationContextHolder.get() != this.getApplicationContext()) {
                ApplicationContextHolder.clear();
                ApplicationContextHolder.set((ConfigurableApplicationContext)this.getApplicationContext());
            }
        } else {
            ApplicationContextHolder.set((ConfigurableApplicationContext)this.getApplicationContext());
        }
        this.allocation = new Throwable("ServiceContext " + this._service + " allocated to thread");
        unexpected = unexpected + "\n\tService '" + this._service + "' allocate: " + this.allocation.getStackTrace()[1];
        this.checkUnexpectedState(unexpected);
    }

    protected void checkCleared(String message) {
        if (this.isCleared()) {
            String unavailable = message + " - service context no longer available\nCleared by " + this.deAllocation.getStackTrace()[1];
            throw new NullPointerException(unavailable);
        }
    }

    protected void checkUnexpectedState(String unexpected) {
        if (unexpected == null) {
            return;
        }
        switch (POLICY) {
            case DIRECT: {
                break;
            }
            case TRACE: {
                this.debug(unexpected);
                break;
            }
            case STRICT: {
                throw new IllegalStateException(unexpected);
            }
        }
    }

    public void clearAsThreadLocal() {
        ServiceContext check = (ServiceContext)THREAD_LOCAL_INSTANCE.get();
        if (POLICY == ThreadLocalPolicy.DIRECT) {
            if (check != null) {
                check.allocation = null;
                check = null;
            }
            THREAD_LOCAL_INSTANCE.remove();
            this.allocation = null;
            return;
        }
        if (check == null) {
            String unexpected = "ServiceContext " + this._service + " clearAsThreadLocal: '" + this._service + "' unexpected state, thread local already cleared";
            if (this.allocation != null) {
                unexpected = unexpected + "\n\tContext '" + this._service + "' allocation: " + this.allocation.getStackTrace()[1];
            }
            this.allocation = null;
            this.checkUnexpectedState(unexpected);
            return;
        }
        if (check == this) {
            THREAD_LOCAL_INSTANCE.remove();
            this.allocation = null;
            return;
        }
        String unexpected = "ServiceContext clearAsThreadLocal: \"+_service+\" unexpected state, thread local presently used by service context '" + check._service + "'";
        if (check.allocation != null) {
            unexpected = unexpected + "\n\tContext '" + check._service + "' conflict: " + check.allocation.getStackTrace()[1];
        }
        if (this.allocation != null) {
            unexpected = unexpected + "\n\tContext '" + this._service + "' allocation: " + this.allocation.getStackTrace()[1];
        }
        THREAD_LOCAL_INSTANCE.remove();
        this.allocation = null;
        if (ApplicationContextHolder.get() != null && ApplicationContextHolder.get() != this.getApplicationContext()) {
            unexpected = unexpected + "\n\tApplicationContext '" + ApplicationContextHolder.get().getApplicationName() + "' conflict detected";
            unexpected = unexpected + "\n\tApplicationContext '" + this.getApplicationContext().getApplicationName() + "' expected";
            ApplicationContextHolder.clear();
        }
        this.checkUnexpectedState(unexpected);
    }

    public void clear() {
        if (this._service != null) {
            this.deAllocation = new Throwable("ServiceContext " + this._service + " cleared");
            this._service = null;
            this._headers = null;
            this._responseHeaders = null;
            this._servlet = null;
            this._userSession = null;
        } else {
            this.debug("Service context unexpectedly cleared twice, previously cleared by " + this.deAllocation.getStackTrace()[1]);
        }
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String lang) {
        this._language = lang;
    }

    public boolean isCleared() {
        return this._service == null;
    }

    public String getService() {
        return this._service;
    }

    public void setService(String service) {
        if (service == null) {
            service = "internal";
        }
        this._service = service;
        this.logger = Log.createLogger((String)("jeeves.webapp." + service));
    }

    public String getIpAddress() {
        this.checkCleared("ip address not available");
        return this._ipAddress;
    }

    public void setIpAddress(String address) {
        this._ipAddress = address;
    }

    public Path getUploadDir() {
        return this.getBean(GeonetworkDataDirectory.class).getUploadDir();
    }

    public int getMaxUploadSize() {
        this.checkCleared("max upload size not available");
        return this._maxUploadSize;
    }

    public void setMaxUploadSize(int size) {
        this._maxUploadSize = size;
    }

    public UserSession getUserSession() {
        this.checkCleared("user session not available");
        return this._userSession;
    }

    public void setUserSession(UserSession session) {
        this._userSession = session;
    }

    public String userName() {
        if (this._userSession == null || this._userSession.getUsername() == null) {
            return "anonymous";
        }
        if (this._userSession.getProfile() != null) {
            return this._userSession.getUsername() + "/" + this._userSession.getProfile();
        }
        return this._userSession.getUsername();
    }

    public ProfileManager getProfileManager() {
        return this.getBean(ProfileManager.class);
    }

    public ServiceRequest.InputMethod getInputMethod() {
        this.checkCleared("input method not available");
        return this._input;
    }

    public void setInputMethod(ServiceRequest.InputMethod m) {
        this._input = m;
    }

    public ServiceRequest.OutputMethod getOutputMethod() {
        this.checkCleared("output method not available");
        return this._output;
    }

    public void setOutputMethod(ServiceRequest.OutputMethod m) {
        this._output = m;
    }

    public Map<String, String> getStartupErrors() {
        this.checkCleared("startup errors not available");
        return this._startupErrors;
    }

    public void setStartupErrors(Map<String, String> errs) {
        this._startupErrors = errs;
        this._startupError = true;
    }

    public boolean isStartupError() {
        this.checkCleared("is startup error not available");
        return this._startupError;
    }

    public boolean isServletInitialized() {
        if (this._servlet != null) {
            return this._servlet.isInitialized();
        }
        return true;
    }

    public void setLogger(Logger l) {
        this.logger = l;
    }

    public Map<String, String> getHeaders() {
        this.checkCleared("headers not available");
        return this._headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this._headers = headers;
    }

    public JeevesServlet getServlet() {
        this.checkCleared("servlet not available");
        return this._servlet;
    }

    public void setServlet(JeevesServlet serv) {
        this._servlet = serv;
    }

    public void executeOnly(final LocalServiceRequest request) throws Exception {
        TransactionManager.runInTransaction("ServiceContext#executeOnly: " + request.getAddress(), (ApplicationContext)this.getApplicationContext(), TransactionManager.TransactionRequirement.CREATE_NEW, TransactionManager.CommitBehavior.ALWAYS_COMMIT, false, new TransactionTask<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus transaction) throws Throwable {
                ServiceManager serviceManager = (ServiceManager)ServiceContext.this.getApplicationContext().getBean(ServiceManager.class);
                ServiceContext localServiceContext = serviceManager.createServiceContext(request.getService(), ServiceContext.this.getApplicationContext());
                try {
                    UserSession session = ServiceContext.this._userSession;
                    if (session == null) {
                        session = new UserSession();
                    }
                    localServiceContext.setUserSession(session);
                    serviceManager.dispatch(request, session, localServiceContext);
                }
                catch (Exception e) {
                    Log.error((String)"jeeves.xlinkprocessor", (Object)("Failed to parse result xml" + request.getService()));
                    throw new ServiceExecutionFailedException(request.getService(), e);
                }
                finally {
                    if (localServiceContext == ServiceContext.get()) {
                        ServiceContext.this.setAsThreadLocal();
                    }
                    localServiceContext.clear();
                }
                return null;
            }
        });
    }

    public Element execute(LocalServiceRequest request) throws Exception {
        this.executeOnly(request);
        try {
            return request.getResult();
        }
        catch (Exception e) {
            Log.error((String)"jeeves.xlinkprocessor", (Object)("Failed to parse result xml from service:" + request.toString() + "\n" + request.getResultString()));
            throw new ServiceExecutionFailedException(request.getService(), e);
        }
    }

    public Map<String, String> getResponseHeaders() {
        return this._responseHeaders;
    }

    private void setResponseHeaders(Map<String, String> responseHeaders) {
        this._responseHeaders = responseHeaders;
    }

    public Integer getStatusCode() {
        return this._statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this._statusCode = statusCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ServiceContext ");
        sb.append("'").append(this._service).append('\'');
        sb.append(" ").append((Object)this._input).append(" --> ").append((Object)this._output);
        sb.append(" { _language='").append(this._language).append('\'');
        sb.append(", _ipAddress='").append(this._ipAddress).append('\'');
        sb.append('}');
        return sb.toString();
    }

    static {
        ThreadLocalPolicy policy;
        String property = System.getProperty("jeeves.server.context.policy", "TRACE");
        try {
            policy = ThreadLocalPolicy.valueOf(property.toUpperCase());
        }
        catch (IllegalArgumentException defaultToDirect) {
            policy = ThreadLocalPolicy.DIRECT;
        }
        POLICY = policy;
        THREAD_LOCAL_INSTANCE = new InheritableThreadLocal();
    }

    public static class AppHandlerServiceContext
    extends ServiceContext {
        public AppHandlerServiceContext(String service, ConfigurableApplicationContext jeevesApplicationContext, Map<String, Object> contexts, EntityManager entityManager) {
            super(service, jeevesApplicationContext, contexts, entityManager);
            this._language = "?";
            this._userSession = null;
            this._ipAddress = "?";
        }

        @Override
        public void setUserSession(UserSession session) {
            if (session != null) {
                this.warning("Shared service context \"" + this._service + "\"  context should not be configured with user session");
            }
            super.setUserSession(session);
        }

        @Override
        public void setIpAddress(String address) {
            if (address != null && !"?".equals(address)) {
                this.warning("Shared service context \"" + this._service + "\" should not be associated with an ip address");
            }
            super.setIpAddress(address);
        }

        @Override
        public void clear() {
            this.warning("Shared service context \"" + this._service + "\"  context is shared, and should not be cleared");
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder("AppHandlerServiceContext ");
            sb.append("'").append(this._service).append('\'');
            return sb.toString();
        }
    }

    public static class ServiceDetails {
        private String ipAddress;
        private String service;
        private String language;

        public ServiceDetails(ServiceContext context) {
            this.ipAddress = context.getIpAddress();
            this.service = context.getService();
            this.language = context.getLanguage();
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getService() {
            return this.service;
        }

        public String getLanguage() {
            return this.language;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ServiceDetails that = (ServiceDetails)o;
            return Objects.equals(this.ipAddress, that.ipAddress) && this.service.equals(that.service) && Objects.equals(this.language, that.language);
        }

        public int hashCode() {
            return Objects.hash(this.ipAddress, this.service, this.language);
        }
    }

    public static enum ThreadLocalPolicy {
        DIRECT,
        TRACE,
        STRICT;

    }
}

