/*
 * Decompiled with CFR 0.152.
 */
package jeeves.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.transform.TransformerConfigurationException;
import jeeves.component.ProfileManager;
import jeeves.interfaces.ApplicationHandler;
import jeeves.monitor.MonitorManager;
import jeeves.server.UserSession;
import jeeves.server.context.ServiceContext;
import jeeves.server.dispatchers.ServiceManager;
import jeeves.server.overrides.ConfigurationOverrides;
import jeeves.server.sources.ServiceRequest;
import jeeves.server.sources.http.JeevesServlet;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.PropertyConfigurator;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.Constants;
import org.fao.geonet.Logger;
import org.fao.geonet.Util;
import org.fao.geonet.domain.Service;
import org.fao.geonet.domain.ServiceParam;
import org.fao.geonet.exceptions.BadInputEx;
import org.fao.geonet.kernel.GeonetworkDataDirectory;
import org.fao.geonet.repository.ServiceRepository;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.TransformerFactoryFactory;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class JeevesEngine {
    private static final int DEFAULT_MAX_UPLOAD_SIZE_MD = 50;
    private static final int BYTES_PER_KB = 1024;
    private String _defaultSrv;
    private String _startupErrorSrv;
    private String _defaultLang;
    private boolean _debugFlag;
    private boolean _generalLoaded;
    private Logger _appHandLogger = Log.createLogger((String)"jeeves.apphand");
    private List<Element> _appHandList = new ArrayList<Element>();
    private Vector<ApplicationHandler> _appHandlers = new Vector();
    private List<Element> _dbServices = new ArrayList<Element>();
    private Path _appPath;
    private int _maxUploadSize;
    private ServiceContext appHandlerContext;

    public static void handleStartupError(Throwable e) {
        Log.fatal((String)"jeeves.engine", (Object)"Raised exception during init");
        Log.fatal((String)"jeeves.engine", (Object)("   Exception : " + e));
        Log.fatal((String)"jeeves.engine", (Object)("   Message   : " + e.getMessage()));
        Log.fatal((String)"jeeves.engine", (Object)("   Stack     : " + Util.getStackTrace((Throwable)e)));
        if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("geonetwork.shutdown.on.startup.error"))) {
            System.err.println("\n\n\tERROR STARTING UP GEONETWORK.  System property geonetwork.shutdown.on.startup.error == " + System.getProperty("geonetwork.shutdown.on.startup.error"));
            System.err.println("\n\n\t>> HARD SHUTDOWN INITIATED <<");
            System.exit(1);
        }
        throw new RuntimeException("Exception raised", e);
    }

    public void init(Path appPath, Path configPath, String baseUrl, JeevesServlet servlet) throws ServletException {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceManager _serviceMan = (ServiceManager)appContext.getBean(ServiceManager.class);
        MonitorManager _monitorManager = (MonitorManager)appContext.getBean(MonitorManager.class);
        ServletContext servletContext = null;
        if (servlet != null) {
            servletContext = servlet.getServletContext();
        }
        try {
            Path log4jConfig = configPath.resolve("log4j.cfg");
            if (Files.exists(log4jConfig, new LinkOption[0])) {
                PropertyConfigurator.configure((URL)log4jConfig.toUri().toURL());
            }
            ConfigurationOverrides.DEFAULT.updateLoggingAsAccordingToOverrides(servletContext, appPath);
            _monitorManager.init(servletContext, baseUrl);
            this._appPath = appPath;
            long start = System.currentTimeMillis();
            long maxMem = Runtime.getRuntime().maxMemory() / 1024L;
            long totMem = Runtime.getRuntime().totalMemory() / 1024L;
            long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
            long usedMem = totMem - freeMem;
            long startFreeMem = maxMem - usedMem;
            this.info("=== Starting system ========================================");
            this.info("Engine : " + this.getClass().getName());
            this.info("Java version : " + System.getProperty("java.vm.version"));
            this.info("Java vendor  : " + System.getProperty("java.vm.vendor"));
            this.setupXSLTTransformerFactory(servlet);
            this.info("Path    : " + appPath);
            this.info("BaseURL : " + baseUrl);
            _serviceMan.setBaseUrl(baseUrl);
            _serviceMan.setServlet(servlet);
            this.loadConfigFile(servletContext, configPath, "config.xml", _serviceMan);
            this.loadConfigDB((ApplicationContext)appContext, -1);
            for (int i = 0; i < this._appHandList.size(); ++i) {
                this.initAppHandler(this._appHandList.get(i), servlet);
            }
            long end = System.currentTimeMillis();
            long duration = TimeUnit.MILLISECONDS.toSeconds(end - start);
            freeMem = Runtime.getRuntime().freeMemory() / 1024L;
            totMem = Runtime.getRuntime().totalMemory() / 1024L;
            usedMem = totMem - freeMem;
            long endFreeMem = maxMem - usedMem;
            long dataMem = startFreeMem - endFreeMem;
            this.info("Memory used is  : " + dataMem + " Kb");
            this.info("Total memory is : " + maxMem + " Kb");
            this.info("Startup time is : " + duration + " (secs)");
            this.info("=== System working =========================================");
        }
        catch (Throwable e) {
            JeevesEngine.handleStartupError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupXSLTTransformerFactory(JeevesServlet servlet) throws IOException, TransformerConfigurationException {
        BufferedReader br;
        InputStream in;
        block11: {
            in = null;
            br = null;
            if (servlet != null) {
                in = servlet.getServletContext().getResourceAsStream("/WEB-INF/classes/META-INF/services/javax.xml.transform.TransformerFactory");
            }
            if (in == null) {
                File f = new File(this._appPath + "/WEB-INF/classes/META-INF/services/javax.xml.transform.TransformerFactory");
                in = new FileInputStream(f);
            }
            try {
                String line;
                if (in == null || (line = (br = new BufferedReader(new InputStreamReader(in, Constants.ENCODING))).readLine()) == null) break block11;
                if (line.length() == 0) {
                    this.warning("Malformed definition of XSLT transformer (in: META-INF/services/javax.xml.transform.TransformerFactory).");
                }
                TransformerFactoryFactory.init((String)line);
            }
            catch (IOException x) {
                try {
                    String msg = "Definition of XSLT transformer not found (tried: " + new File(this._appPath + "/WEB-INF/classes/META-INF/services/javax.xml.transform.TransformerFactory").getCanonicalPath() + ")";
                    if (servlet != null) {
                        msg = msg + " and servlet.getServletContext().getResourceAsStream(/WEB-INF/classes/META-INF/services/javax.xml.transform.TransformerFactory)";
                    }
                    this.warning(msg);
                    this.error(x.getMessage());
                    this.error("  Stack     : " + Util.getStackTrace((Throwable)x));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly((InputStream)in);
                    if (br != null) {
                        IOUtils.closeQuietly(br);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (br != null) {
                    IOUtils.closeQuietly((Reader)br);
                }
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        if (br != null) {
            IOUtils.closeQuietly(br);
        }
    }

    private void loadConfigFile(ServletContext servletContext, Path path, String fileName, ServiceManager serviceMan) throws Exception {
        if (fileName.charAt(0) == '/' || fileName.charAt(0) == '\\') {
            fileName = fileName.substring(1);
        }
        Path file = path.resolve(fileName);
        this.info("Loading : " + file);
        Element configRoot = Xml.loadFile((Path)file);
        ConfigurationOverrides.DEFAULT.updateWithOverrides(file.toString(), servletContext, this._appPath, configRoot);
        Element elGeneral = configRoot.getChild("general");
        Element elDefault = configRoot.getChild("default");
        if (!this._generalLoaded) {
            if (elGeneral == null) {
                throw new NullPointerException("Missing 'general' element in config file :" + file);
            }
            if (elDefault == null) {
                throw new NullPointerException("Missing 'default' element in config file :" + file);
            }
            this._generalLoaded = true;
            this.initGeneral(elGeneral, serviceMan);
            this.initDefault(elDefault, serviceMan);
        } else {
            if (elGeneral != null) {
                throw new IllegalArgumentException("Illegal 'general' element in secondary include");
            }
            if (elDefault != null) {
                throw new IllegalArgumentException("Illegal 'default' element in secondary include");
            }
        }
        this._appHandList.addAll(configRoot.getChildren("appHandler"));
        List srvList = configRoot.getChildren("services");
        for (Element aSrvList : srvList) {
            this.initServices(aSrvList);
        }
        List monitorList = configRoot.getChildren("monitors");
        ConfigurableApplicationContext context = ApplicationContextHolder.get();
        for (Element aMonitorList : monitorList) {
            ((MonitorManager)context.getBean(MonitorManager.class)).initMonitors(aMonitorList);
        }
        List includes = configRoot.getChildren("include");
        for (Element include : includes) {
            this.loadConfigFile(servletContext, path, include.getText(), serviceMan);
        }
    }

    private void initGeneral(Element general, ServiceManager serviceMan) throws BadInputEx {
        this.info("Initializing general configuration...");
        try {
            this._maxUploadSize = Integer.parseInt(Util.getParam((Element)general, (String)"maxUploadSize"));
        }
        catch (Exception e) {
            this._maxUploadSize = 50;
            this.error("Maximum upload size not properly configured in config.xml. Using default size of 50MB");
            this.error("   Exception : " + e);
            this.error("   Message   : " + e.getMessage());
            this.error("   Stack     : " + Util.getStackTrace((Throwable)e));
        }
        this._debugFlag = "true".equals(general.getChildText("debug"));
        serviceMan.setMaxUploadSize(this._maxUploadSize);
    }

    private void initDefault(Element defaults, ServiceManager serviceMan) throws Exception {
        this.info("Initializing defaults...");
        this._defaultSrv = Util.getParam((Element)defaults, (String)"service");
        this._startupErrorSrv = Util.getParam((Element)defaults, (String)"startupErrorService", (String)"");
        this._defaultLang = Util.getParam((Element)defaults, (String)"language");
        String defaultContType = Util.getParam((Element)defaults, (String)"contentType");
        boolean defaultLocal = "true".equals(defaults.getChildText("localized"));
        this.info("   Default local is :" + defaultLocal);
        serviceMan.setDefaultLang(this._defaultLang);
        serviceMan.setDefaultLocal(defaultLocal);
        serviceMan.setDefaultContType(defaultContType);
        List errorPages = defaults.getChildren("error");
        for (Element errorPage : errorPages) {
            serviceMan.addErrorPage(errorPage);
        }
        Element gui = defaults.getChild("gui");
        if (gui != null) {
            List guiElems = gui.getChildren();
            for (Element guiElem : guiElems) {
                serviceMan.addDefaultGui(guiElem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAppHandler(Element handler, JeevesServlet servlet) throws Exception {
        if (handler == null) {
            this.info("Handler not found");
        } else {
            String className = handler.getAttributeValue("class");
            if (className == null) {
                throw new IllegalArgumentException("Missing 'class' attribute in 'appHandler' element");
            }
            ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
            ServiceManager serviceMan = (ServiceManager)appContext.getBean(ServiceManager.class);
            MonitorManager monitorManager = (MonitorManager)appContext.getBean(MonitorManager.class);
            this.info("Found handler : " + className);
            Class<?> c = Class.forName(className);
            ApplicationHandler h = (ApplicationHandler)c.newInstance();
            this.appHandlerContext = serviceMan.createAppHandlerServiceContext(appContext);
            this.appHandlerContext.setLanguage(this._defaultLang);
            this.appHandlerContext.setLogger(this._appHandLogger);
            this.appHandlerContext.setServlet(servlet);
            this.appHandlerContext.setAsThreadLocal();
            try {
                this.info("--- Starting handler --------------------------------------");
                Object context = h.start(handler, this.appHandlerContext);
                this._appHandlers.add(h);
                serviceMan.registerContext(h.getContextName(), context);
                monitorManager.initMonitorsForApp(this.appHandlerContext);
                this.info("--- Handler started ---------------------------------------");
            }
            catch (Exception e) {
                HashMap<String, String> errors = new HashMap<String, String>();
                String eS = "Raised exception while starting the application. Fix the error and restart.";
                this.error(eS);
                errors.put("Error", eS);
                this.error("   Handler   : " + className);
                errors.put("Handler", className);
                this.error("   Exception : " + e);
                errors.put("Exception", e.toString());
                this.error("   Message   : " + e.getMessage());
                errors.put("Message", e.getMessage());
                String stackTrace = Util.getStackTrace((Throwable)e);
                this.error("   Stack     : " + stackTrace);
                errors.put("Stack", stackTrace);
                this.error(((Object)errors).toString());
                if (!serviceMan.isStartupError()) {
                    serviceMan.setStartupErrors(errors);
                }
            }
            finally {
                this.appHandlerContext.clearAsThreadLocal();
            }
        }
    }

    public void initServices(Element services) throws Exception {
        this.info("Initializing services...");
        String pack = services.getAttributeValue("package");
        ServiceManager serviceManager = (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
        for (Element service : services.getChildren("service")) {
            String name = service.getAttributeValue("name");
            this.info("   Adding service : " + name);
            try {
                serviceManager.addService(pack, service, this._appPath);
            }
            catch (Exception e) {
                this.warning("Raised exception while registering service. Skipped.");
                this.warning("   Service   : " + name);
                this.warning("   Package   : " + pack);
                this.warning("   Exception : " + e);
                this.warning("   Message   : " + e.getMessage());
                this.warning("   Stack     : " + Util.getStackTrace((Throwable)e));
            }
        }
    }

    @PreDestroy
    public void destroy() {
        try {
            this.info("=== Stopping system ========================================");
            this.info("Stopping handlers...");
            this.stopHandlers();
            this.info("Clearing application handler context...");
            this.appHandlerContext.clear();
            this.info("=== System stopped ========================================");
        }
        catch (Exception e) {
            this.error("Raised exception during destroy");
            this.error("  Exception : " + e);
            this.error("  Message   : " + e.getMessage());
            this.error("  Stack     : " + Util.getStackTrace((Throwable)e));
        }
    }

    private void stopHandlers() throws Exception {
        for (ApplicationHandler h : this._appHandlers) {
            try {
                h.stop();
            }
            catch (Throwable unexpected) {
                this._appHandLogger.error("Difficulty while stopping " + h.getContextName());
                this._appHandLogger.error(unexpected);
            }
        }
    }

    public Path getUploadDir() {
        return ((GeonetworkDataDirectory)ApplicationContextHolder.get().getBean(GeonetworkDataDirectory.class)).getUploadDir();
    }

    public int getMaxUploadSize() {
        return this._maxUploadSize;
    }

    public void dispatch(ServiceRequest srvReq, UserSession session) {
        ServiceManager serviceManager = (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
        if (srvReq.getService() == null || srvReq.getService().length() == 0) {
            srvReq.setService(this._defaultSrv);
        }
        if (srvReq.getLanguage() == null || srvReq.getLanguage().length() == 0) {
            srvReq.setLanguage(this._defaultLang);
        }
        srvReq.setDebug(srvReq.hasDebug() && this._debugFlag);
        if (serviceManager.isStartupError() && !this._startupErrorSrv.equals("") && !srvReq.getService().contains(this._startupErrorSrv)) {
            srvReq.setService(this._startupErrorSrv);
        }
        serviceManager.dispatch(srvReq, session);
    }

    private void info(String message) {
        Log.info((String)"jeeves.engine", (Object)message);
    }

    private void warning(String message) {
        Log.warning((String)"jeeves.engine", (Object)message);
    }

    private void error(String message) {
        Log.error((String)"jeeves.engine", (Object)message);
    }

    private void fatal(String message) {
        Log.fatal((String)"jeeves.engine", (Object)message);
    }

    public ServiceManager getServiceManager() {
        return (ServiceManager)ApplicationContextHolder.get().getBean(ServiceManager.class);
    }

    public ProfileManager getProfileManager() {
        return this.getServiceManager().getProfileManager();
    }

    public void loadConfigDB(ApplicationContext context, int serviceIdentifierToLoad) {
        try {
            Element eltServices = new Element("services");
            eltServices.setAttribute("package", "org.fao.geonet");
            List<Object> serviceList = null;
            ServiceRepository serviceRepo = (ServiceRepository)context.getBean(ServiceRepository.class);
            serviceList = serviceIdentifierToLoad == -1 ? serviceRepo.findAll() : Collections.singletonList(serviceRepo.findOne((Serializable)Integer.valueOf(serviceIdentifierToLoad)));
            for (Service service : serviceList) {
                if (service == null) continue;
                Element srv = new Element("service");
                Element cls = new Element("class");
                List paramList = service.getParameters();
                StringBuilder filter = new StringBuilder();
                if (!service.getExplicitQuery().isEmpty()) {
                    filter.append(service.getExplicitQuery());
                }
                for (ServiceParam serviceParam : paramList) {
                    if (serviceParam.getValue() == null || serviceParam.getValue().trim().isEmpty()) continue;
                    filter.append(" ");
                    if (serviceParam.getOccur() == null) {
                        filter.append("+");
                    } else {
                        filter.append(serviceParam.getOccur());
                    }
                    filter.append(serviceParam.getName()).append(":").append(serviceParam.getValue());
                }
                cls.addContent((Content)new Element("param").setAttribute("name", "filter").setAttribute("value", filter.toString().trim()));
                srv.setAttribute("name", service.getName()).addContent((Content)cls.setAttribute("name", service.getClassName()));
                eltServices.addContent((Content)srv);
            }
            this._dbServices.add(eltServices);
            for (int i = 0; i < this._dbServices.size(); ++i) {
                this.initServices(this._dbServices.get(i));
            }
        }
        catch (Exception e) {
            this.warning("Jeeves DBMS service configuration lookup failed (database may not be available yet). Message is: " + e.getMessage());
        }
    }
}

