/*
 * Decompiled with CFR 0.152.
 */
package jeeves.config.springutil;

import java.io.IOException;
import java.nio.file.Path;
import javax.annotation.CheckForNull;
import javax.servlet.ServletContext;
import jeeves.server.overrides.ConfigurationOverrides;
import jeeves.server.sources.http.ServletPathFinder;
import org.jdom.JDOMException;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JeevesApplicationContext
extends XmlWebApplicationContext {
    @CheckForNull
    private final ConfigurationOverrides _configurationOverrides;

    public JeevesApplicationContext(ConfigurationOverrides configurationOverrides, ApplicationContext parent, String ... configLocations) {
        if (configLocations == null || configLocations.length == 0) {
            throw new IllegalArgumentException("No config locations were specified.  There must be at least one");
        }
        this.setParent(parent);
        this.setConfigLocations(configLocations);
        this._configurationOverrides = configurationOverrides;
    }

    protected void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.postProcessBeanFactory(beanFactory);
        try {
            ServletContext servletContext = this.getServletContext();
            Path appPath = this.getAppPath();
            if (this._configurationOverrides != null) {
                this._configurationOverrides.postProcessSpringBeanFactory(beanFactory, servletContext, appPath);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            RuntimeException e2 = new RuntimeException();
            e2.initCause(e);
            throw e2;
        }
    }

    protected void finishRefresh() {
        try {
            ServletContext servletContext = this.getServletContext();
            Path appPath = this.getAppPath();
            if (this._configurationOverrides != null) {
                this._configurationOverrides.onSpringApplicationContextFinishedRefresh(this.getBeanFactory(), servletContext, appPath);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            RuntimeException e2 = new RuntimeException();
            e2.initCause(e);
            throw e2;
        }
        super.finishRefresh();
    }

    protected Path getAppPath() {
        ServletPathFinder pathFinder = new ServletPathFinder(this.getServletContext());
        return pathFinder.getAppPath();
    }

    protected void loadBeanDefinitions(XmlBeanDefinitionReader reader) throws IOException {
        reader.setValidating(false);
        super.loadBeanDefinitions(reader);
        Path appPath = this.getAppPath();
        if (this._configurationOverrides != null) {
            try {
                this._configurationOverrides.importSpringConfigurations(reader, (ConfigurableBeanFactory)reader.getBeanFactory(), this.getServletContext(), appPath);
            }
            catch (JDOMException e) {
                throw new IOException(e);
            }
        }
    }
}

