/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.dynect.v3.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;

public final class Session {
    private final String token;
    private final String version;

    public static Session forTokenAndVersion(String token, String version) {
        return new Session(token, version);
    }

    @ConstructorProperties(value={"token", "version"})
    private Session(String token, String version) {
        this.token = (String)Preconditions.checkNotNull((Object)token, (Object)"token");
        this.version = (String)Preconditions.checkNotNull((Object)version, (String)"version for %s", (Object[])new Object[]{token});
    }

    public String getToken() {
        return this.token;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.token, this.version});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Session other = (Session)Session.class.cast(obj);
        return Objects.equal((Object)this.token, (Object)other.token) && Objects.equal((Object)this.version, (Object)other.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("token", (Object)this.token).add("version", (Object)this.version).toString();
    }
}

