/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.MetadataValidation;
import org.fao.geonet.domain.MetadataValidationId_;
import org.fao.geonet.domain.MetadataValidationStatus;
import org.fao.geonet.domain.MetadataValidation_;
import org.springframework.data.jpa.domain.Specification;

public class MetadataValidationSpecs {
    private MetadataValidationSpecs() {
    }

    public static Specification<MetadataValidation> isInvalidAndRequiredForMetadata(final int metadataId) {
        return new Specification<MetadataValidation>(){

            public Predicate toPredicate(Root<MetadataValidation> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path statusAttributePath = root.get(MetadataValidation_.status);
                Path requiredAttributePath = root.get(MetadataValidation_.required);
                Path metadataIdAttributePath = root.get(MetadataValidation_.id).get(MetadataValidationId_.metadataId);
                return cb.and((Expression)cb.equal((Expression)metadataIdAttributePath, cb.literal((Object)metadataId)), (Expression)cb.and((Expression)cb.equal((Expression)statusAttributePath, cb.literal((Object)MetadataValidationStatus.INVALID)), (Expression)cb.equal((Expression)requiredAttributePath, cb.literal((Object)Boolean.TRUE))));
            }
        };
    }

    public static Specification<MetadataValidation> hasMetadataId(final int metadataId) {
        return new Specification<MetadataValidation>(){

            public Predicate toPredicate(Root<MetadataValidation> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                Path metadataIdAttributePath = root.get(MetadataValidation_.id).get(MetadataValidationId_.metadataId);
                return cb.equal((Expression)metadataIdAttributePath, cb.literal((Object)metadataId));
            }
        };
    }
}

