/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository.specification;

import java.util.Collection;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.Group;
import org.fao.geonet.domain.Group_;
import org.fao.geonet.domain.Profile;
import org.fao.geonet.domain.ReservedGroup;
import org.fao.geonet.domain.UserGroup;
import org.fao.geonet.domain.UserGroupId_;
import org.fao.geonet.domain.UserGroup_;
import org.fao.geonet.domain.User_;
import org.springframework.data.jpa.domain.Specification;

public final class GroupSpecs {
    private GroupSpecs() {
    }

    public static Specification<Group> isReserved() {
        return new Specification<Group>(){

            public Predicate toPredicate(Root<Group> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return GroupSpecs.getIsReserved((Root<Group>)root, cb);
            }
        };
    }

    public static Specification<Group> in(final List<Integer> ids) {
        return new Specification<Group>(){

            public Predicate toPredicate(Root<Group> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return cb.and((Expression)root.get(Group_.id).in((Collection)ids), (Expression)cb.not((Expression)GroupSpecs.getIsReserved((Root<Group>)root, cb)));
            }
        };
    }

    public static Specification<Group> inGroupNames(final List<String> groupNames) {
        return new Specification<Group>(){

            public Predicate toPredicate(Root<Group> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return cb.and((Expression)root.get(Group_.name).in((Collection)groupNames), (Expression)cb.not((Expression)GroupSpecs.getIsReserved((Root<Group>)root, cb)));
            }
        };
    }

    private static Predicate getIsReserved(Root<Group> root, CriteriaBuilder cb) {
        int maxId = Integer.MIN_VALUE;
        for (ReservedGroup reservedGroup : ReservedGroup.values()) {
            if (maxId >= reservedGroup.getId()) continue;
            maxId = reservedGroup.getId();
        }
        return cb.lessThanOrEqualTo((Expression)root.get(Group_.id), (Comparable)Integer.valueOf(maxId));
    }

    public static Specification<UserGroup> isEditorOrMore(final Integer userId) {
        return new Specification<UserGroup>(){

            public Predicate toPredicate(Root<UserGroup> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                root.join(UserGroup_.group);
                Predicate pred = cb.equal((Expression)root.get(UserGroup_.user).get(User_.id), (Object)userId);
                pred = cb.and((Expression)pred, (Expression)cb.lessThanOrEqualTo((Expression)root.get(UserGroup_.id).get(UserGroupId_.profile), (Comparable)((Object)Profile.Editor)));
                return pred;
            }
        };
    }
}

