/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.repository;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.fao.geonet.domain.InspireAtomFeed;
import org.fao.geonet.domain.InspireAtomFeed_;
import org.fao.geonet.domain.Metadata;
import org.fao.geonet.repository.InspireAtomFeedRepositoryCustom;

public class InspireAtomFeedRepositoryImpl
implements InspireAtomFeedRepositoryCustom {
    @PersistenceContext
    private EntityManager _entityManager;

    @Override
    public String retrieveDatasetUuidFromIdentifierNs(String datasetIdCode, String datasetIdNs) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(InspireAtomFeed.class);
        Root root = cbQuery.from(InspireAtomFeed.class);
        Path datasetIdCodeAttributePath = root.get(InspireAtomFeed_.atomDatasetid);
        Path datasetIdNsAttributePath = root.get(InspireAtomFeed_.atomDatasetns);
        Predicate datasetIdCodePredicate = cb.equal((Expression)datasetIdCodeAttributePath, (Object)datasetIdCode);
        Predicate datasetIdNsPredicate = cb.equal((Expression)datasetIdNsAttributePath, (Object)datasetIdNs);
        cbQuery.where((Expression)cb.and((Expression)datasetIdCodePredicate, (Expression)datasetIdNsPredicate));
        return this.executeQueryAndGetMetadataUuid((CriteriaQuery<InspireAtomFeed>)cbQuery);
    }

    @Override
    public String retrieveDatasetUuidFromIdentifier(String datasetIdCode) {
        CriteriaBuilder cb = this._entityManager.getCriteriaBuilder();
        CriteriaQuery cbQuery = cb.createQuery(InspireAtomFeed.class);
        Root root = cbQuery.from(InspireAtomFeed.class);
        Path datasetIdCodeAttributePath = root.get(InspireAtomFeed_.atomDatasetid);
        Predicate datasetIdCodePredicate = cb.equal((Expression)datasetIdCodeAttributePath, (Object)datasetIdCode);
        cbQuery.where((Expression)datasetIdCodePredicate);
        return this.executeQueryAndGetMetadataUuid((CriteriaQuery<InspireAtomFeed>)cbQuery);
    }

    private String executeQueryAndGetMetadataUuid(CriteriaQuery<InspireAtomFeed> cbQuery) {
        String metadataUuid = "";
        List feeds = this._entityManager.createQuery(cbQuery).getResultList();
        if (!feeds.isEmpty()) {
            Metadata md = (Metadata)this._entityManager.find(Metadata.class, (Object)((InspireAtomFeed)feeds.get(0)).getMetadataId());
            metadataUuid = md.getUuid();
        }
        return metadataUuid;
    }
}

