/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.domain.MetadataNotification;
import org.fao.geonet.entitylistener.MetadataNotifierEntityListenerManager;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="MetadataNotifiers")
@EntityListeners(value={MetadataNotifierEntityListenerManager.class})
@SequenceGenerator(name="metadata_notifier_id_seq", initialValue=100, allocationSize=1)
public class MetadataNotifier
extends GeonetEntity {
    static final String ID_SEQ_NAME = "metadata_notifier_id_seq";
    private int _id;
    private String _name;
    private String _url;
    private char _enabled = (char)110;
    private String _username;
    private char[] _password;
    private List<MetadataNotification> _notifications = new ArrayList<MetadataNotification>();

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="metadata_notifier_id_seq")
    public int getId() {
        return this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    @Column(nullable=false, length=32)
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Column(nullable=false)
    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        this._url = url;
    }

    @Column(name="enabled", length=1, nullable=false)
    protected char getEnabled_JPAWorkaround() {
        return this._enabled;
    }

    protected void setEnabled_JPAWorkaround(char enabled) {
        this._enabled = enabled;
    }

    @Transient
    public boolean isEnabled() {
        return Constants.toBoolean_fromYNChar(this.getEnabled_JPAWorkaround());
    }

    public void setEnabled(boolean enabled) {
        this.setEnabled_JPAWorkaround(Constants.toYN_EnabledChar(enabled));
    }

    @Column(length=32)
    @Nullable
    public String getUsername() {
        return this._username;
    }

    public void setUsername(@Nullable String username) {
        this._username = username;
    }

    @Nullable
    public char[] getPassword() {
        if (this._password == null) {
            return null;
        }
        return (char[])this._password.clone();
    }

    public void setPassword(@Nullable String password) {
        this._password = (char[])(password == null ? null : (char[])password.toCharArray().clone());
    }

    public void setPassword(@Nullable char[] password) {
        this._password = (char[])(password == null ? null : (char[])password.clone());
    }

    @JoinColumn(name="notifierId")
    @OneToMany(fetch=FetchType.LAZY)
    public List<MetadataNotification> getNotifications() {
        return this._notifications;
    }

    protected void setNotifications(List<MetadataNotification> notifications) {
        this._notifications = notifications;
    }
}

