/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.domain;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.fao.geonet.domain.Constants;
import org.fao.geonet.domain.GeonetEntity;
import org.fao.geonet.entitylistener.HarvesterSettingEntityListenerManager;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.Type;

@Entity
@Table(name="HarvesterSettings")
@Access(value=AccessType.PROPERTY)
@EntityListeners(value={HarvesterSettingEntityListenerManager.class})
@SequenceGenerator(name="harvester_setting_id_seq", initialValue=100, allocationSize=1)
public class HarvesterSetting
extends GeonetEntity {
    static final String ID_SEQ_NAME = "harvester_setting_id_seq";
    private static final HashSet<String> EXCLUDE_FROM_XML = Sets.newHashSet((Object[])new String[]{"valueAsBool", "valueAsInt"});
    private int id;
    private HarvesterSetting parent;
    private String name;
    private String storedValue;
    private String value;
    private char encrypted = (char)110;

    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="harvester_setting_id_seq")
    @Column(name="id", nullable=false)
    public int getId() {
        return this.id;
    }

    public HarvesterSetting setId(int id) {
        this.id = id;
        return this;
    }

    @OneToOne(optional=true, fetch=FetchType.LAZY, cascade={CascadeType.REFRESH})
    @JoinColumn(name="parentid")
    @OnDelete(action=OnDeleteAction.CASCADE)
    @Nullable
    public HarvesterSetting getParent() {
        return this.parent;
    }

    @Nonnull
    public HarvesterSetting setParent(@Nullable HarvesterSetting parent) {
        this.parent = parent;
        return this;
    }

    @Column(name="name", nullable=false)
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public HarvesterSetting setName(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Lob
    @Column(name="value", nullable=true)
    @Type(type="org.hibernate.type.TextType")
    @Nullable
    public String getStoredValue() {
        return this.storedValue;
    }

    public HarvesterSetting setStoredValue(@Nullable String value) {
        this.storedValue = value;
        return this;
    }

    @Transient
    public boolean getValueAsBool() throws NullPointerException {
        if (this.getValue() == null) {
            throw new NullPointerException("Setting value of " + this.getName() + " is null");
        }
        return Boolean.parseBoolean(this.value);
    }

    @Transient
    public int getValueAsInt() throws NullPointerException, NumberFormatException {
        if (this.getValue() == null) {
            throw new NullPointerException("Setting value of " + this.getName() + " is null");
        }
        return Integer.parseInt(this.getValue());
    }

    @Column(name="encrypted", nullable=false, length=1, columnDefinition="char default 'n'")
    protected char getEncrypted_JpaWorkaround() {
        return this.encrypted;
    }

    protected void setEncrypted_JpaWorkaround(char encryptedValue) {
        this.encrypted = encryptedValue;
    }

    @Transient
    public boolean isEncrypted() {
        return Constants.toBoolean_fromYNChar(this.getEncrypted_JpaWorkaround());
    }

    public HarvesterSetting setEncrypted(boolean encrypted) {
        this.setEncrypted_JpaWorkaround(Constants.toYN_EnabledChar(encrypted));
        return this;
    }

    @Transient
    public String getValue() {
        return this.value;
    }

    public HarvesterSetting setValue(@Nullable String value) {
        this.value = value;
        this.setStoredValue(value);
        return this;
    }

    @Override
    protected Set<String> propertiesToExcludeFromXml() {
        return EXCLUDE_FROM_XML;
    }

    public String toString() {
        return "Setting [id=" + this.id + ", name=" + this.name + ", value=" + this.value + "]";
    }
}

