/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.ec2.xml;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.aws.ec2.domain.SpotInstanceRequest;
import org.jclouds.aws.ec2.xml.SpotInstanceHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SpotInstancesHandler
extends ParseSax.HandlerWithResult<Set<SpotInstanceRequest>> {
    private final ImmutableSet.Builder<SpotInstanceRequest> spotRequests = ImmutableSet.builder();
    private final SpotInstanceHandler spotRequestHandler;
    private int itemDepth;

    @Inject
    public SpotInstancesHandler(SpotInstanceHandler spotRequestHandler) {
        this.spotRequestHandler = spotRequestHandler;
    }

    public Set<SpotInstanceRequest> getResult() {
        return this.spotRequests.build();
    }

    public ParseSax.HandlerWithResult<Set<SpotInstanceRequest>> setContext(HttpRequest request) {
        this.spotRequestHandler.setContext(request);
        return super.setContext(request);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("item")) {
            ++this.itemDepth;
        }
        if (this.itemDepth >= 1) {
            this.spotRequestHandler.startElement(uri, localName, qName, attributes);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("item") && this.itemDepth == 1) {
            this.spotRequests.add((Object)this.spotRequestHandler.getResult());
        }
        if (qName.equals("item")) {
            --this.itemDepth;
        }
        if (this.itemDepth >= 1) {
            this.spotRequestHandler.endElement(uri, localName, qName);
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.itemDepth >= 1) {
            this.spotRequestHandler.characters(ch, start, length);
        }
    }
}

