/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.files.FileReader;
import org.geotools.data.shapefile.files.ShpFileType;
import org.geotools.data.shapefile.files.ShpFiles;
import org.geotools.data.shapefile.files.StreamLogging;
import org.geotools.util.NIOUtilities;

public class DbaseFileReader
implements FileReader,
Closeable {
    DbaseFileHeader header;
    ByteBuffer buffer;
    ReadableByteChannel channel;
    byte[] bytes;
    char[] fieldTypes;
    int[] fieldLengths;
    int[] fieldOffsets;
    int cnt = 1;
    Row row;
    protected boolean useMemoryMappedBuffer;
    protected boolean randomAccessEnabled;
    protected long currentOffset = 0L;
    private final StreamLogging streamLogger = new StreamLogging("Dbase File Reader");
    private Charset stringCharset;
    private boolean oneBytePerChar;
    private Calendar calendar;
    private final long MILLISECS_PER_DAY = 86400000L;

    public DbaseFileReader(ShpFiles shapefileFiles, boolean useMemoryMappedBuffer, Charset charset, TimeZone timeZone) throws IOException {
        ReadableByteChannel dbfChannel = shapefileFiles.getReadChannel(ShpFileType.DBF, this);
        this.init(dbfChannel, useMemoryMappedBuffer, charset, timeZone);
    }

    public DbaseFileReader(ShpFiles shapefileFiles, boolean useMemoryMappedBuffer, Charset charset) throws IOException {
        ReadableByteChannel dbfChannel = shapefileFiles.getReadChannel(ShpFileType.DBF, this);
        this.init(dbfChannel, useMemoryMappedBuffer, charset, null);
    }

    public DbaseFileReader(ReadableByteChannel readChannel, boolean useMemoryMappedBuffer, Charset charset) throws IOException {
        this.init(readChannel, useMemoryMappedBuffer, charset, null);
    }

    public DbaseFileReader(ReadableByteChannel readChannel, boolean useMemoryMappedBuffer, Charset charset, TimeZone timeZone) throws IOException {
        this.init(readChannel, useMemoryMappedBuffer, charset, timeZone);
    }

    private void init(ReadableByteChannel dbfChannel, boolean useMemoryMappedBuffer, Charset charset, TimeZone timeZone) throws IOException {
        this.channel = dbfChannel;
        this.stringCharset = charset == null ? Charset.defaultCharset() : charset;
        TimeZone calTimeZone = timeZone == null ? TimeZone.getDefault() : timeZone;
        this.calendar = Calendar.getInstance(calTimeZone, Locale.US);
        this.useMemoryMappedBuffer = useMemoryMappedBuffer;
        this.randomAccessEnabled = this.channel instanceof FileChannel;
        this.streamLogger.open();
        this.header = new DbaseFileHeader(this.stringCharset);
        if (this.channel instanceof FileChannel && this.useMemoryMappedBuffer) {
            FileChannel fc = (FileChannel)this.channel;
            this.buffer = fc.size() - fc.position() < Integer.MAX_VALUE ? fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size()) : fc.map(FileChannel.MapMode.READ_ONLY, 0L, Integer.MAX_VALUE);
            this.buffer.position((int)fc.position());
            this.header.readHeader(this.buffer);
            this.currentOffset = 0L;
        } else {
            this.useMemoryMappedBuffer = false;
            this.header.readHeader(this.channel);
            this.buffer = NIOUtilities.allocate((int)this.header.getRecordLength());
            this.fill(this.buffer, this.channel);
            ((Buffer)this.buffer).flip();
            this.currentOffset = this.header.getHeaderLength();
        }
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.fieldTypes = new char[this.header.getNumFields()];
        this.fieldLengths = new int[this.header.getNumFields()];
        this.fieldOffsets = new int[this.header.getNumFields()];
        int ii = this.header.getNumFields();
        for (int i = 0; i < ii; ++i) {
            this.fieldTypes[i] = this.header.getFieldType(i);
            this.fieldLengths[i] = this.header.getFieldLength(i);
            if (i <= 0) continue;
            this.fieldOffsets[i] = this.fieldOffsets[i - 1] + this.header.getFieldLength(i - 1);
        }
        this.bytes = new byte[this.header.getRecordLength() - 1];
        String cname = this.stringCharset.name();
        this.oneBytePerChar = "ISO-8859-1".equals(cname) || "US-ASCII".equals(cname);
        this.row = new Row();
    }

    protected int fill(ByteBuffer buffer, ReadableByteChannel channel) throws IOException {
        int r = buffer.remaining();
        while (buffer.remaining() > 0 && r != -1) {
            r = channel.read(buffer);
        }
        if (r == -1) {
            buffer.limit(buffer.position());
        }
        return r;
    }

    private void bufferCheck() throws IOException {
        if (this.useMemoryMappedBuffer) {
            if (this.buffer.remaining() < this.header.getRecordLength()) {
                FileChannel fc = (FileChannel)this.channel;
                int position = this.buffer.position();
                this.currentOffset = fc.size() > (long)(position + Integer.MAX_VALUE) ? (long)position : fc.size() - Integer.MAX_VALUE;
                NIOUtilities.clean((ByteBuffer)this.buffer);
                this.buffer = fc.map(FileChannel.MapMode.READ_ONLY, this.currentOffset, Integer.MAX_VALUE);
                this.buffer = ((FileChannel)this.channel).map(FileChannel.MapMode.READ_ONLY, this.buffer.position(), Integer.MAX_VALUE);
            }
        } else if (this.buffer.remaining() < this.header.getRecordLength()) {
            this.currentOffset += (long)this.buffer.position();
            this.buffer.compact();
            this.fill(this.buffer, this.channel);
            this.buffer.position(0);
        }
    }

    public DbaseFileHeader getHeader() {
        return this.header;
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null && this.channel.isOpen()) {
            this.channel.close();
            this.streamLogger.close();
        }
        if (this.buffer != null) {
            NIOUtilities.clean((ByteBuffer)this.buffer, (boolean)this.useMemoryMappedBuffer);
        }
        this.buffer = null;
        this.channel = null;
        this.bytes = null;
        this.header = null;
        this.row = null;
    }

    public boolean hasNext() {
        return this.cnt < this.header.getNumRecords() + 1;
    }

    public Object[] readEntry() throws IOException {
        return this.readEntry(new Object[this.header.getNumFields()]);
    }

    public Row readRow() throws IOException {
        this.read();
        return this.row;
    }

    public void skip() throws IOException {
        boolean foundRecord = false;
        while (!foundRecord) {
            this.bufferCheck();
            char tempDeleted = (char)this.buffer.get();
            this.buffer.position(this.buffer.position() + this.header.getRecordLength() - 1);
            if (tempDeleted == '*') continue;
            foundRecord = true;
        }
        ++this.cnt;
    }

    public Object[] readEntry(Object[] entry, int offset) throws IOException {
        if (entry.length - offset < this.header.getNumFields()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.read();
        if (this.row.deleted) {
            return null;
        }
        int numFields = this.header.getNumFields();
        for (int j = 0; j < numFields; ++j) {
            entry[j + offset] = this.readObject(this.fieldOffsets[j], j);
        }
        return entry;
    }

    public Object readField(int fieldNum) throws IOException {
        return this.readObject(this.fieldOffsets[fieldNum], fieldNum);
    }

    public void transferTo(DbaseFileWriter writer) throws IOException {
        this.bufferCheck();
        this.buffer.limit(this.buffer.position() + this.header.getRecordLength());
        writer.channel.write(this.buffer);
        this.buffer.limit(this.buffer.capacity());
        ++this.cnt;
    }

    public void read() throws IOException {
        boolean foundRecord = false;
        while (!foundRecord) {
            this.bufferCheck();
            char deleted = (char)this.buffer.get();
            this.row.deleted = deleted == '*';
            ((Buffer)this.buffer).limit(this.buffer.position() + this.header.getRecordLength() - 1);
            this.buffer.get(this.bytes);
            ((Buffer)this.buffer).limit(this.buffer.capacity());
            foundRecord = true;
        }
        ++this.cnt;
    }

    public Object[] readEntry(Object[] entry) throws IOException {
        return this.readEntry(entry, 0);
    }

    private Object readObject(int fieldOffset, int fieldNum) throws IOException {
        char type = this.fieldTypes[fieldNum];
        int fieldLen = this.fieldLengths[fieldNum];
        Object object = null;
        if (fieldLen > 0) {
            block5 : switch (type) {
                case 'L': 
                case 'l': {
                    char c = (char)this.bytes[fieldOffset];
                    switch (c) {
                        case 'T': 
                        case 'Y': 
                        case 't': 
                        case 'y': {
                            object = Boolean.TRUE;
                            break block5;
                        }
                        case 'F': 
                        case 'N': 
                        case 'f': 
                        case 'n': {
                            object = Boolean.FALSE;
                            break block5;
                        }
                    }
                    object = null;
                    break;
                }
                case 'C': 
                case 'c': {
                    if (this.bytes[fieldOffset] == 0) break;
                    if (this.oneBytePerChar) {
                        object = this.fastParse(this.bytes, fieldOffset, fieldLen).trim();
                        break;
                    }
                    object = new String(this.bytes, fieldOffset, fieldLen, this.stringCharset.name()).trim();
                    break;
                }
                case 'D': 
                case 'd': {
                    for (int i = 0; i < 8; ++i) {
                        if (this.bytes[fieldOffset + i] == 48) continue;
                        try {
                            String tempString = this.fastParse(this.bytes, fieldOffset, 4);
                            int tempYear = Integer.parseInt(tempString);
                            tempString = this.fastParse(this.bytes, fieldOffset + 4, 2);
                            int tempMonth = Integer.parseInt(tempString) - 1;
                            tempString = this.fastParse(this.bytes, fieldOffset + 6, 2);
                            int tempDay = Integer.parseInt(tempString);
                            this.calendar.clear();
                            this.calendar.set(1, tempYear);
                            this.calendar.set(2, tempMonth);
                            this.calendar.set(5, tempDay);
                            object = this.calendar.getTime();
                        }
                        catch (NumberFormatException tempString) {}
                        break block5;
                    }
                    break;
                }
                case '@': {
                    try {
                        byte[] timestampBytes = new byte[]{this.bytes[fieldOffset + 7], this.bytes[fieldOffset + 6], this.bytes[fieldOffset + 5], this.bytes[fieldOffset + 4], this.bytes[fieldOffset + 3], this.bytes[fieldOffset + 2], this.bytes[fieldOffset + 1], this.bytes[fieldOffset]};
                        ByteArrayInputStream i_bytes = new ByteArrayInputStream(timestampBytes);
                        DataInputStream i_stream = new DataInputStream(new BufferedInputStream(i_bytes));
                        int time = i_stream.readInt();
                        int days = i_stream.readInt();
                        this.calendar.setTimeInMillis((long)days * 86400000L + DbaseFileHeader.MILLIS_SINCE_4713 + (long)time);
                        object = this.calendar.getTime();
                    }
                    catch (NumberFormatException timestampBytes) {}
                    break;
                }
                case 'N': 
                case 'n': {
                    if (this.bytes[fieldOffset] == 42) break;
                    String string = this.fastParse(this.bytes, fieldOffset, fieldLen).trim();
                    Class<Object> clazz = this.header.getFieldClass(fieldNum);
                    if (clazz == Integer.class) {
                        try {
                            object = Integer.parseInt(string);
                            break;
                        }
                        catch (NumberFormatException e) {
                            clazz = Long.class;
                        }
                    }
                    if (clazz == Long.class) {
                        try {
                            object = Long.parseLong(string);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                }
                case 'F': 
                case 'f': {
                    if (this.bytes[fieldOffset] == 42) break;
                    try {
                        object = Double.parseDouble(this.fastParse(this.bytes, fieldOffset, fieldLen));
                    }
                    catch (NumberFormatException e) {
                        object = null;
                    }
                    break;
                }
                default: {
                    throw new IOException("Invalid field type : " + type);
                }
            }
        }
        return object;
    }

    String fastParse(byte[] bytes, int fieldOffset, int fieldLen) {
        char[] chars = new char[fieldLen];
        for (int i = 0; i < fieldLen; ++i) {
            chars[i] = (char)(0xFF & bytes[fieldOffset + i]);
        }
        return new String(chars);
    }

    public static void main(String[] args) throws Exception {
        try (DbaseFileReader reader = new DbaseFileReader(new ShpFiles(args[0]), false, Charset.forName("ISO-8859-1"), null);){
            System.out.println(reader.getHeader());
            int r = 0;
            while (reader.hasNext()) {
                System.out.println(++r + "," + Arrays.asList(reader.readEntry()));
            }
        }
    }

    @Override
    public String id() {
        return this.getClass().getName();
    }

    public final class Row {
        boolean deleted;

        public Object read(int column) throws IOException {
            int offset = DbaseFileReader.this.fieldOffsets[column];
            return DbaseFileReader.this.readObject(offset, column);
        }

        public String toString() {
            StringBuffer ret = new StringBuffer("DBF Row - ");
            for (int i = 0; i < DbaseFileReader.this.header.getNumFields(); ++i) {
                ret.append(DbaseFileReader.this.header.getFieldName(i)).append(": \"");
                try {
                    ret.append(this.read(i));
                }
                catch (IOException ioe) {
                    ret.append(ioe.getMessage());
                }
                ret.append("\" ");
            }
            return ret.toString();
        }

        public boolean isDeleted() {
            return this.deleted;
        }
    }
}

